/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDCallRO;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDCallRW;
import java.util.List;

public class RAFixUMLSDCallAfterModifyEdge
implements IRAChangeGeometryFigure {
    private static final double LENGTH_TO_ENFORCE = 10.0;

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(2);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMPlanElementUMLSDCallRO planElement;
        IPMFigureLineShapeRW edge = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementUMLSDCallRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigureLineShapeRW)) {
            route &= false;
        }
        if (route) {
            IPMFigureLineShapeRW lineShape = (IPMFigureLineShapeRW)figure;
            if (!lineShape.getRole().equals("outline")) {
                route &= false;
            }
            if (route) {
                edge = lineShape;
            }
        }
        if (edge != null && (planElement = (IPMPlanElementUMLSDCallRO)edge.getPlanElementRW()).getOutlineFigureLineShapeRO().getPointListRO().getPointCount() == 4) {
            IPMPointRO point0 = planElement.getOutlineFigureRO().getPointListRO().getPointRO(0);
            IPMPointRO point1 = planElement.getOutlineFigureRO().getPointListRO().getPointRO(1);
            IPMPointRO point3 = planElement.getOutlineFigureRO().getPointListRO().getPointRO(3);
            IPMLineRO lineToMove = point1.getLine2ndRO();
            double wishedX1 = point0.getPosition().x + 10.0;
            double wishedX2 = point3.getPosition().x + 10.0;
            double forcedX = Math.max(wishedX1, wishedX2);
            double currentX = point1.getPosition().x;
            double delta = forcedX - currentX;
            boolean removeSourceAnchorings = false;
            GeoVector distanceToMove = new GeoVector(delta, 0.0);
            Action moveLineAction = ActionFactory.createACMoveLine((ActionContext)actionContext, (IPMLineRW)((IPMLineRW)lineToMove), (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
            actions.addAction(moveLineAction);
        }
    }
}

