/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Line;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.routing.KeepHorizontalPositionOnFigureRouter;
import com.arcway.planagent.planmodel.cm.routing.KeepHorizontalPositionOnLineRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import com.arcway.planagent.planmodel.uml.sd.check.SDValidityMatrix;

public class PMPlanUMLSD
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "uml.sd";
    private static String XML_TYPE = "uml.sd";

    public PMPlanUMLSD(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public PMPlanUMLSD(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return new String[]{"uml.sd.object", "uml.sd.activationbox", "uml.sd.call", "fmc.cm.dotscomment", "fmc.cm.lineshapecomment", "fmc.cm.legend", "fmc.cm.planecomment"};
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = false;
        return isDesirable |= SDValidityMatrix.isTouchValid();
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= SDValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= SDValidityMatrix.isPointToPointAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationPoint)destination);
            }
            if (destination instanceof IAnchoringDestinationLine) {
                isAllowed |= SDValidityMatrix.isPointToLineAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationLine)destination);
            }
        }
        return isAllowed;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router = anchoring instanceof IAnchoringPoint2Figure ? new KeepHorizontalPositionOnFigureRouter() : (anchoring instanceof IAnchoringPoint2Line ? new KeepHorizontalPositionOnLineRouter() : (anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : new RemoveAnchoringRouter()));
        return router;
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        boolean nestingAllowed = false;
        return nestingAllowed;
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public FlowType getFlowType() {
        return FlowType.VERTICAL;
    }
}

