/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com;

import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitValueReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IParameterForSetField;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementNameChecker;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.ole.hpqc.enums.tagTDAPI_DATATYPES;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryStringDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTFloat64BitIEEE754;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTURL;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.ole.win32.Variant;

public class HPQCDataConverter {
    public static final Variant convertAttribute(IParameterForSetField valueToSet, int qcDataType, List<String> qcListValues) {
        switch (valueToSet.getType()) {
            case Property: {
                return HPQCDataConverter.convertAttribute(valueToSet.getObjectTypeID(), valueToSet.getPropertyTypeID(), valueToSet.getPropertySample(), qcDataType, qcListValues, valueToSet.getEnumValueMapping(), valueToSet.isNameField(), valueToSet.getRequirementNameChecker(), valueToSet.getTypeManager(), valueToSet.getPresentationContext());
            }
            case LinkedAttribute: {
                return HPQCDataConverter.convertAttribute(valueToSet.getObjectID(), valueToSet.getRelationTypeID(), valueToSet.getRoleID(), valueToSet.getRepositorySnippet(), qcDataType, qcListValues, valueToSet.getEnumValueMapping(), valueToSet.isNameField(), valueToSet.getRequirementNameChecker(), valueToSet.getTypeManager(), valueToSet.getPresentationContext());
            }
        }
        assert (false);
        return new Variant();
    }

    private static final Variant convertAttribute(IRepositoryObjectTypeID cockpitObjectTypeID, IRepositoryPropertyTypeID cockpitPropertyTypeID, IRepositoryPropertySample cockpitPropertySample, int qcDataType, List<String> qcListValues, EnumValueMapping<CockpitValueReference, String> enumValueMapping, boolean isNameField, IRequirementNameChecker requirementNameChecker, IRepositoryTypeManagerRO typeManager, PresentationContext presentationContext) {
        IRepositoryData cockpitValue = cockpitPropertySample.getValue();
        IRepositoryDataType cockpitDataType = cockpitValue.getDataType();
        if (cockpitDataType instanceof AbstractRepositoryStringDataType) {
            AbstractRepositoryStringDataType stringDataType = (AbstractRepositoryStringDataType)cockpitDataType;
            String javaValue = stringDataType.dataToValue(cockpitValue);
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() && (cockpitDataType instanceof RDTDisplayName || cockpitDataType instanceof RDTFreeString || cockpitDataType instanceof RDTUID)) {
                return new Variant(HPQCDataConverter.checkName(javaValue, isNameField, requirementNameChecker));
            }
        } else if (cockpitDataType instanceof RDTFloat64BitIEEE754) {
            RDTFloat64BitIEEE754 floatDataType = (RDTFloat64BitIEEE754)cockpitDataType;
            Double javaValue = floatDataType.dataToValue(cockpitValue);
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return new Variant(HPQCDataConverter.checkName(javaValue.toString(), isNameField, requirementNameChecker));
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_FLOAT.getValue()) {
                return new Variant(javaValue.doubleValue());
            }
        } else if (cockpitDataType instanceof RDTInteger32Bit) {
            RDTInteger32Bit integerDataType = (RDTInteger32Bit)cockpitDataType;
            Integer javaValue = integerDataType.dataToValue(cockpitValue);
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return new Variant(HPQCDataConverter.checkName(javaValue.toString(), isNameField, requirementNameChecker));
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_FLOAT.getValue()) {
                return new Variant(javaValue.doubleValue());
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_LONG.getValue()) {
                return new Variant(javaValue.longValue());
            }
        } else if (cockpitDataType instanceof RDTInteger64Bit) {
            RDTInteger64Bit integerDataType = (RDTInteger64Bit)cockpitDataType;
            Long javaValue = integerDataType.dataToValue(cockpitValue);
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return new Variant(HPQCDataConverter.checkName(javaValue.toString(), isNameField, requirementNameChecker));
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_FLOAT.getValue()) {
                return new Variant(javaValue.doubleValue());
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_LONG.getValue()) {
                return new Variant(javaValue.longValue());
            }
        } else if (cockpitDataType instanceof RDTBoolean) {
            RDTBoolean booleanDataType = (RDTBoolean)cockpitDataType;
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return HPQCDataConverter.getDisplayStringForCockpitValue(cockpitObjectTypeID, cockpitPropertyTypeID, cockpitDataType, cockpitValue, isNameField, requirementNameChecker, typeManager, presentationContext);
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_TREENODE.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_USER_LIST.getValue()) {
                Boolean javaValue = booleanDataType.dataToValue(cockpitValue);
                CockpitValueReference cockpitValueReference = new CockpitValueReference(CockpitValueReference.ValueType.Boolean, javaValue);
                return HPQCDataConverter.getMappedEnumValue(cockpitValueReference, enumValueMapping, qcListValues);
            }
        } else if (cockpitDataType instanceof RDTDateUTC64Bitmsec) {
            RDTDateUTC64Bitmsec dateDataType = (RDTDateUTC64Bitmsec)cockpitDataType;
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return HPQCDataConverter.getDisplayStringForCockpitValue(cockpitObjectTypeID, cockpitPropertyTypeID, cockpitDataType, cockpitValue, isNameField, requirementNameChecker, typeManager, presentationContext);
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_DATE.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_DATETIME.getValue()) {
                Date javaValue = dateDataType.dataToValue(cockpitValue);
                return TypeUtils.convertFromDate((Date)javaValue);
            }
        } else if (cockpitDataType instanceof RDTURL) {
            RDTURL urlDataType = (RDTURL)cockpitDataType;
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                URL javaValue = urlDataType.dataToValue(cockpitValue);
                String javaStringValue = javaValue != null ? javaValue.toExternalForm() : "";
                return new Variant(HPQCDataConverter.checkName(javaStringValue, isNameField, requirementNameChecker));
            }
        } else if (cockpitDataType instanceof RDTSingleChoice) {
            RDTSingleChoice singleChoiceDataType = (RDTSingleChoice)cockpitDataType;
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return HPQCDataConverter.getDisplayStringForCockpitValue(cockpitObjectTypeID, cockpitPropertyTypeID, cockpitDataType, cockpitValue, isNameField, requirementNameChecker, typeManager, presentationContext);
            }
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_TREENODE.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_USER_LIST.getValue()) {
                String enumValue = singleChoiceDataType.dataToValue(cockpitValue);
                CockpitValueReference cockpitValueReference = new CockpitValueReference(CockpitValueReference.ValueType.Enumeration, enumValue);
                return HPQCDataConverter.getMappedEnumValue(cockpitValueReference, enumValueMapping, qcListValues);
            }
        } else if (cockpitDataType instanceof RDTMultipleChoice && (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue())) {
            return HPQCDataConverter.getDisplayStringForCockpitValue(cockpitObjectTypeID, cockpitPropertyTypeID, cockpitDataType, cockpitValue, isNameField, requirementNameChecker, typeManager, presentationContext);
        }
        assert (false) : "Unsupported Cockpit data type or invalid QC target data type";
        return null;
    }

    private static Variant convertAttribute(IRepositoryPropertySetSample cockpitObjectID, IRepositoryRelationTypeID cockpitRelationTypeID, IRepositoryRelationContributionRoleID cockpitRoleID, IRepositorySnippetRO repositorySnippet, int qcDataType, List<String> qcListValues, EnumValueMapping<CockpitValueReference, String> enumValueMapping, boolean isNameField, IRequirementNameChecker requirementNameChecker, IRepositoryTypeManagerRO typeManager, PresentationContext presentationContext) {
        for (ICrossLinkRepositoryRelationSample relationSample : repositorySnippet.getCrossLinkRelations()) {
            if (!IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER.isEqual((Object)relationSample.getRelationTypeID(), (Object)cockpitRelationTypeID) || !IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)relationSample.getObjectID(cockpitRoleID), (Object)cockpitObjectID)) continue;
            IRepositoryPropertySetSample linkedAttributeObjectID = null;
            IRepositoryRelationContributionRoleID linkedAttributeObjectRoleID = null;
            for (IRepositoryRelationContributionRoleID roleID : relationSample.getRelationContributionRoleIDs()) {
                if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID, (Object)cockpitRoleID)) continue;
                linkedAttributeObjectID = relationSample.getObjectID(roleID);
                linkedAttributeObjectRoleID = roleID;
                break;
            }
            ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType(cockpitRelationTypeID);
            ICrossLinkRepositoryRelationContributionType linkedAttributeContributionType = relationType.getRelationContributionType(linkedAttributeObjectRoleID);
            IRepositoryObjectType linkedAttributeInterfaceObjectType = linkedAttributeContributionType.getRelatedObjectType();
            IRepositoryObjectSample linkedAttributeObjectSample = HPQCDataConverter.findLinkedAttributeObjectInSnippet(linkedAttributeObjectID, linkedAttributeInterfaceObjectType, repositorySnippet, typeManager);
            assert (linkedAttributeObjectSample != null);
            if (qcDataType == tagTDAPI_DATATYPES.TDOLE_STRING.getValue() || qcDataType == tagTDAPI_DATATYPES.TDOLE_MEMO.getValue()) {
                return HPQCDataConverter.getDisplayStringForLinkedAttributeValue(linkedAttributeObjectSample, isNameField, requirementNameChecker, typeManager, presentationContext);
            }
            if (qcDataType != tagTDAPI_DATATYPES.TDOLE_TREENODE.getValue() && qcDataType != tagTDAPI_DATATYPES.TDOLE_USER_LIST.getValue()) continue;
            CockpitValueReference cockpitValueReference = new CockpitValueReference(CockpitValueReference.ValueType.LinkedAttribute, new CockpitValueReference.ObjectReferenceAndTypeManager((IRepositoryObjectReference)new RepositoryObjectReference(linkedAttributeObjectSample.getObjectTypeID(), linkedAttributeObjectID), typeManager));
            return HPQCDataConverter.getMappedEnumValue(cockpitValueReference, enumValueMapping, qcListValues);
        }
        return null;
    }

    public static Variant getDefaultValue(int dataType, List<String> listValues, String defaultStringValue) {
        if (dataType == 3 || dataType == 4) {
            String value = defaultStringValue != null && !defaultStringValue.equals("") ? defaultStringValue : "-";
            return new Variant(value);
        }
        if (dataType == 2) {
            return new Variant(0.0f);
        }
        if (dataType == 0) {
            return new Variant(0);
        }
        if (dataType == 7 || dataType == 8) {
            return new Variant(listValues.get(0));
        }
        if (dataType == 5 || dataType == 25) {
            return TypeUtils.convertFromDate((Date)new Date(0L));
        }
        assert (false) : "Unknown data type";
        return new Variant();
    }

    private static Variant getMappedEnumValue(CockpitValueReference cockpitValueReference, EnumValueMapping<CockpitValueReference, String> enumValueMapping, List<String> qcListValues) {
        String qcValueID = (String)enumValueMapping.getByKey((Object)cockpitValueReference);
        if (qcValueID != null && !qcValueID.equals("") && qcListValues.contains(qcValueID)) {
            return new Variant(qcValueID);
        }
        return new Variant();
    }

    private static Variant getDisplayStringForCockpitValue(IRepositoryObjectTypeID cockpitObjectTypeID, IRepositoryPropertyTypeID cockpitPropertyTypeID, IRepositoryDataType cockpitDataType, IRepositoryData cockpitValue, boolean isNameField, IRequirementNameChecker requirementNameChecker, IRepositoryTypeManagerRO typeManager, PresentationContext presentationContext) {
        IRepositoryObjectType objectType = typeManager.getObjectType(cockpitObjectTypeID);
        IRepositoryPropertyType propertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)cockpitPropertyTypeID);
        IRepositoryDataTypeParameters dataTypeParameters = propertyType.getDataTypeParameters();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager);
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(propertyType);
        IFrontendDataTypeParameters frontendDataTypeParameters = frontendPropertyType.getFrontendDataTypeParameters();
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(cockpitDataType);
        IFrontendLabel label = frontendDataType.getLabelForValue(cockpitValue, dataTypeParameters, frontendDataTypeParameters, presentationContext);
        return new Variant(HPQCDataConverter.checkName(label.getText(), isNameField, requirementNameChecker));
    }

    private static IRepositoryObjectSample findLinkedAttributeObjectInSnippet(IRepositoryPropertySetSample linkedAttributeObjectID, IRepositoryObjectType linkedAttributeInterfaceObjectType, IRepositorySnippetRO repositorySnippet, IRepositoryTypeManagerRO typeManager) {
        for (RepositoryObjectSampleWithParentObjectReference objectSample : repositorySnippet.getExplicitObjects()) {
            if (!HPQCDataConverter.checkLinkedAttributeObjectInSnippet(objectSample.getObjectSample(), linkedAttributeObjectID, linkedAttributeInterfaceObjectType, typeManager)) continue;
            return objectSample.getObjectSample();
        }
        for (RepositoryObjectSampleWithParentObjectReference objectSample : repositorySnippet.getImplicitObjects()) {
            if (!HPQCDataConverter.checkLinkedAttributeObjectInSnippet(objectSample.getObjectSample(), linkedAttributeObjectID, linkedAttributeInterfaceObjectType, typeManager)) continue;
            return objectSample.getObjectSample();
        }
        for (RepositoryObjectSampleWithParentObjectReference objectSample : repositorySnippet.getContextObjects()) {
            if (!HPQCDataConverter.checkLinkedAttributeObjectInSnippet((IRepositoryObjectSample)objectSample, linkedAttributeObjectID, linkedAttributeInterfaceObjectType, typeManager)) continue;
            return objectSample;
        }
        return null;
    }

    private static boolean checkLinkedAttributeObjectInSnippet(IRepositoryObjectSample potentialLinkedAttributeObject, IRepositoryPropertySetSample linkedAttributeObjectID, IRepositoryObjectType linkedAttributeInterfaceObjectType, IRepositoryTypeManagerRO typeManager) {
        IRepositoryObjectType objectTypeOfPotentialLinkedAttributeObject = typeManager.findObjectType(potentialLinkedAttributeObject.getObjectTypeID());
        return linkedAttributeInterfaceObjectType.isSuperTypeOf(objectTypeOfPotentialLinkedAttributeObject) && IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)potentialLinkedAttributeObject.getObjectID(typeManager), (Object)linkedAttributeObjectID);
    }

    private static Variant getDisplayStringForLinkedAttributeValue(IRepositoryObjectSample linkedAttributeObject, boolean isNameField, IRequirementNameChecker requirementNameChecker, IRepositoryTypeManagerRO typeManager, PresentationContext presentationContext) {
        String displayString = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager).getLabelForObject(linkedAttributeObject, presentationContext).getText();
        return new Variant(HPQCDataConverter.checkName(displayString, isNameField, requirementNameChecker));
    }

    private static String checkName(String actualName, boolean isNameField, IRequirementNameChecker requirementNameChecker) {
        if (isNameField) {
            String nameWithoutInvalidCharacters = actualName.replaceAll("[\\*\\^\\\\]", "_");
            return requirementNameChecker.checkRequirementName(nameWithoutInvalidCharacters);
        }
        return actualName;
    }
}

