/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.exporter;

import com.arcway.cockpit.rqm3.qualitycenteradapter.Messages;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.ui.AttributeMappingConfigurationHelper;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.ExportCache;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IField;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IFieldOfRequirementType;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IProject;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementType;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeMappingWidget;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

public class QualityCenterConfigurationChecker {
    public static Tuple<String, String> checkConfiguration(IConfigurationRO configuration, final ExportCache cache, ICollection_<IRepositoryObjectTypeID> objectTypesToExport, IProject qcProject) {
        IField technicalIDField = null;
        if (configuration.getQCFieldIDForCockpitTechnicalID() != null && configuration.getQCFieldIDForCockpitTechnicalID().trim().length() > 0) {
            technicalIDField = qcProject.getRequirementField(configuration.getQCFieldIDForCockpitTechnicalID());
        }
        boolean isUsingCockpitMetaData = configuration.isUsingCockpitMetaData();
        ISourceAttributeDescription_forEnumValueMapping<String> sourceAttributeDescriptionForAuthorMapping = null;
        EnumValueMapping<String, String> authorMapping = null;
        if (isUsingCockpitMetaData) {
            sourceAttributeDescriptionForAuthorMapping = cache.getSourceAttributeDescriptionForAuthorMapping();
            authorMapping = cache.getAuthorMapping();
        }
        ArrayList<Tuple<IRequirementType, ITechnicalIDFieldAgainstAttributeMappingChecker>> mappingConfigurations_Part1 = new ArrayList<Tuple<IRequirementType, ITechnicalIDFieldAgainstAttributeMappingChecker>>();
        ArrayList<1> mappingConfigurations_Part2 = new ArrayList<1>();
        for (IRepositoryObjectTypeID objectTypeToExport : objectTypesToExport) {
            cache.setObjectTypeID(objectTypeToExport);
            IRequirementType qcRequirementType = cache.getRequirementType();
            IAttributeMappingChecker attributeMappingChecker = new IAttributeMappingChecker(){

                @Override
                public ThreeTuple<Boolean, String, String> checkAttributeMapping() {
                    return AttributeMappingWidget.isAttributeMappingComplete(cache.getAttributeMap(), cache.getEnumValueMappingMap(), cache.getSourceAttributeDescriptions(), cache.getTargetAttributeDescriptions(), AttributeMappingConfigurationHelper.getSettings(), (ITargetAttributeDescription)cache.getMarkerFor_NoMapping_());
                }

                @Override
                public ICollection_<? extends ITargetAttributeDescription<String, Integer, String>> getMappedTargetAttributes() {
                    return cache.getAttributeMap().values();
                }
            };
            ITechnicalIDFieldAgainstAttributeMappingChecker technicalIDFieldChecker = new ITechnicalIDFieldAgainstAttributeMappingChecker(){

                @Override
                public boolean checkTechnicalIDFieldAgainstAttributeMapping(IField technicalIDField_) {
                    for (ITargetAttributeDescription mappedTragetAttribute : cache.getAttributeMap().values()) {
                        if (!((String)mappedTragetAttribute.getKey()).equals(technicalIDField_.getID())) continue;
                        return false;
                    }
                    return true;
                }
            };
            mappingConfigurations_Part1.add((Tuple<IRequirementType, ITechnicalIDFieldAgainstAttributeMappingChecker>)new Tuple((Object)qcRequirementType, (Object)technicalIDFieldChecker));
            mappingConfigurations_Part2.add(attributeMappingChecker);
        }
        Tuple<String, String> problemAndWarningMessage = QualityCenterConfigurationChecker.checkGeneralConfiguration(technicalIDField, isUsingCockpitMetaData, configuration.isUsingAuthorMapping(), qcProject, sourceAttributeDescriptionForAuthorMapping, authorMapping, mappingConfigurations_Part1);
        int index = 0;
        while (index < mappingConfigurations_Part1.size()) {
            Tuple<String, String> newProblemAndWarningMessage = QualityCenterConfigurationChecker.checkPerTypeConfiguration((IRequirementType)((Tuple)mappingConfigurations_Part1.get(index)).getT1(), (IAttributeMappingChecker)mappingConfigurations_Part2.get(index), false, technicalIDField, (ITechnicalIDFieldAgainstAttributeMappingChecker)((Tuple)mappingConfigurations_Part1.get(index)).getT2(), qcProject);
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, newProblemAndWarningMessage);
            ++index;
        }
        return problemAndWarningMessage;
    }

    public static Tuple<String, String> checkGeneralConfiguration(IField technicalIDField, boolean isUsingCockpitMetaData, boolean isUsingAuthorMapping, IProject qcProject, ISourceAttributeDescription_forEnumValueMapping<String> sourceAttributeForAuthorMapping, EnumValueMapping<String, String> authorMapping, Collection<Tuple<IRequirementType, ITechnicalIDFieldAgainstAttributeMappingChecker>> mappingConfigurations) {
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (isUsingCockpitMetaData) {
            if (isUsingAuthorMapping) {
                for (EnumValue enumValue : sourceAttributeForAuthorMapping.getValueRange()) {
                    if (authorMapping.getByKey((Object)((String)enumValue.getId())) != null) continue;
                    String problemMessage = Messages.getString("ConfigurationPage.MetaAttributes.Author.Error.IncompleteMappings");
                    problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
                    break;
                }
            } else if (qcProject.getRequirementField("RQ_REQ_AUTHOR").isVerifiedListField()) {
                String string = Messages.getString("ConfigurationPage.MetaAttributes.AuthorMapping.Error.AuthorIsVerifiedValue");
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
            }
        }
        if (technicalIDField == null) {
            String string = Messages.getString("ConfigurationPage.TechnicalIDField.Error.NoTechnicalIDFieldSelected");
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)string, null));
        } else {
            for (Tuple tuple : mappingConfigurations) {
                Tuple<String, String> newProblemAndWarningMessage = QualityCenterConfigurationChecker.checkCockpitTechnicalIDField(technicalIDField, (ITechnicalIDFieldAgainstAttributeMappingChecker)tuple.getT2(), (IRequirementType)tuple.getT1());
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, newProblemAndWarningMessage);
            }
            if (technicalIDField.getMaximumLength() < 255) {
                String string = Messages.getString("ConfigurationPage.TechnicalIDField.Warning.LessThan255Characters");
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
            }
        }
        if (!qcProject.hasConnectedUserRightToAddRequirements()) {
            String string = Messages.getString("ConfigurationPage.Permissions.AddRequirement.NoPermissionWarning");
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
        }
        if (!qcProject.hasConnectedUserRightToModifyRequirements()) {
            String string = Messages.getString("ConfigurationPage.Permissions.ModifyRequirement.NoPermissionWarning");
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
        }
        if (technicalIDField != null && !qcProject.hasConnectedUserRightToModifyRequirementField(technicalIDField.getID())) {
            String string = NLS.bind((String)Messages.getString("ConfigurationPage.Permissions.ModifyRequirementField.NoPermissionWarning"), (Object)technicalIDField.getName());
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)string));
        }
        return problemAndWarningMessage;
    }

    public static Tuple<String, String> checkPerTypeConfiguration(IRequirementType requirementType, IAttributeMappingChecker attributeMappingChecker, boolean detailedMessageForAttributeMappings, IField technicalIDField, ITechnicalIDFieldAgainstAttributeMappingChecker technicalIDFieldChecker, IProject qcProject) {
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (requirementType == null) {
            String problemMessage = Messages.getString("QualityCenterExporter.Failure.IncompleteMappings");
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
        } else {
            ThreeTuple<Boolean, String, String> isAttributeMappingComplete = attributeMappingChecker.checkAttributeMapping();
            if (!((Boolean)isAttributeMappingComplete.getComponent1()).booleanValue()) {
                String problemMessage = null;
                problemMessage = detailedMessageForAttributeMappings ? (String)isAttributeMappingComplete.getComponent2() : Messages.getString("QualityCenterExporter.Failure.IncompleteMappings");
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
            } else if (isAttributeMappingComplete.getComponent3() != null) {
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)((String)isAttributeMappingComplete.getComponent3())));
            }
            if (technicalIDField != null) {
                Tuple<String, String> newProblemAndWarningMessage = QualityCenterConfigurationChecker.checkCockpitTechnicalIDField(technicalIDField, technicalIDFieldChecker, requirementType);
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, newProblemAndWarningMessage);
            }
            for (ITargetAttributeDescription targetAttribute : attributeMappingChecker.getMappedTargetAttributes()) {
                String warningMessage;
                if ((Integer)targetAttribute.getDataTypeKey() == 1000) {
                    if (qcProject.hasConnectedUserRightToModifyRequirementAttachments()) continue;
                    warningMessage = Messages.getString("ConfigurationPage.Permissions.ModifyRequirementAttachments.NoPermissionWarning");
                    problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)warningMessage));
                    continue;
                }
                if (qcProject.hasConnectedUserRightToModifyRequirementField((String)targetAttribute.getKey())) continue;
                warningMessage = NLS.bind((String)Messages.getString("ConfigurationPage.Permissions.ModifyRequirementField.NoPermissionWarning"), (Object)targetAttribute.getName());
                problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)warningMessage));
            }
        }
        return problemAndWarningMessage;
    }

    private static Tuple<String, String> checkCockpitTechnicalIDField(IField technicalIDField, ITechnicalIDFieldAgainstAttributeMappingChecker technicalIDFieldChecker, IRequirementType qcRequirementType) {
        IFieldOfRequirementType technicalIDFieldInRequirementType;
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (!technicalIDFieldChecker.checkTechnicalIDFieldAgainstAttributeMapping(technicalIDField)) {
            String problemMessage = Messages.getString("MappingConfigurationPage.TechnicalIDField.Error.FieldIsAlreadyUsedForOtherData");
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple((Object)problemMessage, null));
        }
        if ((technicalIDFieldInRequirementType = qcRequirementType.getField(technicalIDField.getID())) == null) {
            String warningMessage = Messages.getString("MappingConfigurationPage.TechnicalIDField.Error.FieldIsNotActiveInQCRequirementType");
            problemAndWarningMessage = QualityCenterConfigurationChecker.mergeProblemAndWarningMessage(problemAndWarningMessage, (Tuple<String, String>)new Tuple(null, (Object)warningMessage));
        }
        return problemAndWarningMessage;
    }

    private static Tuple<String, String> mergeProblemAndWarningMessage(Tuple<String, String> currentMessages, Tuple<String, String> newMessages) {
        if (currentMessages.getT1() == null) {
            if (newMessages.getT1() != null || newMessages.getT2() != null && currentMessages.getT2() == null) {
                return newMessages;
            }
            return currentMessages;
        }
        return currentMessages;
    }

    public static interface IAttributeMappingChecker {
        public ThreeTuple<Boolean, String, String> checkAttributeMapping();

        public ICollection_<? extends ITargetAttributeDescription<String, Integer, String>> getMappedTargetAttributes();
    }

    public static interface ITechnicalIDFieldAgainstAttributeMappingChecker {
        public boolean checkTechnicalIDFieldAgainstAttributeMapping(IField var1);
    }
}

