/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.exporter;

import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.Messages;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitAttributeReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitDataTypeReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitValueReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.IMappingConfigurationRO;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.ui.AttributeMappingConfigurationHelper;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.ui.TargetAttributeDescription;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.QualityCenterExporter;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.CheckOutException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.CommitException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IProject;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirement;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementType;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeAndEnumValueMappings;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeMappingWidget;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportCache {
    private static final ILogger LOGGER = Logger.getLogger(ExportCache.class);
    private final IMapRW_<Integer, IRequirementType> map_qcRequirementTypeID_qcRequirementType = new HashMap_(IHasher_.EQUALS_HASHER);
    private final IMapRW_<IRepositoryObjectTypeID, AttributeAndEnumValueMappings<CockpitAttributeReference, CockpitValueReference, String, Integer, String>> attributeAndEnumValueMappingsCache = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    private final IMapRW_<IRepositoryObjectTypeID, IList_<? extends ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference>>> sourceAttributeDescriptionCache = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    private final IMapRW_<IRepositoryObjectTypeID, IMap_<CockpitAttributeReference, ? extends ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference>>> sourceAttributeDescriptionCache_asMapByCockpitAttribute = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    private final IMapRW_<Integer, IList_<? extends ITargetAttributeDescription<String, Integer, String>>> targetAttributeDescriptionCache = new HashMap_(IHasher_.EQUALS_HASHER);
    private final IProject currentQCProject;
    private final IRepositorySnippetRO repositorySnippet;
    private final ICollection_<IRepositoryObjectTypeID> objectTypesToBeExported;
    private final IRepositoryTypeManagerRO typeManager;
    private final ILocksAndPermissionsManagerDeprecated deprecationManager;
    private final TargetAttributeDescription NO_MAPPING;
    private final IConfigurationRO currentConfiguration;
    private final String config_qcFieldIDForCockpitTechnicalID;
    private final boolean config_isUsingCockpitMetaAttributes;
    private final boolean config_isUsingCockpitModificationMetaAttributes;
    private final boolean config_isUsingAuthorMapping;
    private ISourceAttributeDescription_forEnumValueMapping<String> sourceAttributeDescriptionForAuthorMapping;
    private ITargetAttributeDescription_forEnumValueMapping<String> targetAttributeDescriptionForAuthorMapping;
    private EnumValueMapping<String, String> authorMapping;
    private final HashMap<Long, List<IRequirement>> map_qcParent_children = new HashMap();
    private final HashMap<Long, ISetRW_<String>> map_qcParent_requirementNamesInUseByChildren = new HashMap();
    private final Map<String, IRequirement> map_cockpitTechnicalID_qcRequirement = new HashMap<String, IRequirement>();
    private final Map<Long, IRequirement> map_qcRequirementID_checkedOutQCRequirement = new HashMap<Long, IRequirement>();
    private IRepositoryObjectTypeID objectTypeID = null;
    private IMappingConfigurationRO mappingConfiguration = null;
    private IList_<? extends ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference>> sourceAttributeDescriptionsForObjectType;
    private IMap_<CockpitAttributeReference, ? extends ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference>> sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute;
    private IList_<? extends ITargetAttributeDescription<String, Integer, String>> targetAttributeDescriptionsForObjectType;

    public ExportCache(IConfigurationRO currentConfiguration, IProject currentQCProject, IRepositorySnippetRO repositorySnippet, ICollection_<IRepositoryObjectTypeID> objectTypesToBeExported, IRepositoryTypeManagerRO typeManager, ILocksAndPermissionsManagerDeprecated deprecationManager, TargetAttributeDescription NO_MAPPING) {
        this.currentConfiguration = currentConfiguration;
        this.currentQCProject = currentQCProject;
        this.repositorySnippet = repositorySnippet;
        this.objectTypesToBeExported = objectTypesToBeExported;
        this.typeManager = typeManager;
        this.deprecationManager = deprecationManager;
        this.NO_MAPPING = NO_MAPPING;
        this.config_qcFieldIDForCockpitTechnicalID = currentConfiguration.getQCFieldIDForCockpitTechnicalID();
        this.config_isUsingCockpitMetaAttributes = currentConfiguration.isUsingCockpitMetaData();
        this.config_isUsingCockpitModificationMetaAttributes = currentConfiguration.isUsingCockpitModificationMetaData();
        this.config_isUsingAuthorMapping = currentConfiguration.isUsingAuthorMapping();
    }

    public TargetAttributeDescription getMarkerFor_NoMapping_() {
        return this.NO_MAPPING;
    }

    public IRepositoryTypeManagerRO getTypeManager() {
        return this.typeManager;
    }

    protected IRepositorySnippetRO getSnippet() {
        return this.repositorySnippet;
    }

    protected ILocksAndPermissionsManagerDeprecated getDeprecationManager() {
        return this.deprecationManager;
    }

    public String getQcFieldIDForCockpitTechnicalID() {
        return this.config_qcFieldIDForCockpitTechnicalID;
    }

    protected boolean isUsingCockpitMetaAttributes() {
        return this.config_isUsingCockpitMetaAttributes;
    }

    protected boolean isUsingCockpitModificationMetaAttributes() {
        return this.config_isUsingCockpitModificationMetaAttributes;
    }

    protected boolean isUsingAuthorMapping() {
        return this.config_isUsingAuthorMapping;
    }

    public ISourceAttributeDescription_forEnumValueMapping<String> getSourceAttributeDescriptionForAuthorMapping() {
        if (this.sourceAttributeDescriptionForAuthorMapping == null) {
            this.sourceAttributeDescriptionForAuthorMapping = AttributeMappingConfigurationHelper.getSourceAttributeDescriptionForAuthorMapping(this.repositorySnippet, this.typeManager, this.deprecationManager, this.objectTypesToBeExported);
        }
        return this.sourceAttributeDescriptionForAuthorMapping;
    }

    public ITargetAttributeDescription_forEnumValueMapping<String> getTargetAttributeDescriptionForAuthorMapping() {
        if (this.targetAttributeDescriptionForAuthorMapping == null) {
            this.targetAttributeDescriptionForAuthorMapping = AttributeMappingConfigurationHelper.getTargetAttributeDescriptionForAuthorMapping(this.currentQCProject);
        }
        return this.targetAttributeDescriptionForAuthorMapping;
    }

    public EnumValueMapping<String, String> getAuthorMapping() {
        if (this.authorMapping == null) {
            this.authorMapping = AttributeMappingWidget.loadEnumValueMapping((IArcwayMemento)this.currentConfiguration.getAuthorMapping(), this.getSourceAttributeDescriptionForAuthorMapping(), this.getTargetAttributeDescriptionForAuthorMapping(), AttributeMappingConfigurationHelper.getSettingsForAuthorMapping(), AttributeMappingConfigurationHelper.getPersistencyHelperForAuthorMapping());
        }
        return this.authorMapping;
    }

    public ISetRW_<String> getRequirementNamesInUseByChildren(long parentRequirementID) {
        Long parentID = parentRequirementID;
        HashSet_ reqNamesInUse = this.map_qcParent_requirementNamesInUseByChildren.get(parentID);
        if (reqNamesInUse == null) {
            reqNamesInUse = new HashSet_(StringUtil.EQUALS_IGNORE_CASE_HASHER);
            List<IRequirement> children = this.map_qcParent_children.get(parentID);
            if (children != null) {
                for (IRequirement existingChildInQC : children) {
                    reqNamesInUse.add((Object)existingChildInQC.getName());
                }
            }
            this.map_qcParent_requirementNamesInUseByChildren.put(parentID, (ISetRW_<String>)reqNamesInUse);
        }
        return reqNamesInUse;
    }

    public void setupRequirementsCache(IRequirement rootRequirement) {
        this.setupRequirementsCache(rootRequirement, true);
    }

    private void setupRequirementsCache(IRequirement requirement, boolean isRootRequirement) {
        if (!isRootRequirement) {
            this.cacheRequirementByCockpitID(requirement);
        }
        this.cacheRequirementChildren(requirement);
        for (IRequirement childRequirement : this.map_qcParent_children.get(requirement.getId())) {
            this.setupRequirementsCache(childRequirement, false);
        }
    }

    private void cacheRequirementByCockpitID(IRequirement requirement) {
        String technicalID = (String)requirement.getFieldValue(this.config_qcFieldIDForCockpitTechnicalID);
        if (!this.map_cockpitTechnicalID_qcRequirement.containsKey(technicalID)) {
            this.map_cockpitTechnicalID_qcRequirement.put(technicalID, requirement);
        } else if (technicalID != null && technicalID.trim().length() > 0) {
            LOGGER.warn("Duplicate Cockpit technical id in QC found. Ignoring second occurrence (ID = " + technicalID + ").");
        }
    }

    private void cacheRequirementChildren(IRequirement parentRequirement) {
        this.map_qcParent_children.put(parentRequirement.getId(), parentRequirement.getChildren());
    }

    public IRequirement getRequirement(String cockpitTechnicalID) {
        return this.map_cockpitTechnicalID_qcRequirement.get(cockpitTechnicalID);
    }

    public void checkOutQCRequirement(IRepositoryObjectSample objectSample) throws ExportOrImportFailedException {
        IRepositoryObjectReference objectReference = objectSample.getObjectReference(this.typeManager);
        String technicalID = QualityCenterExporter.getSerialisedCockpitTechnicalID(objectReference, this);
        IRequirement requirement = this.map_cockpitTechnicalID_qcRequirement.get(technicalID);
        if (requirement != null) {
            try {
                requirement.beginChange();
                this.map_qcRequirementID_checkedOutQCRequirement.put(requirement.getId(), requirement);
            }
            catch (CheckOutException coE) {
                throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.CheckoutOfRequirementFailed"), (Throwable)coE);
            }
        }
    }

    public void checkOutQCRequirement(IRequirement requirement) throws ExportOrImportFailedException {
        try {
            requirement.beginChange();
            this.map_qcRequirementID_checkedOutQCRequirement.put(requirement.getId(), requirement);
        }
        catch (CheckOutException coE) {
            throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.CheckoutOfNewlyCreatedRequirementFailed"), (Throwable)coE);
        }
    }

    public void checkInAllRequirements() {
        for (IRequirement requirement : this.map_qcRequirementID_checkedOutQCRequirement.values()) {
            try {
                requirement.commit("Canceled Cockpit Export");
            }
            catch (CommitException e) {
                LOGGER.error("Could not check back in QC requirement.", (Throwable)e);
            }
        }
        this.map_qcRequirementID_checkedOutQCRequirement.clear();
    }

    public void markRequirementAsCheckedIn(IRequirement requirement) {
        this.map_qcRequirementID_checkedOutQCRequirement.remove(requirement.getId());
    }

    public void setObjectTypeID(IRepositoryObjectTypeID objectTypeID) {
        IRequirementType mappedRequirementType;
        this.objectTypeID = objectTypeID;
        this.mappingConfiguration = this.currentConfiguration.getMappingConfiguration(objectTypeID);
        this.sourceAttributeDescriptionsForObjectType = (IList_)this.sourceAttributeDescriptionCache.getByKey((Object)objectTypeID);
        if (this.sourceAttributeDescriptionsForObjectType == null) {
            this.sourceAttributeDescriptionsForObjectType = AttributeMappingConfigurationHelper.getSourceAttributeDescriptions(objectTypeID, this.repositorySnippet, this.typeManager);
            this.sourceAttributeDescriptionCache.put((Object)objectTypeID, this.sourceAttributeDescriptionsForObjectType);
        }
        this.sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute = (IMap_)this.sourceAttributeDescriptionCache_asMapByCockpitAttribute.getByKey((Object)objectTypeID);
        if (this.sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute == null) {
            HashMap_ sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute_RW = new HashMap_(CockpitAttributeReference.REFERENCES_EQUAL_ATTRIBUTES_HASHER);
            for (ISourceAttributeDescription sourceAttributeDescription : this.sourceAttributeDescriptionsForObjectType) {
                sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute_RW.put((Object)((CockpitAttributeReference)sourceAttributeDescription.getKey()), (Object)sourceAttributeDescription);
            }
            this.sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute = sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute_RW;
            this.sourceAttributeDescriptionCache_asMapByCockpitAttribute.put((Object)objectTypeID, this.sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute);
        }
        if ((mappedRequirementType = this.getRequirementType()) != null) {
            this.targetAttributeDescriptionsForObjectType = (IList_)this.targetAttributeDescriptionCache.getByKey((Object)this.getRequirementType().getId());
            if (this.targetAttributeDescriptionsForObjectType == null) {
                this.targetAttributeDescriptionsForObjectType = AttributeMappingConfigurationHelper.getTargetAttributeDescriptions(this.getRequirementType());
                this.targetAttributeDescriptionCache.put((Object)this.getRequirementType().getId(), this.targetAttributeDescriptionsForObjectType);
            }
        } else {
            this.targetAttributeDescriptionsForObjectType = new ArrayList_();
        }
    }

    public IList_<? extends ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference>> getSourceAttributeDescriptions() {
        return this.sourceAttributeDescriptionsForObjectType;
    }

    public ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference> getSourceAttributeDescription(CockpitAttributeReference cockpitAttributeReference) {
        return (ISourceAttributeDescription)this.sourceAttributeDescriptionsForObjectType_asMapByCockpitAttribute.getByKey((Object)cockpitAttributeReference);
    }

    public IList_<? extends ITargetAttributeDescription<String, Integer, String>> getTargetAttributeDescriptions() {
        return this.targetAttributeDescriptionsForObjectType;
    }

    public IRequirementType getRequirementType() {
        Integer qcRequirementTypeID = this.mappingConfiguration.getQCRequirementTypeID();
        if (qcRequirementTypeID != null) {
            IRequirementType qcRequirementType = (IRequirementType)this.map_qcRequirementTypeID_qcRequirementType.getByKey((Object)qcRequirementTypeID);
            if (qcRequirementType == null) {
                qcRequirementType = this.currentQCProject.getRequirementType(qcRequirementTypeID.intValue());
                assert (qcRequirementType != null);
                this.map_qcRequirementTypeID_qcRequirementType.put((Object)qcRequirementTypeID, (Object)qcRequirementType);
            }
            return qcRequirementType;
        }
        return null;
    }

    public IMap_<CockpitAttributeReference, ? extends ITargetAttributeDescription<String, Integer, String>> getAttributeMap() {
        return this.retrieveAttributeAndEnumValueMappings().getAttributeMap();
    }

    public IMap_<CockpitAttributeReference, EnumValueMapping<CockpitValueReference, String>> getEnumValueMappingMap() {
        return this.retrieveAttributeAndEnumValueMappings().getEnumValueMappingMap();
    }

    private AttributeAndEnumValueMappings<CockpitAttributeReference, CockpitValueReference, String, Integer, String> retrieveAttributeAndEnumValueMappings() {
        AttributeAndEnumValueMappings attributeAndEnumValueMappings = (AttributeAndEnumValueMappings)this.attributeAndEnumValueMappingsCache.getByKey((Object)this.objectTypeID);
        if (attributeAndEnumValueMappings == null) {
            attributeAndEnumValueMappings = AttributeMappingWidget.loadAttributeMappingsFromMemento((IArcwayMemento)this.mappingConfiguration.getAttributeMappingMemento(), this.sourceAttributeDescriptionsForObjectType, this.targetAttributeDescriptionsForObjectType, AttributeMappingConfigurationHelper.getSettings(), AttributeMappingConfigurationHelper.getPersistencyHelper(), (ITargetAttributeDescription)this.NO_MAPPING);
            this.attributeAndEnumValueMappingsCache.put((Object)this.objectTypeID, (Object)attributeAndEnumValueMappings);
        }
        return attributeAndEnumValueMappings;
    }
}

