/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.configuration;

import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;

public class CockpitValueReference {
    private static final ILogger LOGGER = Logger.getLogger(CockpitValueReference.class);
    private final ValueType valueType;
    private final Object valueID;
    public static final IHasher_<CockpitValueReference> REFERENCES_EQUAL_VALUES_HASHER = new IHasher_<CockpitValueReference>(){

        public boolean isEqual(CockpitValueReference object1, CockpitValueReference object2) {
            if (object1.valueType == ValueType.Enumeration && object2.valueType == ValueType.Enumeration) {
                if (object1.getEnumerationValueID() != null) {
                    return object1.getEnumerationValueID().equals(object2.getEnumerationValueID());
                }
                return object2.getEnumerationValueID() == null;
            }
            if (object1.valueType == ValueType.Boolean && object2.valueType == ValueType.Boolean) {
                if (object1.getBooleanValueID() != null) {
                    return object1.getBooleanValueID().equals(object2.getBooleanValueID());
                }
                return object2.getBooleanValueID() == null;
            }
            if (object1.valueType == ValueType.LinkedAttribute && object2.valueType == ValueType.LinkedAttribute) {
                if (object1.getLinkedAttributeValueID() != null) {
                    return IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)object1.getLinkedAttributeValueID().getObjectReference(), (Object)object2.getLinkedAttributeValueID().getObjectReference());
                }
                return object2.getLinkedAttributeValueID() == null;
            }
            return false;
        }

        public int getHashCode(CockpitValueReference object) {
            int hashCode = object.valueType.ordinal();
            if (object.valueType == ValueType.Enumeration) {
                hashCode += 31 * (object.getEnumerationValueID() != null ? object.getEnumerationValueID().hashCode() : 0);
            } else if (object.valueType == ValueType.Boolean) {
                hashCode += 31 * (object.getBooleanValueID() != null ? object.getBooleanValueID().hashCode() : 0);
            } else if (object.valueType == ValueType.LinkedAttribute) {
                hashCode += 31 * (object.getLinkedAttributeValueID() != null ? IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.getHashCode((Object)object.getLinkedAttributeValueID().getObjectReference()) : 0);
            }
            return hashCode;
        }
    };

    public CockpitValueReference(ValueType valueType, Object valueID) {
        this.valueType = valueType;
        if (valueType == ValueType.Enumeration ? !$assertionsDisabled && valueID != null && !(valueID instanceof String) : (valueType == ValueType.Boolean ? !$assertionsDisabled && valueID != null && !(valueID instanceof Boolean) : valueType == ValueType.LinkedAttribute && !$assertionsDisabled && valueID != null && !(valueID instanceof ObjectReferenceAndTypeManager))) {
            throw new AssertionError();
        }
        this.valueID = valueID;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String getEnumerationValueID() {
        assert (this.valueType == ValueType.Enumeration);
        return (String)this.valueID;
    }

    public Boolean getBooleanValueID() {
        assert (this.valueType == ValueType.Boolean);
        return (Boolean)this.valueID;
    }

    public ObjectReferenceAndTypeManager getLinkedAttributeValueID() {
        assert (this.valueType == ValueType.LinkedAttribute);
        return (ObjectReferenceAndTypeManager)this.valueID;
    }

    public String getUniqueStringRepresentation(IUIDFormatter uidFormatter_) {
        IUIDFormatter uidFormatter = uidFormatter_;
        if (uidFormatter == null) {
            uidFormatter = new IUIDFormatter(){

                @Override
                public String serializeUID(IRepositoryObjectReference objectReference, IRepositoryTypeManagerRO typeManager) {
                    return RepositoryReferences.createCanonicalString((IRepositoryObjectReference)objectReference).replaceAll(Character.toString('\u0000'), " ");
                }
            };
        }
        String valueAsString = null;
        if (this.valueType == ValueType.Enumeration) {
            valueAsString = this.getEnumerationValueID() != null ? this.getEnumerationValueID() : "null";
        } else if (this.valueType == ValueType.Boolean) {
            valueAsString = this.getBooleanValueID() != null ? Boolean.toString(this.getBooleanValueID()) : "null";
        } else if (this.valueType == ValueType.LinkedAttribute) {
            if (this.getLinkedAttributeValueID() != null) {
                valueAsString = uidFormatter.serializeUID(this.getLinkedAttributeValueID().getObjectReference(), this.getLinkedAttributeValueID().getTypeManager());
                if (valueAsString == null) {
                    LOGGER.error("Could not create a unique string representation of the Cockpit value reference.");
                    valueAsString = "null";
                }
            } else {
                valueAsString = "null";
            }
        }
        return String.valueOf(this.valueType.toString()) + ":" + valueAsString;
    }

    public static interface IUIDFormatter {
        public String serializeUID(IRepositoryObjectReference var1, IRepositoryTypeManagerRO var2);
    }

    public static final class ObjectReferenceAndTypeManager {
        private final IRepositoryObjectReference objectReference;
        private final IRepositoryTypeManagerRO typeManager;

        public ObjectReferenceAndTypeManager(IRepositoryObjectReference objectReference, IRepositoryTypeManagerRO typeManager) {
            this.objectReference = objectReference;
            this.typeManager = typeManager;
        }

        protected IRepositoryObjectReference getObjectReference() {
            return this.objectReference;
        }

        protected IRepositoryTypeManagerRO getTypeManager() {
            return this.typeManager;
        }
    }

    public static enum ValueType {
        Enumeration,
        Boolean,
        LinkedAttribute;

    }
}

