/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.configuration;

import com.arcway.lib.java.collections.IHasher_;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;

public class CockpitAttributeReference {
    private final AttributeType attributeType;
    private final Object attributeID;
    public static final IHasher_<CockpitAttributeReference> REFERENCES_EQUAL_ATTRIBUTES_HASHER = new IHasher_<CockpitAttributeReference>(){

        public boolean isEqual(CockpitAttributeReference object1, CockpitAttributeReference object2) {
            if (object1.attributeType == AttributeType.Property && object2.attributeType == AttributeType.Property) {
                return IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)object1.getPropertyAttributeID(), (Object)object2.getPropertyAttributeID());
            }
            if (object1.attributeType == AttributeType.LinkedAttribute && object2.attributeType == AttributeType.LinkedAttribute) {
                return IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER.isEqual((Object)object1.getLinkedAttributeID().getRelationTypeID(), (Object)object2.getLinkedAttributeID().getRelationTypeID()) && IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)object1.getLinkedAttributeID().getRelationContributionRoleID(), (Object)object2.getLinkedAttributeID().getRelationContributionRoleID());
            }
            return false;
        }

        public int getHashCode(CockpitAttributeReference object) {
            int hashCode = object.attributeType.ordinal();
            if (object.attributeType == AttributeType.Property) {
                hashCode += 31 * IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.getHashCode((Object)object.getPropertyAttributeID());
            } else if (object.attributeType == AttributeType.LinkedAttribute) {
                hashCode += 31 * IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER.getHashCode((Object)object.getLinkedAttributeID().getRelationTypeID());
                hashCode = 31 * hashCode + IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.getHashCode((Object)object.getLinkedAttributeID().getRelationContributionRoleID());
            }
            return hashCode;
        }
    };

    public CockpitAttributeReference(AttributeType valueType, Object valueID) {
        this.attributeType = valueType;
        if (valueType == AttributeType.Property ? !$assertionsDisabled && !(valueID instanceof IRepositoryPropertyTypeID) : valueType == AttributeType.LinkedAttribute && !$assertionsDisabled && !(valueID instanceof RelationTypeAndContribution)) {
            throw new AssertionError();
        }
        this.attributeID = valueID;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public IRepositoryPropertyTypeID getPropertyAttributeID() {
        assert (this.attributeType == AttributeType.Property);
        return (IRepositoryPropertyTypeID)this.attributeID;
    }

    public RelationTypeAndContribution getLinkedAttributeID() {
        assert (this.attributeType == AttributeType.LinkedAttribute);
        return (RelationTypeAndContribution)this.attributeID;
    }

    public String getUniqueStringRepresentation() {
        String valueAsString = null;
        if (this.attributeType == AttributeType.Property) {
            valueAsString = this.getPropertyAttributeID().toCanonicalString();
        } else if (this.attributeType == AttributeType.LinkedAttribute) {
            valueAsString = String.valueOf(this.getLinkedAttributeID().getRelationTypeID().toCanonicalString()) + "--(" + this.getLinkedAttributeID().getRelationContributionRoleID().toCanonicalString() + ")";
        }
        return String.valueOf(this.attributeType.toString()) + ":" + valueAsString;
    }

    public static enum AttributeType {
        Property,
        LinkedAttribute;

    }

    public static class RelationTypeAndContribution {
        private final IRepositoryRelationTypeID relationTypeID;
        private final IRepositoryRelationContributionRoleID relationContributionRoleID;

        public RelationTypeAndContribution(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID relationContributionRoleID) {
            this.relationTypeID = relationTypeID;
            this.relationContributionRoleID = relationContributionRoleID;
        }

        public IRepositoryRelationTypeID getRelationTypeID() {
            return this.relationTypeID;
        }

        public IRepositoryRelationContributionRoleID getRelationContributionRoleID() {
            return this.relationContributionRoleID;
        }
    }
}

