/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.ole.hpqc;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.ole.hpqc.ITDConnection4;
import com.arcway.ole.hpqc._DIOtaEvents;
import com.arcway.ole.hpqc._DIProgressEvents;
import com.arcway.ole.hpqc.impl.ITDConnection4Impl;
import com.arcway.ole.hpqc.impl._DIOtaEventsListener;
import com.arcway.ole.hpqc.impl._DIProgressEventsListener;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class TDConnection
extends ITDConnection4Impl {
    private static final ILogger logger = Logger.getLogger(TDConnection.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{C5CBD7B2-490C-45F5-8C40-B8C3D108E6D7}");
    private _DIOtaEventsListener fDIOtaEvents;
    private _DIProgressEventsListener fDIProgressEvents;

    public TDConnection(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public TDConnection(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static ITDConnection4 create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new ITDConnection4Impl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            ITDConnection4Impl iTDConnection4Impl = new ITDConnection4Impl(appVariant, resourceManager);
            return iTDConnection4Impl;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean add_DIOtaEventsListener(_DIOtaEvents listener) {
        if (this.fDIOtaEvents == null) {
            this.fDIOtaEvents = new _DIOtaEventsListener(this.getResourceManager());
            this.addEventListener(_DIOtaEvents.IID, 1, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 2, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 3, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 4, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 5, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 6, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 7, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 8, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 9, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 10, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 11, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 12, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 13, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 14, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 15, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 16, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 17, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 18, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 19, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 20, (OleListener)this.fDIOtaEvents);
            this.addEventListener(_DIOtaEvents.IID, 21, (OleListener)this.fDIOtaEvents);
        }
        return this.fDIOtaEvents.addListener(listener);
    }

    public boolean remove_DIOtaEventsListener(_DIOtaEvents listener) {
        boolean bRtn = this.fDIOtaEvents.removeListener(listener);
        if (this.fDIOtaEvents.isEmpty()) {
            this.removeEventListener(_DIOtaEvents.IID, 1, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 2, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 3, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 4, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 5, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 6, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 7, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 8, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 9, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 10, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 11, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 12, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 13, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 14, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 15, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 16, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 17, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 18, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 19, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 20, (OleListener)this.fDIOtaEvents);
            this.removeEventListener(_DIOtaEvents.IID, 21, (OleListener)this.fDIOtaEvents);
            this.fDIOtaEvents = null;
        }
        return bRtn;
    }

    public boolean add_DIProgressEventsListener(_DIProgressEvents listener) {
        if (this.fDIProgressEvents == null) {
            this.fDIProgressEvents = new _DIProgressEventsListener(this.getResourceManager());
            this.addEventListener(_DIProgressEvents.IID, 1, (OleListener)this.fDIProgressEvents);
            this.addEventListener(_DIProgressEvents.IID, 2, (OleListener)this.fDIProgressEvents);
            this.addEventListener(_DIProgressEvents.IID, 3, (OleListener)this.fDIProgressEvents);
            this.addEventListener(_DIProgressEvents.IID, 4, (OleListener)this.fDIProgressEvents);
        }
        return this.fDIProgressEvents.addListener(listener);
    }

    public boolean remove_DIProgressEventsListener(_DIProgressEvents listener) {
        boolean bRtn = this.fDIProgressEvents.removeListener(listener);
        if (this.fDIProgressEvents.isEmpty()) {
            this.removeEventListener(_DIProgressEvents.IID, 1, (OleListener)this.fDIProgressEvents);
            this.removeEventListener(_DIProgressEvents.IID, 2, (OleListener)this.fDIProgressEvents);
            this.removeEventListener(_DIProgressEvents.IID, 3, (OleListener)this.fDIProgressEvents);
            this.removeEventListener(_DIProgressEvents.IID, 4, (OleListener)this.fDIProgressEvents);
            this.fDIProgressEvents = null;
        }
        return bRtn;
    }
}

