/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.ole.hpqc;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.ole.hpqc.IList;
import com.arcway.ole.hpqc.IList2;
import com.arcway.ole.hpqc.impl.IList2Impl;
import com.arcway.ole.hpqc.impl.IListImpl;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class List
extends IListImpl {
    private static final ILogger logger = Logger.getLogger(List.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{9007A7F1-AC71-4563-A943-CFF4051E7E3D}");

    public List(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public List(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static IList create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new IListImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            IListImpl iListImpl = new IListImpl(appVariant, resourceManager);
            return iListImpl;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public IList2 getAsIList2() {
        int[] ppvRequestedInterface;
        IUnknown refIUnknown = new Variant(this.getOleAutomation()).getUnknown();
        if (refIUnknown.QueryInterface(IList2.IID, ppvRequestedInterface = new int[1]) != 0) {
            throw new SWTException("Interface does not support: IList2");
        }
        refIUnknown.Release();
        return new IList2Impl(new Variant(new IDispatch(ppvRequestedInterface[0])).getAutomation(), this.getResourceManager());
    }
}

