/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.ole.hpqc;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.ole.hpqc.IImport;
import com.arcway.ole.hpqc.impl.IImportImpl;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class Import
extends IImportImpl {
    private static final ILogger logger = Logger.getLogger(Import.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{CD3E5686-4B11-462F-9619-D2FA447DCE96}");

    public Import(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Import(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static IImport create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new IImportImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            IImportImpl iImportImpl = new IImportImpl(appVariant, resourceManager);
            return iImportImpl;
        }
        finally {
            objIUnknown.Release();
        }
    }
}

