/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.exporter;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ExportedObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Exporter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GMExportSpecsHelper {
    public static final String QUALITYCENTER_EXPORTADAPTER_ID = "com.arcway.cockpit.rqm3.qualitycenteradapter";

    public static final IList_<IRepositoryObjectTypeID> getObjectTypesWhichMayBeExportedToHPQC(String moduleID) {
        ArrayList_ objectTypesWhichMayBeExportedToHPQC = new ArrayList_();
        ModuleSpecification moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID);
        GMExportSpecsHelper.findObjectTypesWhichMayBeExported(moduleID, moduleSpecification, (IListRW_<IRepositoryObjectTypeID>)objectTypesWhichMayBeExportedToHPQC);
        return objectTypesWhichMayBeExportedToHPQC;
    }

    public static final IList_<IRepositoryObjectTypeID> getObjectTypesWhichMayBeExportedToHPQC() {
        ArrayList_ objectTypesWhichMayBeExportedToHPQC = new ArrayList_();
        for (Map.Entry entry : SpecificationProvider.getDefault().getModuleSpecifications().entrySet()) {
            String moduleID = (String)entry.getKey();
            ModuleSpecification moduleSpecification = (ModuleSpecification)entry.getValue();
            GMExportSpecsHelper.findObjectTypesWhichMayBeExported(moduleID, moduleSpecification, (IListRW_<IRepositoryObjectTypeID>)objectTypesWhichMayBeExportedToHPQC);
        }
        return objectTypesWhichMayBeExportedToHPQC;
    }

    private static final void findObjectTypesWhichMayBeExported(String moduleID, ModuleSpecification moduleSpecification, IListRW_<IRepositoryObjectTypeID> objectTypesWhichMayBeExportedToHPQC) {
        ModuleDataSpecification moduleDataSpecification = moduleSpecification.getModuleDataSpecification();
        String platformModuleID = ModuleIdentification.getModuleIDForPlatform((String)moduleID);
        RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(platformModuleID, "declaration_module_coremodule");
        HashSet<String> relevantObjectTypeIDs = new HashSet<String>(moduleDataSpecification.getObjectTypeList().size());
        for (Exporter exporterSpec : moduleSpecification.getModuleUISpecification().getExporterList()) {
            String adapterID = exporterSpec.getIdOfAdapter();
            if (!adapterID.equals(QUALITYCENTER_EXPORTADAPTER_ID)) continue;
            for (ExportedObjectType exportedObjectType : exporterSpec.getExportedObjectTypeList()) {
                String exportedObjectTypeID = exportedObjectType.getIdOfObjectType();
                GMExportSpecsHelper.getAncestorObjectTypeIDs(exportedObjectTypeID, moduleDataSpecification, relevantObjectTypeIDs);
            }
        }
        List<String> sortedRelevantObjectTypeIDs = GMExportSpecsHelper.sortRelevantObjectTypeIDs(relevantObjectTypeIDs, moduleDataSpecification);
        for (String relevantObjectTypeID : sortedRelevantObjectTypeIDs) {
            String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID((String)moduleID, (String)relevantObjectTypeID);
            RepositoryObjectTypeID repositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(cockpitTypeID);
            objectTypesWhichMayBeExportedToHPQC.add((Object)repositoryObjectTypeID);
        }
    }

    private static final void getAncestorObjectTypeIDs(String objectTypeID, ModuleDataSpecification moduleDataSpecification, Set<String> ancestorObjectTypeIDs) {
        ancestorObjectTypeIDs.add(objectTypeID);
        ObjectType objectTypeSpec = moduleDataSpecification.getObjectType(objectTypeID);
        for (ParentType parentType : objectTypeSpec.getParentTypeList()) {
            String parentObjectTypeID = parentType.getParentObjectTypeID();
            if (parentObjectTypeID.equals("noparent") || parentObjectTypeID.equals("hierarchyroot") || ancestorObjectTypeIDs.contains(parentObjectTypeID)) continue;
            GMExportSpecsHelper.getAncestorObjectTypeIDs(parentObjectTypeID, moduleDataSpecification, ancestorObjectTypeIDs);
        }
    }

    private static final List<String> sortRelevantObjectTypeIDs(Set<String> relevantObjectTypeIDs, ModuleDataSpecification moduleDataSpecification) {
        ArrayList<String> sortedRelevantObjectTypeIDs = new ArrayList<String>(relevantObjectTypeIDs.size());
        for (ObjectType objectTypeSpec : moduleDataSpecification.getObjectTypeList()) {
            String objectTypeID = objectTypeSpec.getObjectTypeID();
            if (!relevantObjectTypeIDs.contains(objectTypeID)) continue;
            sortedRelevantObjectTypeIDs.add(objectTypeID);
        }
        return sortedRelevantObjectTypeIDs;
    }
}

