/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.configuration.ui;

import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.AbstractConfigurationPage;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.GeneralConfigurationPage;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.JiraFacade;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IExportTargetTool;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IProject;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.JiraFacadeException;
import com.arcway.lib.java.tuples.ThreeTuple;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class QCConnectionAdmin {
    private final GeneralConfigurationPage generalConfigurationPage;
    private final List<AbstractConfigurationPage> listeningQCConfigurationPages;
    private IExportTargetTool qualityCenter;
    private IProject connectedQCProject;

    public QCConnectionAdmin(GeneralConfigurationPage generalConfigurationPage) {
        this.generalConfigurationPage = generalConfigurationPage;
        this.listeningQCConfigurationPages = new ArrayList<AbstractConfigurationPage>();
        this.listeningQCConfigurationPages.add(generalConfigurationPage);
    }

    public void addListeningQCConfigurationPage(AbstractConfigurationPage mappingConfigurationPage) {
        this.listeningQCConfigurationPages.add(mappingConfigurationPage);
    }

    public boolean isConnected() {
        return this.connectedQCProject != null;
    }

    public IProject getConnection() {
        return this.connectedQCProject;
    }

    public void connect(String username, String password, Shell shell) {
        this.qualityCenter = JiraFacade.getJira();
        try {
            ThreeTuple<String, String, String> urlDomainAndProject = this.generalConfigurationPage.getCurrentURLDomainAndProject();
            this.connectedQCProject = this.qualityCenter.connect((String)urlDomainAndProject.getComponent1(), (String)urlDomainAndProject.getComponent2(), (String)urlDomainAndProject.getComponent3(), username, password);
            this.informQCConfigurationPagesAboutLogin();
        }
        catch (JiraFacadeException qcfE) {
            MessageDialog.openError((Shell)shell, (String)Messages.getString("QCConnectionAdmin.Login.Error.Title"), (String)NLS.bind((String)Messages.getString("QCConnectionAdmin.Login.Error.Message"), (Object)qcfE.getLocalizedMessage()));
        }
    }

    public void disconnect() {
        assert (this.isConnected());
        if (this.isConnected()) {
            this.qualityCenter.disconnect(this.connectedQCProject);
            this.qualityCenter = null;
            this.connectedQCProject = null;
        }
    }

    public void closeBrokenConnection() {
        this.qualityCenter.disconnect(this.connectedQCProject);
        this.qualityCenter = null;
        this.connectedQCProject = null;
        this.informQCConfigurationPagesAboutLogoff();
    }

    private void informQCConfigurationPagesAboutLogin() {
        for (AbstractConfigurationPage page : this.listeningQCConfigurationPages) {
            page.informAboutSuccessfulQCLogin();
        }
    }

    private void informQCConfigurationPagesAboutLogoff() {
        for (AbstractConfigurationPage page : this.listeningQCConfigurationPages) {
            page.informAboutQCLogoff();
        }
    }
}

