/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.configuration.ui;

import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.RQM2JiraPluginActivator;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.CockpitAttributeReference;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.CockpitDataTypeReference;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.CockpitValueReference;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.MappingConfiguration;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.AbstractConfigurationPage;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.AttributeMappingConfigurationHelper;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.GeneralConfigurationPage;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.QCConnectionAdmin;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.SourceAttributeDescription;
import com.arcway.cockpit.rqm3.jiraadapter.exporter.JiraConfigurationChecker;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IField;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IProject;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirementType;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeMappingWidget;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingChangedListener;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class MappingConfigurationPage
extends AbstractConfigurationPage {
    private final IRepositoryObjectTypeID objectTypeID;
    private final QCConnectionAdmin qcConnectionAdmin;
    private final MappingConfiguration mappingConfiguration;
    private final GeneralConfigurationPage generalPage;
    private IFrameProjectAgent projectAgent = null;
    private Image icon = null;
    private String objectTypeLabel;
    private boolean areWidgetsCreated;
    private boolean isInConnectedState;
    private Composite mappingComposite;
    private Combo reqTypeCombo;
    private AttributeMappingWidget<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference, String, Integer, String> attributeMappingWidget;
    private List<IRequirementType> qcRequirementTypes;

    public MappingConfigurationPage(IRepositoryObjectTypeID objectTypeID, QCConnectionAdmin qcConnectionAdmin, MappingConfiguration mappingConfiguration, GeneralConfigurationPage generalPage) {
        super(false);
        this.objectTypeID = objectTypeID;
        this.qcConnectionAdmin = qcConnectionAdmin;
        this.mappingConfiguration = mappingConfiguration;
        this.generalPage = generalPage;
        this.areWidgetsCreated = false;
        this.isInConnectedState = false;
        qcConnectionAdmin.addListeningQCConfigurationPage(this);
    }

    public String getPropertyName() {
        return NLS.bind((String)Messages.getString("MappingConfigurationPage.Name"), (Object)this.objectTypeLabel);
    }

    public Image getPropertyImage() {
        if (this.icon == null) {
            this.icon = ImageDescriptor.createFromURL((URL)RQM2JiraPluginActivator.getDefault().getBundle().getEntry("/icons/jira-mapping.gif")).createImage();
        }
        return this.icon;
    }

    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public QCConnectionAdmin init(ICockpitProjectData[] elements) {
        this.projectAgent = (IFrameProjectAgent)elements[0];
        IRepositoryTypeManagerRO typeManager = this.projectAgent.getRepositoryInterface().getTypeManager();
        IRepositoryObjectType objectType = typeManager.getObjectType(this.objectTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager);
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(objectType);
        this.objectTypeLabel = frontendObjectType.getLabel().getText();
        return this.qcConnectionAdmin;
    }

    @Override
    protected String getDialogueTitle() {
        return Messages.getString("MappingConfigurationPage.Title");
    }

    @Override
    protected String getDialogueMessage() {
        return NLS.bind((String)Messages.getString("MappingConfigurationPage.Message"), (Object)this.objectTypeLabel);
    }

    @Override
    protected String getLoginHintMessage() {
        return Messages.getString("MappingConfigurationPage.Login.Message");
    }

    @Override
    protected void createQCIndependantConfigurationUI(Composite composite_) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void createQCSpecificConfigurationUI_Initial(Composite composite_) {
        this.mappingComposite = composite_;
        Composite reqTypeComposite = AbstractConfigurationPage.createPartComposite(this.mappingComposite);
        AbstractConfigurationPage.createLabel(reqTypeComposite, String.valueOf(Messages.getString("MappingConfigurationPage.ReqTypeMapping.Label")) + ":", 1, true, true);
        this.reqTypeCombo = new Combo(reqTypeComposite, 12);
        GridData reqTypeComboLayoutData = new GridData(4, 2, true, false);
        this.reqTypeCombo.setLayoutData((Object)reqTypeComboLayoutData);
        this.reqTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingConfigurationPage.this.exchangeAttributeMappingWidget((IRequirementType)MappingConfigurationPage.this.qcRequirementTypes.get(MappingConfigurationPage.this.reqTypeCombo.getSelectionIndex()));
                MappingConfigurationPage.this.generalPage.updatePageProblemState(true);
            }
        });
        this.areWidgetsCreated = true;
    }

    @Override
    protected void createQCSpecificConfigurationUI_AfterConnection(Composite composite_) {
        IProject qcProject = this.qcConnectionAdmin.getConnection();
        this.qcRequirementTypes = qcProject.getRequirementTypes();
        for (IRequirementType qcRequirementType : this.qcRequirementTypes) {
            this.reqTypeCombo.add(qcRequirementType.getName());
        }
        int qcRequirmentTypeIndex = 0;
        Integer mappedQCRequirementType = this.mappingConfiguration.getQCRequirementTypeID();
        if (mappedQCRequirementType != null) {
            int index = 0;
            for (IRequirementType qcRequirementType : this.qcRequirementTypes) {
                if (qcRequirementType.getId() == mappedQCRequirementType.intValue()) {
                    qcRequirmentTypeIndex = index;
                    break;
                }
                ++index;
            }
        }
        this.reqTypeCombo.select(qcRequirmentTypeIndex);
        this.exchangeAttributeMappingWidget(this.qcRequirementTypes.get(qcRequirmentTypeIndex));
        this.isInConnectedState = true;
    }

    private void exchangeAttributeMappingWidget(IRequirementType requirementType) {
        if (this.attributeMappingWidget != null) {
            this.attributeMappingWidget.dispose();
            this.attributeMappingWidget = null;
        }
        IList_<SourceAttributeDescription> sourceAttributes = AttributeMappingConfigurationHelper.getSourceAttributeDescriptions(this.objectTypeID, this.projectAgent.getRepositoryInterface(), this.projectAgent.getRepositoryInterface().getTypeManager());
        IList_<ITargetAttributeDescription<String, Integer, String>> targetAttributes = AttributeMappingConfigurationHelper.getTargetAttributeDescriptions(requirementType);
        IAttributeMappingWidgetSettings<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference, String, Integer, String> settings = AttributeMappingConfigurationHelper.getSettings();
        IAttributeMappingPersistencyHelper<CockpitAttributeReference, CockpitValueReference, String, Integer, String> persistencyHelper = AttributeMappingConfigurationHelper.getPersistencyHelper();
        IAttributeMappingChangedListener changeListener = new IAttributeMappingChangedListener(){

            public void attributeMappingChanged() {
                MappingConfigurationPage.this.updatePageProblemState(true);
                MappingConfigurationPage.this.generalPage.updatePageProblemState(true);
            }
        };
        this.attributeMappingWidget = new AttributeMappingWidget(sourceAttributes, targetAttributes, this.mappingConfiguration.getAttributeMappingMemento(), persistencyHelper, changeListener, settings, null);
        this.attributeMappingWidget.createControl(this.mappingComposite);
        this.updatePageProblemState(true);
        this.mappingComposite.layout();
        this.mappingComposite.getParent().layout();
    }

    @Override
    protected void disposeQCSpecificConfigurationUI(Composite composite) {
        this.isInConnectedState = false;
        this.attributeMappingWidget.dispose();
        this.attributeMappingWidget = null;
        this.reqTypeCombo.removeAll();
        this.qcRequirementTypes = null;
    }

    public boolean hasChanges() {
        return false;
    }

    public Collection<IModificationProblem> getModificationProblems() {
        return Collections.emptySet();
    }

    public Collection<? extends IModificationProblem> requestCommit() {
        return this.generalPage.requestCommit_onChild();
    }

    public void commitPropertyChanges1() {
        this.generalPage.commitPropertyChanges_onChild();
    }

    public void rollbackCommitRequest() {
        this.generalPage.rollbackCommitRequest_onChild();
    }

    public void cancelPropertyChanges1() {
    }

    public void updateConfiguration() {
        if (this.reqTypeCombo != null && this.reqTypeCombo.getSelectionIndex() >= 0 && this.attributeMappingWidget != null) {
            this.mappingConfiguration.setQCRequirementTypeID(this.qcRequirementTypes.get(this.reqTypeCombo.getSelectionIndex()).getId());
            this.attributeMappingWidget.save(this.mappingConfiguration.getAttributeMappingMemento());
        }
    }

    public void disposeResources() {
    }

    @Override
    protected void updatePageProblemState(boolean isConnected) {
        Tuple<String, String> problemAndWarningMessage = new Tuple<String, String>(null, null);
        if (this.areWidgetsCreated && isConnected) {
            JiraConfigurationChecker.IAttributeMappingChecker attributeMappingChecker = new JiraConfigurationChecker.IAttributeMappingChecker(){

                @Override
                public ThreeTuple<Boolean, String, String> checkAttributeMapping() {
                    return MappingConfigurationPage.this.attributeMappingWidget.isAttributeMappingComplete();
                }

                @Override
                public ICollection_<? extends ITargetAttributeDescription<String, Integer, String>> getMappedTargetAttributes() {
                    return MappingConfigurationPage.this.attributeMappingWidget.getAttributeMapping().values();
                }
            };
            problemAndWarningMessage = JiraConfigurationChecker.checkPerTypeConfiguration(this.getCurrentRequirementType(), attributeMappingChecker, true, this.generalPage.getCurrentlySelectedCockpitTechnicalIDField(), this.getTechnicalIDFieldAgainstAttributeMappingChecker(), this.qcConnectionAdmin.getConnection());
        }
        this.setPageProblemState((String)problemAndWarningMessage.getT1(), (String)problemAndWarningMessage.getT2());
    }

    public Tuple<IRequirementType, JiraConfigurationChecker.ITechnicalIDFieldAgainstAttributeMappingChecker> getCurrentSettings() {
        if (this.areWidgetsCreated && this.isInConnectedState) {
            return new Tuple((Object)this.getCurrentRequirementType(), (Object)this.getTechnicalIDFieldAgainstAttributeMappingChecker());
        }
        return null;
    }

    private IRequirementType getCurrentRequirementType() {
        return this.qcRequirementTypes.get(this.reqTypeCombo.getSelectionIndex());
    }

    private JiraConfigurationChecker.ITechnicalIDFieldAgainstAttributeMappingChecker getTechnicalIDFieldAgainstAttributeMappingChecker() {
        return new JiraConfigurationChecker.ITechnicalIDFieldAgainstAttributeMappingChecker(){

            @Override
            public boolean checkTechnicalIDFieldAgainstAttributeMapping(IField technicalIDField) {
                return !MappingConfigurationPage.this.attributeMappingWidget.isMappingConfiguredForTargetAttribute((Object)technicalIDField.getID());
            }
        };
    }
}

