/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.configuration.ui;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.settings.global.ConfigurationManager;
import com.arcway.cockpit.rqm3.jiraadapter.Messages;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.CockpitAttributeReference;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.CockpitDataTypeReference;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.CockpitValueReference;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.SourceAttributeDescription;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.ui.TargetAttributeDescription;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.FieldAndDatatypeHelper;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IFieldOfRequirementType;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IProject;
import com.arcway.cockpit.rqm3.jiraadapter.jirafacade.interFace.IRequirementType;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IEnumValueMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.memento.ArcwayMementoHelper;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.ui.editor.layoutspecification.IWidgetSpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.specification.sequential.EntrySpecification;
import com.arcway.lib.ui.editor.specification.sequential.PageSpecification;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import de.plans.lib.util.StringComparatorFactory;
import de.plans.psc.shared.message.EOUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeMappingConfigurationHelper {
    public static final String VIRTUAL_ATTACHMENT_FIELDID = "RQ_REQ_ATTACHMENTS_DUMMY";
    private static final String KeyAttributeAssignment = "AttributeAssignment";
    private static final String KeyTargetAttributeKey = "TargetAttributeKey";
    private static final String KeyIsTargetAttributeAssigned = "IsTargetAttributeAssigned";
    private static final String KeyEnumValueMapping = "EnumValueMapping";
    private static final String KeyEnumValueAssignment = "EnumValueAssignment";
    private static final String KeyTargetEnumValueKey = "TargetEnumValueKey";
    private static final String KeyIsTargetEnumValueAssigned = "IsTargetEnumValueAssigned";
    private static final CockpitValueReference.IUIDFormatter UID_FORMATTER = new CockpitValueReference.IUIDFormatter(){

        @Override
        public String serializeUID(IRepositoryObjectReference objectReference, IRepositoryTypeManagerRO typeManager) {
            return ConfigurationManager.getSerializedObjectReference((IRepositoryObjectReference)objectReference, (IRepositoryTypeManagerRO)typeManager);
        }
    };

    public static IList_<SourceAttributeDescription> getSourceAttributeDescriptions(IRepositoryObjectTypeID objectTypeID, IRepositoryInterfaceRO repositoryInterface, IRepositoryTypeManagerRO typeManager) {
        assert (repositoryInterface != null);
        return AttributeMappingConfigurationHelper.getSourceAttributeDescriptions(objectTypeID, repositoryInterface, null, typeManager);
    }

    public static IList_<SourceAttributeDescription> getSourceAttributeDescriptions(IRepositoryObjectTypeID objectTypeID, IRepositorySnippetRO repositorySnippet, IRepositoryTypeManagerRO typeManager) {
        assert (repositorySnippet != null);
        return AttributeMappingConfigurationHelper.getSourceAttributeDescriptions(objectTypeID, null, repositorySnippet, typeManager);
    }

    private static IList_<SourceAttributeDescription> getSourceAttributeDescriptions(IRepositoryObjectTypeID objectTypeID, IRepositoryInterfaceRO repositoryInterface, IRepositorySnippetRO repositorySnippet, IRepositoryTypeManagerRO typeManager) {
        ArrayList_ sourceAttributes = new ArrayList_();
        CockpitDataTypeReference cockpitLinkedAttributeDataType = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.LinkedAttribute, null);
        ISet_ allowedTargetDataTypesForLinkedAttributes = (ISet_)FieldAndDatatypeHelper.ALLOWED_MAPPINGS.getByKey((Object)cockpitLinkedAttributeDataType);
        boolean areLinkedAttributesAllowed = allowedTargetDataTypesForLinkedAttributes != null && !allowedTargetDataTypesForLinkedAttributes.isEmpty();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        Sequence sequence = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager).getFrontendObjectType(objectType).getSequentialLayoutSpecification();
        for (PageSpecification pageSpecification : sequence.getPageSpecifications()) {
            for (EntrySpecification entrySpecification : pageSpecification.getEntrySpecifications()) {
                IRepositoryRelationContributionRoleID roleID;
                Map.Entry relationTypeIDAndRoleID;
                ICrossLinkRepositoryRelationType relationType;
                IWidgetSpecification widgetSpecification_ = entrySpecification.getWidgetSpecification();
                if (!(widgetSpecification_ instanceof WidgetSpecification)) continue;
                WidgetSpecification widgetSpecification = (WidgetSpecification)widgetSpecification_;
                if (!widgetSpecification.getPropertyTypeIDs().isEmpty()) {
                    assert (widgetSpecification.getPropertyTypeIDs().size() == 1);
                    assert (widgetSpecification.getRelationTypeIDs2relationContributionRoleIDs().isEmpty());
                    final String propertyTypeID = (String)widgetSpecification.getPropertyTypeIDs().iterator().next();
                    IRepositoryPropertyType propertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)new IRepositoryPropertyTypeID(){

                        public String toCanonicalString() {
                            return propertyTypeID;
                        }
                    });
                    CockpitDataTypeReference cockpitDataType = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.Property, propertyType.getDataType().getRepositoryDataTypeID());
                    ISet_ allowedTargetDataTypes = (ISet_)FieldAndDatatypeHelper.ALLOWED_MAPPINGS.getByKey((Object)cockpitDataType);
                    if (allowedTargetDataTypes == null || allowedTargetDataTypes.isEmpty()) continue;
                    sourceAttributes.add((Object)new SourceAttributeDescription(propertyType, typeManager));
                    continue;
                }
                if (widgetSpecification.getRelationTypeIDs2relationContributionRoleIDs().isEmpty()) continue;
                assert (widgetSpecification.getRelationTypeIDs2relationContributionRoleIDs().size() == 1);
                assert (widgetSpecification.getPropertyTypeIDs().isEmpty());
                if (!areLinkedAttributesAllowed || (relationType = typeManager.getCrossLinkRelationType(new IRepositoryRelationTypeID(relationTypeIDAndRoleID = widgetSpecification.getRelationTypeIDs2relationContributionRoleIDs().entrySet().iterator().next()){
                    private final /* synthetic */ Map.Entry val$relationTypeIDAndRoleID;
                    {
                        this.val$relationTypeIDAndRoleID = entry;
                    }

                    public String toCanonicalString() {
                        return (String)this.val$relationTypeIDAndRoleID.getKey();
                    }
                })).getRelationContributionType(roleID = new IRepositoryRelationContributionRoleID(){

                    public String toCanonicalString() {
                        return (String)relationTypeIDAndRoleID.getValue();
                    }
                }).getCardinality().getMaximum() != 1) continue;
                if (repositoryInterface != null) {
                    sourceAttributes.add((Object)new SourceAttributeDescription(relationType, roleID, repositoryInterface, typeManager));
                    continue;
                }
                sourceAttributes.add((Object)new SourceAttributeDescription(relationType, roleID, repositorySnippet, typeManager));
            }
        }
        return sourceAttributes;
    }

    public static IList_<ITargetAttributeDescription<String, Integer, String>> getTargetAttributeDescriptions(IRequirementType qcRequirementType) {
        ArrayList_ targetAttributes = new ArrayList_();
        for (IFieldOfRequirementType qcField : qcRequirementType.getFields()) {
            if (FieldAndDatatypeHelper.QC_SYSTEM_FIELDS.contains(qcField.getID()) || !qcField.isEditable()) continue;
            targetAttributes.add((Object)new TargetAttributeDescription(qcField));
        }
        targetAttributes.add((Object)new ITargetAttributeDescription<String, Integer, String>(){

            public String getKey() {
                return AttributeMappingConfigurationHelper.VIRTUAL_ATTACHMENT_FIELDID;
            }

            public String getName() {
                return Messages.getString("MappingConfiguration.ExportIntoAttachment.Label");
            }

            public Integer getDataTypeKey() {
                return 1000;
            }

            public boolean mayAttributeHaveMultipleMappings() {
                return true;
            }

            public boolean isAttributeMandatory() {
                return false;
            }

            public boolean isEnumType() {
                return false;
            }

            public List<EnumValue<String>> getValueRange() {
                return null;
            }

            public boolean mayExtendValueRange() {
                return false;
            }
        });
        return targetAttributes;
    }

    public static IAttributeMappingWidgetSettings<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference, String, Integer, String> getSettings() {
        return new IAttributeMappingWidgetSettings<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference, String, Integer, String>(){

            public IMap_<CockpitDataTypeReference, ISet_<Integer>> getAllowedMappings() {
                return FieldAndDatatypeHelper.ALLOWED_MAPPINGS;
            }

            public IMap_<CockpitDataTypeReference, IMap_<Integer, String>> getWarningsForMappings() {
                return new HashMap_(CockpitDataTypeReference.REFERENCES_EQUAL_DATATYPES_HASHER);
            }

            public boolean mustMapAllSourceAttributes() {
                return false;
            }

            public boolean mayCreateNewTargetAttributes() {
                return false;
            }

            public IHasher_<? super CockpitAttributeReference> getSourceKeyHasher() {
                return CockpitAttributeReference.REFERENCES_EQUAL_ATTRIBUTES_HASHER;
            }

            public IHasher_<? super CockpitDataTypeReference> getSourceDataTypeKeyHasher() {
                return CockpitDataTypeReference.REFERENCES_EQUAL_DATATYPES_HASHER;
            }

            public IHasher_<? super CockpitValueReference> getSourceEnumValueKeyHasher() {
                return CockpitValueReference.REFERENCES_EQUAL_VALUES_HASHER;
            }

            public IHasher_<? super String> getTargetKeyHasher() {
                return IHasher_.EQUALS_HASHER;
            }

            public IHasher_<? super Integer> getTargetDataTypeKeyHasher() {
                return IHasher_.EQUALS_HASHER;
            }

            public IHasher_<? super String> getTargetEnumValueKeyHasher() {
                return IHasher_.EQUALS_HASHER;
            }

            public String getSourceDataName() {
                return Messages.getString("MappingConfigurationPage.SourceDataName");
            }

            public String getTargetDataName() {
                return Messages.getString("MappingConfigurationPage.TargetDataName");
            }

            public String getLabelForCreateTargetAttributeButton() {
                return null;
            }

            public String getTooltipForCreateTargetAttributeButton() {
                return null;
            }

            public String getLabelForMapEnumValuesButton() {
                return Messages.getString("MappingConfigurationPage.MapEnumValuesButtonLabel");
            }

            public String getShellTitleForEnumValueMappingDialogue() {
                return Messages.getString("MappingConfigurationPage.MapEnumValuesDialogueShellTitle");
            }

            public String getTitleForEnumValueMappingDialogue() {
                return Messages.getString("MappingConfigurationPage.MapEnumValuesDialogueTitle");
            }

            public String getMessageForEnumValueMappingDialogue() {
                return Messages.getString("MappingConfigurationPage.MapEnumValuesDialogueMessage");
            }

            public String getSourceEnumValuesName() {
                return Messages.getString("AttributeMappingConfigurationHelper.SourceEnumValuesName");
            }

            public String getTargetEnumValuesName() {
                return Messages.getString("AttributeMappingConfigurationHelper.TargetEnumValuesName");
            }

            public String getLabelForCreateNewEnumValueButton() {
                return null;
            }

            public String getTooltipForCreateNewEnumValueButton() {
                return null;
            }

            public String getTextForSeveralSourceAttributesMappedToSameTargetAttributeError() {
                return Messages.getString("MappingConfigurationPage.SeveralSourceAttributesMappedToSameTargetAttributeError");
            }

            public String getTextForNotAllSourceAttributesMappedError() {
                return null;
            }

            public String getTextForMissingEnumValueMappingError() {
                return Messages.getString("MappingConfigurationPage.MissingEnumValueMappingError");
            }

            public String getTextForIncompleteEnumValueMappingError() {
                return Messages.getString("MappingConfigurationPage.IncompleteEnumValueMappingError");
            }

            public String getTextForMandatoryTargetAttributeNotMappedError() {
                return Messages.getString("MappingConfigurationPage.MandatoryTargetAttributeNotMappedError");
            }
        };
    }

    public static IAttributeMappingPersistencyHelper<CockpitAttributeReference, CockpitValueReference, String, Integer, String> getPersistencyHelper() {
        return new IAttributeMappingPersistencyHelper<CockpitAttributeReference, CockpitValueReference, String, Integer, String>(){

            public IArcwayMemento createChildMementoForAttributeAssignment(IArcwayMemento parent, CockpitAttributeReference sourceKey) {
                return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)parent, (String)AttributeMappingConfigurationHelper.KeyAttributeAssignment, (String)sourceKey.getUniqueStringRepresentation());
            }

            public void storeTargetKeyIntoMemento(IArcwayMemento memento, String targetKey) {
                if (targetKey != null) {
                    memento.putBoolean(AttributeMappingConfigurationHelper.KeyIsTargetAttributeAssigned, true);
                    memento.putString(AttributeMappingConfigurationHelper.KeyTargetAttributeKey, targetKey);
                } else {
                    memento.putBoolean(AttributeMappingConfigurationHelper.KeyIsTargetAttributeAssigned, false);
                }
            }

            public IArcwayMemento createChildMementoForEnumValueMapping(IArcwayMemento parent, CockpitAttributeReference sourceKey) {
                return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)parent, (String)AttributeMappingConfigurationHelper.KeyEnumValueMapping, (String)sourceKey.getUniqueStringRepresentation());
            }

            public void storeTargetAttributeConstraintsForEnumValueMappingIntoMemento(IArcwayMemento memento, ITargetAttributeDescription<String, Integer, String> targetAttribute) {
            }

            public IArcwayMemento createChildMementoForEnumValueAssignment(IArcwayMemento parent, CockpitValueReference sourceEnumValueKey) {
                return AttributeMappingConfigurationHelper.createChildMementoForEnumValueAssignment_(parent, sourceEnumValueKey.getUniqueStringRepresentation(UID_FORMATTER));
            }

            public void storeTargetEnumKeyIntoMemento(IArcwayMemento memento, String targetEnumValueKey) {
                AttributeMappingConfigurationHelper.storeTargetEnumKeyIntoMemento_(memento, targetEnumValueKey);
            }

            public IArcwayMemento getChildMementoForAttributeAssignment(IArcwayMemento parent, CockpitAttributeReference sourceKey) {
                return parent.getChild(AttributeMappingConfigurationHelper.KeyAttributeAssignment, sourceKey.getUniqueStringRepresentation());
            }

            public ITargetAttributeDescription<String, Integer, String> getTargetKeyOfMemento(IArcwayMemento memento, ICollection_<? extends ITargetAttributeDescription<String, Integer, String>> targetAttributes, ITargetAttributeDescription<String, Integer, String> markerForNoMapping) {
                Boolean isTargetAttributeAssigned = memento.getBoolean(AttributeMappingConfigurationHelper.KeyIsTargetAttributeAssigned);
                if (isTargetAttributeAssigned != null && isTargetAttributeAssigned.booleanValue()) {
                    String targetKey = memento.getString(AttributeMappingConfigurationHelper.KeyTargetAttributeKey);
                    for (ITargetAttributeDescription targetAttribute : targetAttributes) {
                        if (!((String)targetAttribute.getKey()).equals(targetKey)) continue;
                        return targetAttribute;
                    }
                    return null;
                }
                return null;
            }

            public IArcwayMemento getChildMementoForEnumValueMapping(IArcwayMemento parent, CockpitAttributeReference sourceKey) {
                return parent.getChild(AttributeMappingConfigurationHelper.KeyEnumValueMapping, sourceKey.getUniqueStringRepresentation());
            }

            public boolean isMatchingTargetAttributeConstraintsForEnumValueMappingOfMemento(IArcwayMemento memento, ITargetAttributeDescription<String, Integer, String> targetAttribute) {
                return true;
            }

            public IArcwayMemento getChildMementoForEnumValueAssignment(IArcwayMemento parent, CockpitValueReference sourceEnumValueKey) {
                return AttributeMappingConfigurationHelper.getChildMementoForEnumValueAssignment_(parent, sourceEnumValueKey.getUniqueStringRepresentation(UID_FORMATTER));
            }

            public String getTargetEnumKeyOfMemento(IArcwayMemento memento, ITargetAttributeDescription_forEnumValueMapping<String> targetAttribute) {
                return AttributeMappingConfigurationHelper.getTargetEnumKeyOfMemento_(memento, (ITargetAttributeDescription_forEnumValueMapping<String>)targetAttribute);
            }
        };
    }

    private static IArcwayMemento createChildMementoForEnumValueAssignment_(IArcwayMemento parent, String sourceEnumValueKey) {
        return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)parent, (String)KeyEnumValueAssignment, (String)sourceEnumValueKey);
    }

    private static void storeTargetEnumKeyIntoMemento_(IArcwayMemento memento, String targetEnumValueKey) {
        if (targetEnumValueKey != null) {
            memento.putBoolean(KeyIsTargetEnumValueAssigned, true);
            memento.putString(KeyTargetEnumValueKey, targetEnumValueKey);
        } else {
            memento.putBoolean(KeyIsTargetEnumValueAssigned, false);
        }
    }

    private static IArcwayMemento getChildMementoForEnumValueAssignment_(IArcwayMemento parent, String sourceEnumValueKey) {
        return parent.getChild(KeyEnumValueAssignment, sourceEnumValueKey);
    }

    private static String getTargetEnumKeyOfMemento_(IArcwayMemento memento, ITargetAttributeDescription_forEnumValueMapping<String> targetAttribute) {
        Boolean isTargetEnumValueAssigned = memento.getBoolean(KeyIsTargetEnumValueAssigned);
        if (isTargetEnumValueAssigned != null && isTargetEnumValueAssigned.booleanValue()) {
            String targetEnumValueKey = memento.getString(KeyTargetEnumValueKey);
            for (EnumValue enumValue : targetAttribute.getValueRange()) {
                if (!((String)enumValue.getId()).equals(targetEnumValueKey)) continue;
                return (String)enumValue.getId();
            }
            return null;
        }
        return null;
    }

    public static ISourceAttributeDescription_forEnumValueMapping<String> getSourceAttributeDescriptionForAuthorMapping(IFrameProjectAgent projectAgent, ICollection_<IRepositoryObjectTypeID> objectTypes) {
        return AttributeMappingConfigurationHelper.getSourceAttributeDescriptionForAuthorMapping(AttributeMappingConfigurationHelper.getCockpitAuthorNames(projectAgent, objectTypes));
    }

    private static final List<String> getCockpitAuthorNames(IFrameProjectAgent projectAgent, ICollection_<IRepositoryObjectTypeID> objectTypes) {
        IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
        final ILocksAndPermissionsManagerDeprecated deprecationManager = repositoryInterface.getLocksAndPermissionsManagerDeprecated();
        final HashSet<String> authorNames = new HashSet<String>();
        authorNames.add(projectAgent.getFrameServerProxy().getCurrentUser().getDisplayName());
        for (EOUser user : projectAgent.getFrameServerProxy().getAllServerUsers()) {
            authorNames.add(user.getDisplayName());
        }
        for (IRepositoryObjectTypeID relevantObjectTypeID : objectTypes) {
            final IRepositoryObjectType relevantObjectType = repositoryInterface.getTypeManager().getObjectType(relevantObjectTypeID);
            RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                    IRepositoryIterator_IRepositoryObject objectIterator = repositorySnapshot.findAllObjectOfType(relevantObjectType);
                    while (objectIterator.hasNext()) {
                        IRepositoryObject object = objectIterator.nextIRepositoryObject();
                        String author = deprecationManager.getAuthorOfObject(object);
                        authorNames.add(author);
                        String lastModifier = deprecationManager.getLastModifierOfObject(object);
                        authorNames.add(lastModifier);
                    }
                }
            });
        }
        return AttributeMappingConfigurationHelper.getSortedCockpitAuthorNames(authorNames);
    }

    public static final ISourceAttributeDescription_forEnumValueMapping<String> getSourceAttributeDescriptionForAuthorMapping(IRepositorySnippetRO snippet, IRepositoryTypeManagerRO typeManager, ILocksAndPermissionsManagerDeprecated deprecationManager, ICollection_<IRepositoryObjectTypeID> objectTypesToExport) {
        HashSet_ objectTypesToExport_ = new HashSet_(objectTypesToExport, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        HashSet<String> authorNames = new HashSet<String>();
        for (RepositoryObjectSampleWithParentObjectReference explicitObject : snippet.getExplicitObjects()) {
            AttributeMappingConfigurationHelper.addAuthorAndModifierFromSample(explicitObject.getObjectSample(), authorNames, typeManager, deprecationManager, (ISet_<IRepositoryObjectTypeID>)objectTypesToExport_);
        }
        for (RepositoryObjectSampleWithParentObjectReference implicitObject : snippet.getImplicitObjects()) {
            AttributeMappingConfigurationHelper.addAuthorAndModifierFromSample(implicitObject.getObjectSample(), authorNames, typeManager, deprecationManager, (ISet_<IRepositoryObjectTypeID>)objectTypesToExport_);
        }
        List<String> sortedAuthorNames = AttributeMappingConfigurationHelper.getSortedCockpitAuthorNames(authorNames);
        return AttributeMappingConfigurationHelper.getSourceAttributeDescriptionForAuthorMapping(sortedAuthorNames);
    }

    private static final void addAuthorAndModifierFromSample(IRepositoryObjectSample sample, Set<String> authorNames, IRepositoryTypeManagerRO typeManager, ILocksAndPermissionsManagerDeprecated deprecationManager, ISet_<IRepositoryObjectTypeID> objectTypesToExport_) {
        IRepositoryObjectType objectType = typeManager.getObjectType(sample.getObjectTypeID());
        if (RepositoryObjectTypes.findMostSpecificSuperObjectType((IRepositoryObjectType)objectType, objectTypesToExport_) != null) {
            authorNames.add(deprecationManager.getAuthorOfObject(sample));
            authorNames.add(deprecationManager.getLastModifierOfObject(sample));
        }
    }

    private static final List<String> getSortedCockpitAuthorNames(Set<String> authorNames) {
        ArrayList<String> sortedAuthorNames = new ArrayList<String>(authorNames);
        Collections.sort(sortedAuthorNames, StringComparatorFactory.getStringComparator((boolean)true));
        return sortedAuthorNames;
    }

    private static final ISourceAttributeDescription_forEnumValueMapping<String> getSourceAttributeDescriptionForAuthorMapping(List<String> authorNames) {
        final ArrayList<EnumValue> authors = new ArrayList<EnumValue>();
        for (String authorName : authorNames) {
            authors.add(new EnumValue((Object)authorName, authorName, authorName));
        }
        return new ISourceAttributeDescription_forEnumValueMapping<String>(){

            public List<EnumValue<String>> getValueRange() {
                return authors;
            }

            public String getName() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.CockpitName");
            }
        };
    }

    public static final ITargetAttributeDescription_forEnumValueMapping<String> getTargetAttributeDescriptionForAuthorMapping(IProject qcProject) {
        final ArrayList<EnumValue> qcUsers = new ArrayList<EnumValue>();
        for (String qcUser : qcProject.getUserListValues()) {
            qcUsers.add(new EnumValue((Object)qcUser, qcUser, qcUser));
        }
        return new ITargetAttributeDescription_forEnumValueMapping<String>(){

            public List<EnumValue<String>> getValueRange() {
                return qcUsers;
            }

            public boolean mayExtendValueRange() {
                return false;
            }

            public String getName() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.QCName");
            }
        };
    }

    public static IAttributeMappingWidgetSettings_forEnumValueMapping<String, String> getSettingsForAuthorMapping() {
        return new IAttributeMappingWidgetSettings_forEnumValueMapping<String, String>(){

            public IHasher_<? super String> getSourceEnumValueKeyHasher() {
                return IHasher_.EQUALS_HASHER;
            }

            public IHasher_<? super String> getTargetEnumValueKeyHasher() {
                return IHasher_.EQUALS_HASHER;
            }

            public String getShellTitleForEnumValueMappingDialogue() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.DialogueTitle");
            }

            public String getTitleForEnumValueMappingDialogue() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.Title");
            }

            public String getMessageForEnumValueMappingDialogue() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.Message");
            }

            public String getSourceEnumValuesName() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.CockpitName");
            }

            public String getTargetEnumValuesName() {
                return Messages.getString("ConfigurationPage.MetaAttributes.Author.QCName");
            }

            public String getLabelForCreateNewEnumValueButton() {
                return null;
            }

            public String getTooltipForCreateNewEnumValueButton() {
                return null;
            }
        };
    }

    public static IEnumValueMappingPersistencyHelper<String, String> getPersistencyHelperForAuthorMapping() {
        return new IEnumValueMappingPersistencyHelper<String, String>(){

            public IArcwayMemento createChildMementoForEnumValueAssignment(IArcwayMemento parent, String sourceEnumValueKey) {
                return AttributeMappingConfigurationHelper.createChildMementoForEnumValueAssignment_(parent, sourceEnumValueKey);
            }

            public void storeTargetEnumKeyIntoMemento(IArcwayMemento memento, String targetEnumValueKey) {
                AttributeMappingConfigurationHelper.storeTargetEnumKeyIntoMemento_(memento, targetEnumValueKey);
            }

            public IArcwayMemento getChildMementoForEnumValueAssignment(IArcwayMemento parent, String sourceEnumValueKey) {
                return AttributeMappingConfigurationHelper.getChildMementoForEnumValueAssignment_(parent, sourceEnumValueKey);
            }

            public String getTargetEnumKeyOfMemento(IArcwayMemento memento, ITargetAttributeDescription_forEnumValueMapping<String> targetAttribute) {
                return AttributeMappingConfigurationHelper.getTargetEnumKeyOfMemento_(memento, (ITargetAttributeDescription_forEnumValueMapping<String>)targetAttribute);
            }
        };
    }
}

