/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.jiraadapter.configuration;

import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.jiraadapter.configuration.MappingConfiguration;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.ArcwayMementoHelper;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import de.plans.lib.xml.EOArcwayMemento;
import de.plans.lib.xml.ISaveListener;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class Configuration
implements IConfigurationRO {
    private static final ILogger LOGGER = Logger.getLogger(Configuration.class);
    public static final String GLOBAL_PROJECT_CONFIGURATION_KEY = "qualitycenteradapter";
    private static final String keyURL = "url";
    private static final String keyDomain = "domain";
    private static final String keyProject = "project";
    private static final String keyComponent = "component";
    private static final String keyIssueTypeName = "issueTypeName";
    private static final String keyQCFieldIDForCockpitTechnicalID = "qcFieldIDForCockpitTechnicalID";
    private static final String keyURLFieldID = "URLFieldID";
    private static final String keyURLPrefix = "URLPrefix";
    private static final String keyIsUsingCockpitMetaData = "isUsingCockpitMetaData";
    private static final String keyIsUsingCockpitModificationTime = "isUsingCockpitModificationTime";
    private static final String keyIsUsingAuthorMapping = "isUsingAuthorMapping";
    private static final String keyAuthorMapping = "userMapping";
    private static final String keyMappingConfiguration = "mappingConfiguration";
    private final EOArcwayMemento configuration;
    private static final IEncodableObjectFactory eoFactory = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{new IEncodableObjectFactory(){

        public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
            if (name.equals("com.arcway.cockpit.frame.client.project.localsettings.EOLocalSetting")) {
                return new EOArcwayMemento(context, new ISaveListener(){

                    public void save() {
                    }
                });
            }
            return MessageDataFactory.getInstance().createEncodableObject(name, context);
        }
    }, PSCPlainMessageDataFactory.getDefault()});

    public Configuration() {
        this.configuration = Configuration.getBlankConfiguration();
        this.setURL("");
        this.setDomain("");
        this.setProject("");
        this.setIssueTypeName("Bug");
        this.setComponent("");
        this.setQCFieldIDForCockpitTechnicalID("");
        this.setURLFieldID("");
        this.setURLPrefix("");
        this.setIsUsingCockpitMetaData(false);
        this.setIsUsingCockpitModificationTime(false);
        this.setIsUsingAuthorMapping(true);
    }

    private Configuration(EOArcwayMemento configuration) {
        this.configuration = configuration;
    }

    public void setURL(String url) {
        this.configuration.putString(keyURL, url);
    }

    @Override
    public String getURL() {
        return this.configuration.getString(keyURL);
    }

    public void setDomain(String domain) {
        this.configuration.putString(keyDomain, domain);
    }

    @Override
    public String getDomain() {
        return this.configuration.getString(keyDomain);
    }

    public void setProject(String project) {
        this.configuration.putString(keyProject, project);
    }

    @Override
    public String getProject() {
        return this.configuration.getString(keyProject);
    }

    @Override
    public String getQCFieldIDForCockpitTechnicalID() {
        return this.configuration.getString(keyQCFieldIDForCockpitTechnicalID) != null ? this.configuration.getString(keyQCFieldIDForCockpitTechnicalID) : "";
    }

    public void setQCFieldIDForCockpitTechnicalID(String qcFieldIDForCockpitTechnicalID) {
        this.configuration.putString(keyQCFieldIDForCockpitTechnicalID, qcFieldIDForCockpitTechnicalID);
    }

    @Override
    public boolean isUsingCockpitMetaData() {
        Boolean storedValue = this.configuration.getBoolean(keyIsUsingCockpitMetaData);
        return storedValue != null && storedValue != false;
    }

    public void setIsUsingCockpitMetaData(boolean isUsingCockpitMetaData) {
        this.configuration.putBoolean(keyIsUsingCockpitMetaData, isUsingCockpitMetaData);
    }

    @Override
    public boolean isUsingCockpitModificationMetaData() {
        Boolean storedValue = this.configuration.getBoolean(keyIsUsingCockpitModificationTime);
        return storedValue != null && storedValue != false;
    }

    public void setIsUsingCockpitModificationTime(boolean isUsingCockpitModificationTime) {
        this.configuration.putBoolean(keyIsUsingCockpitModificationTime, isUsingCockpitModificationTime);
    }

    @Override
    public boolean isUsingAuthorMapping() {
        Boolean storedValue = this.configuration.getBoolean(keyIsUsingAuthorMapping);
        return storedValue != null && storedValue != false;
    }

    public void setIsUsingAuthorMapping(boolean isUsingAuthorMapping) {
        this.configuration.putBoolean(keyIsUsingAuthorMapping, isUsingAuthorMapping);
    }

    @Override
    public IArcwayMemento getAuthorMapping() {
        return ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)this.configuration, (String)keyAuthorMapping);
    }

    @Override
    public MappingConfiguration getMappingConfiguration(IRepositoryObjectTypeID objectType) {
        IArcwayMemento mappingConfiguration = ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)this.configuration, (String)keyMappingConfiguration, (String)objectType.toCanonicalString());
        return new MappingConfiguration(mappingConfiguration);
    }

    public static final String getConfigurationString(Configuration configuration) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            configuration.configuration.writeToXMLStream((OutputStream)byteStream, false);
            return new String(byteStream.toByteArray());
        }
        catch (EXEncoderException eEE) {
            LOGGER.warn("Could not serialise the QC adapter configuration.", (Throwable)eEE);
            assert (false);
            return null;
        }
    }

    public static final Configuration getConfiguration(String configurationString) {
        if (configurationString != null) {
            try {
                return new Configuration((EOArcwayMemento)new XMLDecoder().decodeXML((InputStream)new ByteArrayInputStream(configurationString.getBytes()), eoFactory, true));
            }
            catch (EXDecoderException eDE) {
                LOGGER.warn("Could not deserialise the QC adapter configuration.", (Throwable)eDE);
                assert (false);
                return null;
            }
        }
        return new Configuration();
    }

    private static final EOArcwayMemento getBlankConfiguration() {
        return new EOArcwayMemento(GLOBAL_PROJECT_CONFIGURATION_KEY, "root", new ISaveListener(){

            public void save() {
            }
        });
    }

    @Override
    public String getComponent() {
        return this.configuration.getString(keyComponent) != null ? this.configuration.getString(keyComponent) : "";
    }

    public void setComponent(String component) {
        this.configuration.putString(keyComponent, component);
    }

    @Override
    public String getIssueTypeName() {
        return this.configuration.getString(keyIssueTypeName) != null ? this.configuration.getString(keyIssueTypeName) : "";
    }

    public void setIssueTypeName(String issueTypeName) {
        this.configuration.putString(keyIssueTypeName, issueTypeName);
    }

    @Override
    public String getURLFieldID() {
        return this.configuration.getString(keyURLFieldID) != null ? this.configuration.getString(keyURLFieldID) : "";
    }

    public void setURLFieldID(String urlFieldID) {
        this.configuration.putString(keyURLFieldID, urlFieldID);
    }

    @Override
    public String getURLPrefix() {
        return this.configuration.getString(keyURLPrefix) != null ? this.configuration.getString(keyURLPrefix) : "";
    }

    public void setURLPrefix(String urlPrefix) {
        this.configuration.putString(keyURLPrefix, urlPrefix);
    }
}

