/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.rest.jira.ws.service.impl;

import com.arcway.lib.rest.jira.ws.json.Issue;
import com.arcway.lib.rest.jira.ws.json.IssueQuery;
import com.arcway.lib.rest.jira.ws.json.IssueResult;
import com.arcway.lib.rest.jira.ws.json.adapter.IssueTypeAdapter;
import com.arcway.lib.rest.jira.ws.service.IJiraWsService;
import com.arcway.lib.rest.jira.ws.service.impl.RestClient;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URIBuilder;

public class JiraHttpServiceImpl
implements IJiraWsService {
    private static final String ISSUE_PATH = "/issue/";
    private static final String ISSUE_SEARCH_PATH = "/search/";
    private final URI targetURI;
    private RestClient restClient;

    public JiraHttpServiceImpl(URI targetURI) {
        this.targetURI = targetURI;
    }

    public void init(URI targetURI, String userId, String password) {
        this.restClient = new RestClient();
        this.restClient.init(targetURI, userId, password);
    }

    private URI appendPath(URI targetURI, String path) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(targetURI);
        String createPathString = (String.valueOf(uriBuilder.getPath()) + path).replaceAll("//+", "/");
        uriBuilder.setPath(createPathString);
        return uriBuilder.build();
    }

    @Override
    public Issue createIssue(Issue issue) {
        String serIssueString = "<none>";
        try {
            URI issueURI = this.appendPath(this.targetURI, ISSUE_PATH);
            IssueTypeAdapter jsonAdapter = new IssueTypeAdapter();
            JsonObject serIssue = (JsonObject)jsonAdapter.serialize(issue, (Type)((Object)Issue.class), null);
            serIssueString = serIssue.toString();
            Issue issueResponse = this.restClient.post2(issueURI, serIssueString, Issue.class);
            return issueResponse;
        }
        catch (Throwable e) {
            throw new RuntimeException("error while creating jira issue " + serIssueString + ":" + e.getMessage(), e);
        }
    }

    private IssueResult searchIssues(IssueQuery query) throws UnsupportedEncodingException, URISyntaxException, IOException, ClientProtocolException {
        URI searchURI = this.appendPath(this.targetURI, ISSUE_SEARCH_PATH);
        IssueResult result = this.restClient.post(searchURI, query, IssueResult.class);
        return result;
    }

    @Override
    public IssueResult searchIssues(String project, String component, int maxResults) {
        String jqlString = "<none>";
        try {
            IssueQuery query = new IssueQuery();
            query.setMaxResults(new Integer(maxResults));
            StringBuilder jql = new StringBuilder();
            jql.append("project=").append("\"").append(project).append("\"");
            if (component != null) {
                jql.append(" AND ");
                jql.append("component=").append("\"").append(component).append("\"");
            }
            jqlString = jql.toString();
            query.setJql(jqlString);
            return this.searchIssues(query);
        }
        catch (Throwable e) {
            throw new RuntimeException("error while search jira issues: " + jqlString, e);
        }
    }

    @Override
    public IssueResult searchIssues(String project, String component, String customFieldNo, String customFieldValue, int maxResults) {
        String jqlString = "<none>";
        try {
            IssueQuery query = new IssueQuery();
            query.setMaxResults(new Integer(maxResults));
            StringBuilder jql = new StringBuilder();
            jql.append("project=").append("\"").append(project).append("\"");
            jql.append(" AND ");
            if (component.length() > 0) {
                jql.append("component=").append("\"").append(component).append("\"");
                jql.append(" AND ");
            }
            jql.append("cf[").append(customFieldNo).append("]").append(" ~ ").append("\"").append(customFieldValue).append("\"");
            jqlString = jql.toString();
            query.setJql(jqlString);
            return this.searchIssues(query);
        }
        catch (Throwable e) {
            throw new RuntimeException("error while search jira issues: " + jqlString, e);
        }
    }

    @Override
    public IssueResult searchIssuesWithFilledCustomField(String project, String component, String customFieldNo, int maxResults) {
        String jqlString = "<none>";
        try {
            IssueQuery query = new IssueQuery();
            query.setMaxResults(new Integer(maxResults));
            StringBuilder jql = new StringBuilder();
            jql.append("project=").append("\"").append(project).append("\"");
            jql.append(" AND ");
            jql.append("component=").append("\"").append(component).append("\"");
            jql.append(" AND ");
            jql.append("cf[").append(customFieldNo).append("]").append(" is not empty");
            jqlString = jql.toString();
            query.setJql(jqlString);
            return this.searchIssues(query);
        }
        catch (Throwable e) {
            throw new RuntimeException("error while search jira issues: " + jqlString, e);
        }
    }

    @Override
    public void close() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

