/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.rest.jira.ws.json.adapter;

import com.arcway.lib.rest.jira.ws.json.IssueFields;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;

public class IssueFieldsTypeAdapter
implements JsonSerializer<IssueFields>,
JsonDeserializer<IssueFields> {
    public JsonElement serialize(IssueFields value, Type typeOfT, JsonSerializationContext context) {
        JsonObject result = (JsonObject)new Gson().toJsonTree((Object)value, typeOfT);
        Properties customFields = value.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            for (Map.Entry<Object, Object> entry : customFields.entrySet()) {
                String fieldKey = (String)entry.getKey();
                String fieldValue = (String)entry.getValue();
                result.add(fieldKey, (JsonElement)new JsonPrimitive(fieldValue));
            }
        }
        return result;
    }

    public IssueFields deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new Gson();
        IssueFields result = (IssueFields)gson.fromJson(json, typeOfT);
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String fieldKey = (String)entry.getKey();
            if (!fieldKey.startsWith("customfield_")) continue;
            JsonElement fieldValue = (JsonElement)entry.getValue();
            result.getCustomFields().setProperty(fieldKey, fieldValue.getAsString());
        }
        return result;
    }
}

