@echo off
REM #########################################################################################
REM
REM Copyright ARCWAY AG 2005-2021
REM
REM Windows batch file that sets the necessary environment variables to run the CoPilot Sync script
REM and then runs the CoPilot Sync script.
REM
REM #########################################################################################
SETLOCAL enabledelayedexpansion

REM ######### BEGIN SETTINGS ########

REM Path to home directory of Cockpit with installed CoPilot Module
SET "COCKPIT_HOME=C:\Program Files (x86)\ARCWAY\ARCWAY Cockpit 3.8 Enterprise Client\"

REM Additional parameter for starting Cockpit
REM Example: SET COCKPIT_START_PARAMETER=-nl de_DE --launcher.suppressErrors -data "C:\My Cockpit Workspace"
SET COCKPIT_START_PARAMETER=-nl de_DE --launcher.suppressErrors

REM eMail address to send error reports to
SET "MAIL_RECIPIENT=recipient@example.com"

REM Subject of the eMail
SET "MAIL_SUBJECT=CoPilot Error"

REM ########## END SETTINGS #########


REM Find and call the main script
FOR /F "delims=|" %%I IN ('DIR "%COCKPIT_HOME%\plugins\com.arcway.cockpit.reqifadapter_*" /A:D /B /O:D') DO SET NEWEST_PLUGIN_FOLDER=%%I
call "%COCKPIT_HOME%\plugins\%NEWEST_PLUGIN_FOLDER%\scripting\CoPilotSync.bat"
ENDLOCAL