
if (typeof loadConf === "undefined") {
	
	/**
	 * Loads and returns the config.
	 * 
	 * Uses the options provided via the argument or the default options, if no option was specified 
	 * 
	 * @param options an object with the options that will overwrite the default values. can be null
	 * 
	 * @return the assembled options object
	 */
	var loadConf = function (args) {
		
		var options;
		
		if (args.hasOwnProperty("children") && Array.isArray(args.children) && args.children.length > 0 &&
				args.children[0].attributes != null && typeof args.children[0].attributes === "object") {
			options = args.children[0].attributes;
		} else {
			options = new Object();
		}
		
		var assembledOptions = new Object();
		
		var OPTIONS = {
		
		   	// Name					Data Type		Default Value	
			"ReqIFHost"			: [	"String",	"http://localhost:8080" ],
			"ReqIFUsername"		: [	"String",	"admin" ],
			"ReqIFPassword"		: [	"String",	"eXXcellent" ],
			
			"CoPilotBaseURL"		: [	"String",	"" ],
			
			"CustomPropertyReqIFIdentifier"		: [	"String",	"custom.copilotidentifier" ], 			// CP type string
			"CustomPropertyExportVisibility"	: [	"String",	"custom.copilotvisibility" ],			// CP type boolean
			"CustomPropertyCreatedAt"			: [	"String",	"custom.copilotcreatedat" ],			// CP type string
			"CustomPropertyCreatedBy"			: [	"String",	"custom.copilotcreatedby" ],			// CP type string
			"CustomPropertyReferredElement"		: [	"String",	"custom.copilotrefferedelement" ],		// CP type string
			"CustomPropertyReferredElementURL"	: [	"String",	"custom.copilotrefferedelementurl" ],	// CP type url
			
			"IssueCategoryForComments" : [ "String",	"copilotcomment" ],
			
			"CustomPropertySyncVisibilityIsOptional" : [ "Boolean",	true ],
			
			"ReqIFRole"			: [ "String",	"ANNOTATOR" ],
			
			"LoggingLevel"		: [ "String",	"info" ],
			
			"AlwaysShowMerge"	: [ "Boolean",	false ],
		
			"ModelElementPerSubFolder"	: [ "Number" , 50 ],
			
			"MaxFileSizeSumInMegaByte"	: [ "Number" , 250 ],
			
			"CustomPropertiesToExclude"	: [	"CommaSeparatedString", ""],
		
			"ExportTemplateFolder"		: [	"Boolean", false],
		
			"NewRequirementsArePublic"	: [	"Boolean", false]
		};
		
		// building config
		// chooses given option values over default values
		var optionName;
		var optionType;
		var optionDefaultValue;
		var potentialValue;
		for (var singleOption in OPTIONS) {
			optionName = singleOption;
			optionType = OPTIONS[singleOption][0];
			optionDefaultValue = OPTIONS[singleOption][1];
			if (options.hasOwnProperty(optionName)) {
				potentialValue = options[optionName];
			} else {
				potentialValue = optionDefaultValue;
			}
			if (optionType === "String") {
				assembledOptions[optionName] = String(potentialValue);
			} else if (optionType === "CommaSeparatedString") {
				var splittedString = String(potentialValue).split(",");
				assembledOptions[optionName] = [];
				var trimmedString = "";
				for (var i = 0; i < splittedString.length; i++) {
					trimmedString = splittedString[i].trim();
					if (trimmedString.length > 0) {
						assembledOptions[optionName].push(trimmedString);
					}
				}
			} else if (optionType === "Boolean") {
				assembledOptions[optionName] = String(potentialValue).toLowerCase() === "true";
			} else if (optionType === "Number") {
				assembledOptions[optionName] = Number(potentialValue);
			} else {
				throw new Error("Unknown option type '" + optionType + "'");
			}
		}
		
		return assembledOptions;
	};
} else {
	throw new Error("Cannot create function 'loadConf'. Name is already in use.");
}