/*
 * Definition of some useful or in Rhino missing functions
 */
if (typeof Array.isArray !== 'function') {
	Array.isArray = function(array) {
		if (Object.prototype.toString.call(array) === '[object Array]') {
		    return true;
		} else {
			return false;
		}
	};
}

if (typeof Array.prototype.addAll !== 'function') {
	Array.prototype.addAll = function(array) {
		var thisArray = this;
		if (Array.isArray(array)) {
			array.forEach(function(element) {
				thisArray.push(element);
			});
		} else {
			thisArray.push(array);
		}
	};
}

if (typeof String.prototype.startsWith !== 'function') {
	String.prototype.startsWith = function (str) {
		return this.slice(0, str.length) === str;
	};
}

if (typeof String.prototype.endsWith !== 'function') {
	String.prototype.endsWith = function (str) {
		return this.slice(this.length - str.length) === str;
	};
}

if (typeof String.prototype.trim !== 'function') {
	String.prototype.trim = function () {
		return this.replace(/^\s+|\s+$/g, '');
	};
}

function getBooleanValueFromString(booleanString) {
	var realBooleanString = String(booleanString).toLowerCase();
	if (realBooleanString === "true" || realBooleanString === "wahr") {
		return true;
	} else if (realBooleanString === "false" || realBooleanString === "falsch") {
		return false;
	}
	return null;
}

/**
 * Throws an Error if the result to check is false
 * 
 * @param result the result to check
 * @param message the error message. Can either be a string or a function returning a string
 */
function assert(result, message) {
	if (!result) {
		if (typeof message === "function") {
			throw new Error(message());
		} else {
			throw new Error(message);
		}
	}
}
