@echo off
REM #########################################################################################
REM
REM Copyright ARCWAY AG 2005-2013
REM
REM Windows batch file to sync several ARCWAY Cockpit Projects with the
REM ARCWAY CoPilot web components.
REM
REM The projects to sync have to be defined in the XML files in the current working directory
REM
REM Following environment variables need to be defined, before the batch file is run:
REM
REM COCKPIT_HOME:				Directory that the ARCWAY Cockpit Client was installed into
REM COCKPIT_START_PARAMETER:	Additional paramaters to use when starting the ARCWAY Cockpit Client 
REM MAIL_RECIPIENT:				eMail address to send error reports to
REM MAIL_SUBJECT:				Subject of the eMail
REM
REM #########################################################################################
SETLOCAL enabledelayedexpansion

REM check if variables are set
IF NOT DEFINED COCKPIT_HOME (
	echo COCKPIT_HOME is not defined
	goto end
)
IF NOT DEFINED MAIL_RECIPIENT (
	echo MAIL_RECIPIENT is not defined
	goto end
)
IF NOT DEFINED MAIL_SUBJECT (
	echo MAIL_SUBJECT is not defined
	goto end
)
IF NOT DEFINED COCKPIT_START_PARAMETER (
	echo COCKPIT_START_PARAMETER is not defined
	goto end
)

REM check if jre included in cockpit installation exists
SET JAVA_EXE="%COCKPIT_HOME%\jre\bin\java.exe"
%JAVA_EXE% -version >NUL 2>&1
IF %ERRORLEVEL%==0 GOTO foundjava

REM check if there is any other sufficiently up to date jre installed
SET "JAVA_EXE=java.exe -version:1.6+"
%JAVA_EXE% -version >NUL 2>&1
IF %ERRORLEVEL%==0 GOTO foundjava

echo Found no sufficiently up to date JRE (1.6.0 or higher)
goto end

:foundjava

REM Find the most current cmdmailer
FOR /F "delims=|" %%I IN ('DIR "%COCKPIT_HOME%\plugins\com.arcway.commandlinemailer_*" /B /O:D') DO SET "NEWEST_CMD_MAILER=%COCKPIT_HOME%\plugins\%%I"
IF NOT DEFINED NEWEST_CMD_MAILER (
	echo Command line mail tool not found
	goto end
)

REM Running sync for all xml files in the local directory
FOR %%F in (*.xml) DO (
	SETLOCAL enabledelayedexpansion
	
	REM set log foler to the folder the XML file is in + name of the XML file without extentions + "-log"
	SET "LOGDIR=%%~dpF%%~nF-log"

	REM delete old log dir
	SET "LOGDIRDELETED=y"
	IF EXIST "!LOGDIR!" (
		
		REM delete contents that the script created
		IF EXIST "!LOGDIR!\exitcode.txt" (
			del "!LOGDIR!\exitcode.txt"
		)
		IF EXIST "!LOGDIR!\consoleCommand.log" (
			del "!LOGDIR!\consoleCommand.log"
		)
		IF EXIST "!LOGDIR!\sync.log" (
			del "!LOGDIR!\sync.log"
		)
		REM delete directonly if and only if it's empty
		rd "!LOGDIR!" || SET "LOGDIRDELETED=n"
	)
	
	SET "COCKPIT_WAS_RUN=y"
	
	REM run the Cockpit client with the XML file
	PUSHD !COCKPIT_HOME!
	ARCWAY_Cockpit.exe !COCKPIT_START_PARAMETER! -cockpitscriptfile "%%~fF"
	SET COCKPIT_EXITCODE=!ERRORLEVEL!
	POPD
	
	SET "SEND_MAIL=n"
	
	IF "!COCKPIT_EXITCODE!" == "-1" (
		SET "COCKPIT_WAS_RUN=n"
		SET "SEND_MAIL=y"
	) else (
		IF EXIST "!LOGDIR!\exitcode.txt" (
			SET /P exitcode=<"!LOGDIR!\exitcode.txt"
			IF "!exitcode!" NEQ "0" SET "SEND_MAIL=y"
		) ELSE (
			REM exit code not available. better send a mail
			SET "SEND_MAIL=y"
		)
	)
	
	REM notify via mail if exitcode != 0
	IF "!SEND_MAIL!" == "y" (
		SET ERRORREASON=There was an error synchronising the project specified in "%%F".
		SET "ARGUMENTS=-to ^"!MAIL_RECIPIENT!^""
		SET "ARGUMENTS=!ARGUMENTS! -subject ^"!MAIL_SUBJECT!^""
		
		IF "!COCKPIT_WAS_RUN!" == "y" (
			IF "!LOGDIRDELETED!" == "y" (
				SET "ERRORREASON=!ERRORREASON! See the attachments for further information."
				IF EXIST "!LOGDIR!\consoleCommand.log" (
					SET "ARGUMENTS=!ARGUMENTS! -attachment ^"!LOGDIR!\consoleCommand.log^""
				)
				IF EXIST "!LOGDIR!\sync.log" (
					SET "ARGUMENTS=!ARGUMENTS! -attachment ^"!LOGDIR!\sync.log^""
				)
			) ELSE (
				SET "ERRORREASON=!ERRORREASON! Could not delete old log directory. Please check the newly created temporary log directory manually."
			)
		) ELSE (
			SET "ERRORREASON=!ERRORREASON! The ARCWAY Cockpit workspace is still in use."
		)
		echo !ERRORREASON! | %JAVA_EXE% -jar "%NEWEST_CMD_MAILER%" -propertyfile "CmdMailer.properties" !ARGUMENTS!
	)
	
	ENDLOCAL
)
:end
ENDLOCAL