/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.json;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.EXUnknownFlagOrPropertyOrChildRoleForStructuredData;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.data.json.EXExcessCharacters;
import com.arcway.lib.codec.data.json.EXJSONDecodingFailed;
import com.arcway.lib.codec.data.json.EXMalformedJSON;
import com.arcway.lib.java.collections.IList_;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class JSONCoDecForData {
    private static final JsonFactory jsonFactory = new JsonFactory();

    public static String encodeIntoJSONString(IDataType dataType, Object data) {
        StringWriter jsonStringWriter = new StringWriter(10000);
        try (JsonGenerator jg = jsonFactory.createJsonGenerator((Writer)jsonStringWriter);){
            jg.useDefaultPrettyPrinter();
            JSONCoDecForData.encodeIntoJSONString(dataType, data, jg);
        }
        catch (JsonGenerationException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return ((Object)jsonStringWriter).toString();
    }

    private static void encodeIntoJSONString(IDataType dataType, Object data, JsonGenerator jg) throws JsonGenerationException, IOException {
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (concreteDataType.isNull(data)) {
            jg.writeNull();
        } else {
            Class type = dataType.getStructureType();
            if (IElementaryDataType.class.isAssignableFrom(type)) {
                IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
                JSONCoDecForData.encodeElementaryDataIntoJSON(elementaryDataType, data, jg);
            } else if (IStructuredDataType.class.isAssignableFrom(type)) {
                IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
                JSONCoDecForData.encodeStructuredDataIntoJSON(structuredDataType, data, jg);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void encodeElementaryDataIntoJSON(IElementaryDataType sourceDataType, Object sourceData, JsonGenerator jg) throws JsonGenerationException, IOException {
        jg.writeString(sourceDataType.getValueAsString(sourceData));
    }

    private static void encodeStructuredDataIntoJSON(IStructuredDataType sourceDataType, Object sourceData, JsonGenerator jg) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        IList_ allFlagAndPropertyAndChildRolesAsList = sourceDataType.getFlagAndPropertyAndChildRoles(sourceData);
        for (IKey role : allFlagAndPropertyAndChildRolesAsList) {
            SubDataType roleType = sourceDataType.getSubDataType(role);
            if (roleType.isFlag()) {
                if (sourceDataType.isSet(sourceData, role)) {
                    jg.writeStringField(role.toCanonicalString(), "true");
                    continue;
                }
                jg.writeStringField(role.toCanonicalString(), "false");
                continue;
            }
            if (roleType.isProperty() || roleType.isChild()) {
                IDataType dataTypeOfPropertyOrChild = sourceDataType.getDataTypeOfPropertyOrChildren(sourceData, role);
                jg.writeFieldName(role.toCanonicalString());
                if (roleType.isProperty()) {
                    Object propertyData = sourceDataType.getProperty(sourceData, role);
                    JSONCoDecForData.encodeIntoJSONString(dataTypeOfPropertyOrChild, propertyData, jg);
                    continue;
                }
                jg.writeStartArray();
                IList_ childDatas = sourceDataType.getChildren(sourceData, role);
                for (Object childData : childDatas) {
                    JSONCoDecForData.encodeIntoJSONString(dataTypeOfPropertyOrChild, childData, jg);
                }
                jg.writeEndArray();
                continue;
            }
            throw new UnsupportedOperationException();
        }
        jg.writeEndObject();
    }

    public static Object decodeFromJSONString(IDataType dataType, String jsonString) throws EXJSONDecodingFailed, EXDataCreationFailed {
        Object object;
        JsonParser jsonParser = jsonFactory.createJsonParser(jsonString);
        try {
            jsonParser.nextToken();
            Object object2 = JSONCoDecForData.decodeFromJSON(dataType, jsonParser);
            if (jsonParser.getCurrentToken() != null && jsonParser.getCurrentToken() != JsonToken.NOT_AVAILABLE) {
                throw new EXJSONDecodingFailed(new EXExcessCharacters(jsonParser.getTokenLocation()));
            }
            object = object2;
        }
        catch (Throwable throwable) {
            try {
                jsonParser.close();
                throw throwable;
            }
            catch (JsonParseException e) {
                throw new EXJSONDecodingFailed((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new EXJSONDecodingFailed(e);
            }
        }
        jsonParser.close();
        return object;
    }

    private static Object decodeFromJSON(IDataType dataType, JsonParser jsonParser) throws EXJSONDecodingFailed, EXDataCreationFailed, JsonParseException, IOException {
        Class type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
            return JSONCoDecForData.decodeElementaryData(elementaryDataType, jsonParser);
        }
        if (IStructuredDataType.class.isAssignableFrom(type)) {
            IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
            return JSONCoDecForData.decodeStructuredData(structuredDataType, jsonParser);
        }
        throw new IllegalArgumentException("Data type is neither elementary nor structured");
    }

    private static Object decodeElementaryData(IElementaryDataType elementaryDataType, JsonParser jsonParser) throws EXJSONDecodingFailed, EXDataCreationFailed, JsonParseException, IOException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NULL: {
                jsonParser.nextToken();
                return elementaryDataType.createNullDataElement();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                IElementaryDataFactory dataFactory = elementaryDataType.createDataFactory();
                dataFactory.setCharacters(jsonParser.getValueAsString());
                jsonParser.nextToken();
                return dataFactory.createDataElement();
            }
            case NOT_AVAILABLE: 
            case START_OBJECT: 
            case END_OBJECT: 
            case START_ARRAY: 
            case END_ARRAY: 
            case FIELD_NAME: 
            case VALUE_EMBEDDED_OBJECT: {
                throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
            }
        }
        assert (false) : "Unreachable code - above switch statements covers all cases.";
        return null;
    }

    private static Object decodeStructuredData(IStructuredDataType targetDataType, JsonParser jsonParser) throws EXJSONDecodingFailed, EXDataCreationFailed, JsonParseException, IOException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NULL: {
                jsonParser.nextToken();
                return targetDataType.createNullDataElement();
            }
            case START_OBJECT: {
                break;
            }
            default: {
                throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
            }
        }
        assert (jsonParser.getCurrentToken() == JsonToken.START_OBJECT);
        jsonParser.nextToken();
        IStructuredDataFactory dataFactory = targetDataType.createDataFactory();
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
            }
            String fieldName = jsonParser.getCurrentName();
            Key role = Key.getCanonicalKeyInstance((String)fieldName);
            SubDataType roleType = targetDataType.getSubDataType((IKey)role);
            if (roleType == null) {
                EXJSONDecodingFailed exception = new EXJSONDecodingFailed((Exception)new EXUnknownFlagOrPropertyOrChildRoleForStructuredData((IKey)role));
                JSONCoDecForData.handleErroneousRole(dataFactory, (IKey)role, jsonParser, exception);
                continue;
            }
            JSONCoDecForData.handleRole((IKey)role, roleType, dataFactory, jsonParser);
        }
        jsonParser.nextToken();
        return dataFactory.createDataElement();
    }

    /*
     * Unable to fully structure code
     */
    private static void handleRole(IKey role, SubDataType roleType, IStructuredDataFactory dataFactory, JsonParser jsonParser) throws EXJSONDecodingFailed, EXDataCreationFailed, JsonParseException, IOException {
        block17: {
            block18: {
                block16: {
                    jsonParser.nextToken();
                    if (!roleType.isFlag()) break block16;
                    switch (JSONCoDecForData.$SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken()[jsonParser.getCurrentToken().ordinal()]) {
                        case 8: 
                        case 11: 
                        case 12: {
                            valueAsString = jsonParser.getValueAsString();
                            if ("true".equalsIgnoreCase(valueAsString)) {
                                dataFactory.setFlag(role);
                            }
                            jsonParser.nextToken();
                            break block17;
                        }
                        default: {
                            throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
                        }
                    }
                }
                if (roleType.isProperty()) {
                    dataTypeOfPropertyOrChild = dataFactory.getDataTypeOfPropertyOrChildren(role);
                    propertyValue = JSONCoDecForData.decodeFromJSON(dataTypeOfPropertyOrChild, jsonParser);
                    try {
                        dataFactory.addPropertyOrChild(role, propertyValue);
                    }
                    catch (EXDataAssemblingFailed e) {
                        throw new EXDataCreationFailed(e.getCausingException());
                    }
                }
                if (!roleType.isChild()) break block18;
                dataTypeOfPropertyOrChild = dataFactory.getDataTypeOfPropertyOrChildren(role);
                switch (JSONCoDecForData.$SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken()[jsonParser.getCurrentToken().ordinal()]) {
                    case 4: {
                        jsonParser.nextToken();
                        if (true) ** GOTO lbl39
                    }
                    default: {
                        throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
                    }
                }
                do {
                    propertyValue = JSONCoDecForData.decodeFromJSON(dataTypeOfPropertyOrChild, jsonParser);
                    try {
                        dataFactory.addPropertyOrChild(role, propertyValue);
                    }
                    catch (EXDataAssemblingFailed e) {
                        throw new EXDataCreationFailed(e.getCausingException());
                    }
lbl39:
                    // 2 sources

                } while (jsonParser.getCurrentToken() != JsonToken.END_ARRAY);
                switch (JSONCoDecForData.$SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken()[jsonParser.getCurrentToken().ordinal()]) {
                    case 5: {
                        jsonParser.nextToken();
                        break block17;
                    }
                    default: {
                        throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
                    }
                }
            }
            throw new EXJSONDecodingFailed((Exception)new EXDecoderException("Unknown role type: role type = \"" + roleType.toString() + "\"/ role = \"" + role.toCanonicalString() + "\""));
        }
    }

    private static void handleErroneousRole(IStructuredDataFactory dataFactory, IKey role, JsonParser jsonParser, EXJSONDecodingFailed exception) throws EXJSONDecodingFailed, JsonParseException, IOException {
        if (!dataFactory.isErroneousFlagOrPropertyOrChildToIgnore(role, (EXDataLoadingException)exception)) {
            throw exception;
        }
        jsonParser.nextToken();
        JSONCoDecForData.consumeDataToIgnore(jsonParser);
    }

    private static void consumeDataToIgnore(JsonParser jsonParser) throws EXJSONDecodingFailed, JsonParseException, IOException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_EMBEDDED_OBJECT: 
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: {
                jsonParser.nextToken();
                break;
            }
            case NOT_AVAILABLE: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
            }
            case START_ARRAY: {
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    switch (jsonParser.getCurrentToken()) {
                        case END_ARRAY: {
                            assert (false) : "Unreachable code - see while loop condition.";
                            break;
                        }
                        case START_OBJECT: 
                        case START_ARRAY: {
                            JSONCoDecForData.consumeDataToIgnore(jsonParser);
                            break;
                        }
                        case VALUE_EMBEDDED_OBJECT: 
                        case VALUE_STRING: 
                        case VALUE_NUMBER_INT: 
                        case VALUE_NUMBER_FLOAT: 
                        case VALUE_TRUE: 
                        case VALUE_FALSE: 
                        case VALUE_NULL: {
                            jsonParser.nextToken();
                            break;
                        }
                        case NOT_AVAILABLE: 
                        case END_OBJECT: 
                        case FIELD_NAME: {
                            throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
                        }
                    }
                }
                jsonParser.nextToken();
                break;
            }
            case START_OBJECT: {
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
                    switch (jsonParser.getCurrentToken()) {
                        case END_OBJECT: {
                            assert (false) : "Unreachable code - see while loop condition.";
                            break;
                        }
                        case FIELD_NAME: {
                            jsonParser.nextToken();
                            JSONCoDecForData.consumeDataToIgnore(jsonParser);
                            break;
                        }
                        case START_OBJECT: 
                        case START_ARRAY: {
                            JSONCoDecForData.consumeDataToIgnore(jsonParser);
                            break;
                        }
                        case VALUE_EMBEDDED_OBJECT: 
                        case VALUE_STRING: 
                        case VALUE_NUMBER_INT: 
                        case VALUE_NUMBER_FLOAT: 
                        case VALUE_TRUE: 
                        case VALUE_FALSE: 
                        case VALUE_NULL: {
                            jsonParser.nextToken();
                            break;
                        }
                        case NOT_AVAILABLE: 
                        case END_ARRAY: {
                            throw new EXJSONDecodingFailed(new EXMalformedJSON(jsonParser.getTokenLocation(), jsonParser.getCurrentToken()));
                        }
                    }
                }
                jsonParser.nextToken();
            }
        }
    }

    private static void handleErroneousPropertyOrChild(IStructuredDataFactory dataFactory, IKey role, EXDataCreationFailed exception) throws EXDataCreationFailed {
        if (!dataFactory.isErroneousFlagOrPropertyOrChildToIgnore(role, (EXDataLoadingException)exception)) {
            throw exception;
        }
    }
}

