/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.reqifadapter.consoleui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.VarargsParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.LogDirectoryParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ProjectParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.filters.FilterProviderManager;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.reqifadapter.Activator;
import com.arcway.cockpit.reqifadapter.JavaScriptProcessor;
import com.arcway.cockpit.reqifadapter.ScriptContextHelper;
import com.arcway.cockpit.reqifadapter.consoleui.JavaScriptDebugParameterSpecification;
import com.arcway.cockpit.reqifadapter.consoleui.ScriptFileParameterSpecification;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReqIFSyncAction
implements ICockpitConsoleAction {
    private static final ILogger LOGGER = Logger.getLogger(ReqIFSyncAction.class);
    private static final String COMMAND_NAME = "reqifsync";
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(ServerParameterSpecification.getSingleton(), ProjectParameterSpecification.getSingleton(), ScriptFileParameterSpecification.getSingleton(), LogDirectoryParameterSpecification.getSingleton(), VarargsParameterSpecification.getSingleton(), JavaScriptDebugParameterSpecification.getSingleton()));

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    public void execute(final ConsoleActionParameterBindings parameters, IParameterLog parameterLog, final ScriptCommandContext uiContext) throws ScriptExecutionException {
        File scriptFile;
        final String serverName = parameters.isParameterBound((ICockpitConsoleActionParameterSpecification)ServerParameterSpecification.getSingleton()) ? (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)ServerParameterSpecification.getSingleton()) : null;
        if (serverName == null) {
            throw new ScriptExecutionException("Could not execute reqifsync. Servername is missing.");
        }
        final String projectName = parameters.isParameterBound((ICockpitConsoleActionParameterSpecification)ProjectParameterSpecification.getSingleton()) ? (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)ProjectParameterSpecification.getSingleton()) : null;
        if (projectName == null) {
            throw new ScriptExecutionException("Could not execute reqifsync. (server: " + serverName + "). Projectname is missing.");
        }
        String scriptFileName = (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)ScriptFileParameterSpecification.getSingleton());
        if (scriptFileName == null || scriptFileName.length() == 0) {
            String DEFAULT_SCRIPT_FILE = "ReqIF.js";
            File scriptFileParentDir = ResourceLoader.getFile((String)Activator.getBundleSymbolicName(), (String)"scripting");
            if (scriptFileParentDir != null) {
                scriptFile = new File(scriptFileParentDir, "ReqIF.js");
            } else {
                LOGGER.debug("Unable to locate default scriptFile\"ReqIF.js\".");
                scriptFile = null;
            }
        } else {
            scriptFile = new File(scriptFileName);
        }
        if (scriptFile == null) {
            throw new ScriptExecutionException("Could not execute reqifsync. (project: " + projectName + " , server: " + serverName + "). ScriptFileName is missing and no default scriptfile is accessible.");
        }
        if (!scriptFile.canRead()) {
            throw new ScriptExecutionException("Could not execute reqifsync. (project: " + projectName + " , server: " + serverName + "). Unable to read ScriptFile - maybe it does not exist.");
        }
        parameterLog.logParameters(scriptFileName);
        if (parameters.getValue((ICockpitConsoleActionParameterSpecification)LogDirectoryParameterSpecification.getSingleton()) == null) {
            throw new ScriptExecutionException("Could not execute reqifsync. (project: " + projectName + " , server: " + serverName + "). logDir is missing.");
        }
        final File logDir = new File((String)parameters.getValue((ICockpitConsoleActionParameterSpecification)LogDirectoryParameterSpecification.getSingleton()));
        final String javaScriptDebugParameters = (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)JavaScriptDebugParameterSpecification.getSingleton());
        final IFrameProjectAgent frameProjectAgent = ProjectMgr.getProjectMgr().getProjectAgent(serverName, projectName);
        final IDocGeneratorProjectAgent docGeneratorProjectAgent = DocGeneratorProjectAgent.getInstance((String)serverName, (String)projectName);
        if (docGeneratorProjectAgent == null) {
            throw new ScriptExecutionException("Could not execute reqifsync. (project: " + projectName + " , server: " + serverName + "). Could not find project with this name.");
        }
        FilterProviderManager.doWithFilterItemProviders((IDocGeneratorProjectAgent)docGeneratorProjectAgent, (FilterProviderManager.IProcessor)new FilterProviderManager.IProcessor<ScriptExecutionException>(){

            public void run(Map<String, List<IFilterItemProvider>> projectUID2filterItemProviders) throws ScriptExecutionException {
                final JavaScriptProcessor commandContext = new JavaScriptProcessor(scriptFile);
                try {
                    final HashMap<String, Object> cummulatedContextObjects = new HashMap<String, Object>();
                    HashMap<String, Object> contextObjects = ScriptContextHelper.getReportProviderContextObjects(docGeneratorProjectAgent, projectUID2filterItemProviders, uiContext.getWorkbenchPage());
                    if (!$assertionsDisabled && cummulatedContextObjects.keySet().removeAll(contextObjects.keySet())) {
                        throw new AssertionError();
                    }
                    cummulatedContextObjects.putAll(contextObjects);
                    contextObjects = ScriptContextHelper.getImportInterfaceContextObjects(frameProjectAgent.getRepositoryInterface(), uiContext);
                    if (!$assertionsDisabled && cummulatedContextObjects.keySet().removeAll(contextObjects.keySet())) {
                        throw new AssertionError();
                    }
                    cummulatedContextObjects.putAll(contextObjects);
                    contextObjects = ScriptContextHelper.getShemaProviderContextObjects(frameProjectAgent.getRepositoryInterface());
                    if (!$assertionsDisabled && cummulatedContextObjects.keySet().removeAll(contextObjects.keySet())) {
                        throw new AssertionError();
                    }
                    cummulatedContextObjects.putAll(contextObjects);
                    contextObjects = ScriptContextHelper.getLogDirContextObjects(logDir);
                    if (!$assertionsDisabled && cummulatedContextObjects.keySet().removeAll(contextObjects.keySet())) {
                        throw new AssertionError();
                    }
                    cummulatedContextObjects.putAll(contextObjects);
                    if (parameters.isParameterBound((ICockpitConsoleActionParameterSpecification)VarargsParameterSpecification.getSingleton())) {
                        contextObjects = ScriptContextHelper.getVarargsContextObjects((Map)parameters.getValue((ICockpitConsoleActionParameterSpecification)VarargsParameterSpecification.getSingleton()));
                        if (!$assertionsDisabled && cummulatedContextObjects.keySet().removeAll(contextObjects.keySet())) {
                            throw new AssertionError();
                        }
                        cummulatedContextObjects.putAll(contextObjects);
                    }
                    final Exception[] returnValueContainer = new Exception[1];
                    frameProjectAgent.doWithSuspendedAsynchronousUpdate(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                commandContext.execute(cummulatedContextObjects, javaScriptDebugParameters);
                            }
                            catch (IOException e) {
                                returnValueContainer[0] = e;
                            }
                            catch (JvmExternalResourceInteractionException e) {
                                returnValueContainer[0] = e;
                            }
                        }
                    });
                    if (returnValueContainer[0] != null) {
                        throw returnValueContainer[0];
                    }
                }
                catch (Exception e) {
                    throw new ScriptExecutionException("Could not execute reqifsync. (project: " + projectName + " , server: " + serverName + "). Cause: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
    }
}

