/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.reqifadapter.consoleui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ProjectParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.reqifadapter.consoleui.CommitCommentParameterSpecification;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Arrays;

public class CommitAction
implements ICockpitConsoleAction {
    private static final ILogger LOGGER = Logger.getLogger(ProjectAgent.class);
    private static final String COMMAND_NAME = "commit";
    private static final ServerParameterSpecification SERVER_PARAM_SPEC = ServerParameterSpecification.getSingleton();
    private static final ProjectParameterSpecification PROJECT_PARAM_SPEC = ProjectParameterSpecification.getSingleton();
    private static final CommitCommentParameterSpecification COMMITCOMMENT_PARAM_SPEC = CommitCommentParameterSpecification.getSingleton();
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(new ICockpitConsoleActionParameterSpecification[]{SERVER_PARAM_SPEC, PROJECT_PARAM_SPEC, COMMITCOMMENT_PARAM_SPEC}));

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    public void execute(ConsoleActionParameterBindings parameters, IParameterLog parameterLog, ScriptCommandContext uiContext) throws ScriptExecutionException {
        String serverName = null;
        String projectName = null;
        String commitComment = null;
        if (parameters.isParameterBound((ICockpitConsoleActionParameterSpecification)SERVER_PARAM_SPEC)) {
            serverName = (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)SERVER_PARAM_SPEC);
        }
        if (parameters.isParameterBound((ICockpitConsoleActionParameterSpecification)PROJECT_PARAM_SPEC)) {
            projectName = (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)PROJECT_PARAM_SPEC);
        }
        if (parameters.isParameterBound((ICockpitConsoleActionParameterSpecification)COMMITCOMMENT_PARAM_SPEC)) {
            commitComment = (String)parameters.getValue((ICockpitConsoleActionParameterSpecification)COMMITCOMMENT_PARAM_SPEC);
        }
        if (serverName == null) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Servername is missing.");
        }
        if (projectName == null) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Projectname is missing.");
        }
        parameterLog.logParameters(String.valueOf(serverName) + " / " + projectName);
        if (commitComment == null) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). CommitComment is missing.");
        }
        ProjectAgent projectAgent = (ProjectAgent)ProjectMgr.getProjectMgr().getProjectAgent(serverName, projectName);
        if (projectAgent == null) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Could not find project with this name.");
        }
        if (!projectAgent.isOpened()) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Project is not open.");
        }
        if (!projectAgent.getFrameServerProxy().concurrentWorkPossible()) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Can not commit - is project in Offline mode?");
        }
        if (!projectAgent.isInMemoryStateConsistent() || !projectAgent.isDiskStateInSynchWithInMemoryState()) {
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Commit impossible -The client state is inconsistent or can not be saved permanently in the work space. In this condition, commiting the local changes is not possible.");
        }
        try {
            if (projectAgent.getCommitMgr().areModificationsPresent()) {
                projectAgent.commitProject(commitComment, true, false, EclipseSWTHelper.getShell());
            }
        }
        catch (Exception e1) {
            LOGGER.debug("Commit failed - project name: " + projectName + " reason: " + e1.getLocalizedMessage(), (Throwable)e1);
            throw new ScriptExecutionException("Could not commit changes. (project: " + projectName + " , server: " + serverName + "). Commit failed. Reason: " + e1.getLocalizedMessage());
        }
    }
}

