/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceJavadocParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.util.CommentRecorderParser;

public class SourceElementParser
extends CommentRecorderParser {
    ISourceElementRequestor requestor;
    ISourceType sourceType;
    boolean reportReferenceInfo;
    char[][] typeNames;
    char[][] superTypeNames;
    int nestedTypeIndex;
    int nestedMethodIndex;
    LocalDeclarationVisitor localDeclarationVisitor = null;
    CompilerOptions options;
    HashtableOfObjectToInt sourceEnds = new HashtableOfObjectToInt();
    HashMap nodesToCategories = new HashMap();
    boolean useSourceJavadocParser = true;
    HashtableOfObject notifiedTypes = new HashtableOfObject();
    public static final boolean NOTIFY_LOCALS = false;
    protected ASTVisitor contextDeclarationNotifier = new ASTVisitor(){

        public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
            if (SourceElementParser.this.nestedMethodIndex == 0) {
                SourceElementParser.this.notifySourceElementRequestor(localDeclaration, null);
            }
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
            ++SourceElementParser.this.nestedMethodIndex;
            if (methodDeclaration.selector != null && methodDeclaration.selector.length > 0) {
                SourceElementParser.this.notifySourceElementRequestor(methodDeclaration);
            }
            return false;
        }

        public boolean visit(Assignment assignment, BlockScope scope) {
            boolean keepVisiting = true;
            IExpression righHandSide = assignment.getExpression();
            if (righHandSide instanceof IFunctionExpression) {
                IExpression leftHandSide = assignment.getLeftHandSide();
                char[] selector = Util.getTypeName(leftHandSide);
                MethodDeclaration methodDecl = ((IFunctionExpression)righHandSide).getMethodDeclaration();
                if (selector != null && methodDecl.isConstructor()) {
                    SourceElementParser.this.notifySourceElementRequestor(methodDecl, selector);
                }
            }
            return keepVisiting;
        }

        public void endVisit(MethodDeclaration methodDeclaration, Scope scope) {
            --SourceElementParser.this.nestedMethodIndex;
        }
    };

    public SourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals) {
        this(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, true);
    }

    public SourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        super(new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, problemFactory), optimizeStringLiterals);
        this.problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, problemFactory){

            public void record(CategorizedProblem problem, CompilationResult unitResult, ReferenceContext context) {
                unitResult.record(problem, context);
                SourceElementParser.this.requestor.acceptProblem(problem);
            }
        };
        this.requestor = requestor;
        this.typeNames = new char[4][];
        this.superTypeNames = new char[4][];
        this.nestedTypeIndex = 0;
        this.options = options;
        if (reportLocalDeclarations) {
            this.localDeclarationVisitor = new LocalDeclarationVisitor();
        }
        this.useSourceJavadocParser = useSourceJavadocParser;
        if (useSourceJavadocParser) {
            this.javadocParser = new SourceJavadocParser(this);
        }
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
        this.notifiedTypes.clear();
    }

    private void acceptJavadocTypeReference(Expression expression) {
        if (expression instanceof JavadocSingleTypeReference) {
            JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)expression;
            this.requestor.acceptTypeReference(singleRef.token, singleRef.sourceStart);
        } else if (expression instanceof JavadocQualifiedTypeReference) {
            JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)expression;
            this.requestor.acceptTypeReference(qualifiedRef.tokens, qualifiedRef.sourceStart, qualifiedRef.sourceEnd);
        }
    }

    public void addUnknownRef(NameReference nameRef) {
        if (nameRef instanceof SingleNameReference) {
            this.requestor.acceptUnknownReference(((SingleNameReference)nameRef).token, nameRef.sourceStart);
        } else {
            this.requestor.acceptUnknownReference(((QualifiedNameReference)nameRef).tokens, nameRef.sourceStart, nameRef.sourceEnd);
        }
    }

    public void checkComment() {
        if (!(this.diet && this.dietInt == 0 || this.scanner.commentPtr < 0 || this.expressionPtr >= 0 && this.expressionStack[this.expressionPtr] instanceof ObjectLiteral)) {
            this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        }
        int lastComment = this.scanner.commentPtr;
        if (this.modifiersSourceStart >= 0) {
            while (lastComment >= 0 && Math.abs(this.scanner.commentStarts[lastComment]) > this.modifiersSourceStart) {
                --lastComment;
            }
        }
        if (lastComment >= 0) {
            this.modifiersSourceStart = Math.abs(this.scanner.commentStarts[0]);
            while (lastComment >= 0 && this.scanner.commentStops[lastComment] < 0) {
                --lastComment;
            }
            if (lastComment >= 0 && this.javadocParser != null) {
                int commentEnd = this.scanner.commentStops[lastComment] - 1;
                boolean bl = this.javadocParser.reportProblems = this.currentElement == null || commentEnd > this.lastJavadocEnd;
                if (this.javadocParser.checkDeprecation(lastComment)) {
                    this.checkAndSetModifiers(0x100000);
                }
                this.javadoc = this.javadocParser.docComment;
                if (this.currentElement == null) {
                    this.lastJavadocEnd = commentEnd;
                }
            }
        }
        if (this.reportReferenceInfo && this.javadocParser.checkDocComment && this.javadoc != null) {
            Expression[] references;
            TypeReference[] thrownExceptions = this.javadoc.exceptionReferences;
            if (thrownExceptions != null) {
                int i = 0;
                int max = thrownExceptions.length;
                while (i < max) {
                    TypeReference typeRef = thrownExceptions[i];
                    if (typeRef instanceof JavadocSingleTypeReference) {
                        JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                        this.requestor.acceptTypeReference(singleRef.token, singleRef.sourceStart);
                    } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                        JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                        this.requestor.acceptTypeReference(qualifiedRef.tokens, qualifiedRef.sourceStart, qualifiedRef.sourceEnd);
                    }
                    ++i;
                }
            }
            if ((references = this.javadoc.seeReferences) != null) {
                int i = 0;
                int max = references.length;
                while (i < max) {
                    int argCount;
                    Expression reference = references[i];
                    this.acceptJavadocTypeReference(reference);
                    if (reference instanceof JavadocFieldReference) {
                        JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
                        this.requestor.acceptFieldReference(fieldRef.token, fieldRef.sourceStart);
                        if (fieldRef.receiver != null && !fieldRef.receiver.isThis()) {
                            this.acceptJavadocTypeReference(fieldRef.receiver);
                        }
                    } else if (reference instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)reference;
                        argCount = messageSend.arguments == null ? 0 : messageSend.arguments.length;
                        this.requestor.acceptMethodReference(messageSend.selector, argCount, messageSend.sourceStart);
                        this.requestor.acceptConstructorReference(messageSend.selector, argCount, messageSend.sourceStart);
                        if (messageSend.receiver != null && !messageSend.receiver.isThis()) {
                            this.acceptJavadocTypeReference(messageSend.receiver);
                        }
                    } else if (reference instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression constructor = (JavadocAllocationExpression)reference;
                        int n = argCount = constructor.arguments == null ? 0 : constructor.arguments.length;
                        if (constructor.type != null) {
                            char[][] compoundName = constructor.type.getTypeName();
                            this.requestor.acceptConstructorReference(compoundName[compoundName.length - 1], argCount, constructor.sourceStart);
                            if (!constructor.type.isThis()) {
                                this.acceptJavadocTypeReference(constructor.type);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void classInstanceCreation(boolean alwaysQualified, boolean isShort) {
        boolean previousFlag = this.reportReferenceInfo;
        this.reportReferenceInfo = false;
        super.classInstanceCreation(alwaysQualified, isShort);
        this.reportReferenceInfo = previousFlag;
        if (this.reportReferenceInfo) {
            AllocationExpression alloc = (AllocationExpression)this.expressionStack[this.expressionPtr];
            char[] name = new char[]{};
            if (alloc.member != null) {
                name = Util.getTypeName(alloc.member);
            } else if (alloc.type != null) {
                name = CharOperation.concatWith(alloc.type.getTypeName(), '.');
            }
            if (name != null && name.length > 0) {
                this.requestor.acceptConstructorReference(name, alloc.arguments == null ? 0 : alloc.arguments.length, alloc.sourceStart);
            }
        }
    }

    protected void consumeExitVariableWithInitialization() {
        super.consumeExitVariableWithInitialization();
        if ((this.currentToken == 27 || this.currentToken == 26) && this.astStack[this.astPtr] instanceof FieldDeclaration) {
            this.sourceEnds.put(this.astStack[this.astPtr], this.scanner.currentPosition - 1);
            this.rememberCategories();
        }
    }

    protected void consumeExitVariableWithoutInitialization() {
        super.consumeExitVariableWithoutInitialization();
        if ((this.currentToken == 27 || this.currentToken == 26) && this.astStack[this.astPtr] instanceof FieldDeclaration) {
            this.sourceEnds.put(this.astStack[this.astPtr], this.scanner.currentPosition - 1);
            this.rememberCategories();
        }
    }

    protected void consumeCallExpressionWithSimpleName() {
        super.consumeCallExpressionWithSimpleName();
        FieldReference fr = (FieldReference)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptFieldReference(fr.token, fr.sourceStart);
        }
    }

    protected void consumeMemberExpressionWithSimpleName() {
        super.consumeMemberExpressionWithSimpleName();
        FieldReference fr = (FieldReference)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptFieldReference(fr.token, fr.sourceStart);
        }
    }

    protected void consumeFormalParameter(boolean isVarArgs) {
        super.consumeFormalParameter(isVarArgs);
        this.flushCommentsDefinedPriorTo(this.scanner.currentPosition);
    }

    protected void consumeMethodHeaderName(boolean isAnonymousMethod) {
        long selectorSourcePositions = isAnonymousMethod ? (long)this.lParenPos : this.identifierPositionStack[this.identifierPtr];
        int selectorSourceEnd = (int)selectorSourcePositions;
        int currentAstPtr = this.astPtr;
        super.consumeMethodHeaderName(isAnonymousMethod);
        if (this.astPtr > currentAstPtr) {
            this.sourceEnds.put(this.astStack[this.astPtr], selectorSourceEnd);
            this.rememberCategories();
        }
    }

    protected void consumeCallExpressionWithArguments() {
        super.consumeCallExpressionWithArguments();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    public MethodDeclaration convertToMethodDeclaration(ConstructorDeclaration c, CompilationResult compilationResult) {
        char[][] categories;
        MethodDeclaration methodDeclaration = super.convertToMethodDeclaration(c, compilationResult);
        int selectorSourceEnd = this.sourceEnds.removeKey(c);
        if (selectorSourceEnd != -1) {
            this.sourceEnds.put(methodDeclaration, selectorSourceEnd);
        }
        if ((categories = (char[][])this.nodesToCategories.remove(c)) != null) {
            this.nodesToCategories.put(methodDeclaration, categories);
        }
        return methodDeclaration;
    }

    protected CompilationUnitDeclaration endParse(int act) {
        if (this.compilationUnit != null) {
            CompilationUnitDeclaration result = super.endParse(act);
            return result;
        }
        return null;
    }

    public TypeReference getTypeReference(int dim) {
        int numberOfIdentifiers;
        int length;
        if ((length = this.identifierLengthStack[this.identifierLengthPtr--]) < 0) {
            TypeReference ref = TypeReference.baseTypeReference(-length, dim);
            ref.sourceStart = this.intStack[this.intPtr--];
            if (dim == 0) {
                ref.sourceEnd = this.intStack[this.intPtr--];
            } else {
                --this.intPtr;
                ref.sourceEnd = this.endPosition;
            }
            if (this.reportReferenceInfo) {
                this.requestor.acceptTypeReference(ref.getTypeName(), ref.sourceStart, ref.sourceEnd);
            }
            return ref;
        }
        if (length != (numberOfIdentifiers = this.genericsIdentifiersLengthStack[this.genericsIdentifiersLengthPtr--]) || this.genericsLengthStack[this.genericsLengthPtr] != 0) {
            TypeReference ref = null;
            return ref;
        }
        if (length == 1) {
            --this.genericsLengthPtr;
            if (dim == 0) {
                SingleTypeReference ref = new SingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr--]);
                if (this.reportReferenceInfo) {
                    this.requestor.acceptTypeReference(ref.token, ref.sourceStart);
                }
                return ref;
            }
            ArrayTypeReference ref = new ArrayTypeReference(this.identifierStack[this.identifierPtr], dim, this.identifierPositionStack[this.identifierPtr--]);
            ref.sourceEnd = this.endPosition;
            if (this.reportReferenceInfo) {
                this.requestor.acceptTypeReference(ref.token, ref.sourceStart);
            }
            return ref;
        }
        --this.genericsLengthPtr;
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        long[] positions = new long[length];
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        if (dim == 0) {
            QualifiedTypeReference ref = new QualifiedTypeReference(tokens, positions);
            if (this.reportReferenceInfo) {
                this.requestor.acceptTypeReference(ref.tokens, ref.sourceStart, ref.sourceEnd);
            }
            return ref;
        }
        ArrayQualifiedTypeReference ref = new ArrayQualifiedTypeReference(tokens, dim, positions);
        ref.sourceEnd = this.endPosition;
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(ref.tokens, ref.sourceStart, ref.sourceEnd);
        }
        return ref;
    }

    public NameReference getUnspecifiedReference() {
        int length;
        if ((length = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            SingleNameReference ref = this.newSingleNameReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr--]);
            if (this.reportReferenceInfo) {
                this.addUnknownRef(ref);
            }
            return ref;
        }
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        long[] positions = new long[length];
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        QualifiedNameReference ref = this.newQualifiedNameReference(tokens, positions, (int)(this.identifierPositionStack[this.identifierPtr + 1] >> 32), (int)this.identifierPositionStack[this.identifierPtr + length]);
        if (this.reportReferenceInfo) {
            this.addUnknownRef(ref);
        }
        return ref;
    }

    public NameReference getUnspecifiedReferenceOptimized() {
        int length;
        if ((length = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            SingleNameReference ref = this.newSingleNameReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr--]);
            ref.bits &= 0xFFFFFFF0;
            ref.bits |= 3;
            if (this.reportReferenceInfo) {
                this.addUnknownRef(ref);
            }
            return ref;
        }
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        long[] positions = new long[length];
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        QualifiedNameReference ref = this.newQualifiedNameReference(tokens, positions, (int)(this.identifierPositionStack[this.identifierPtr + 1] >> 32), (int)this.identifierPositionStack[this.identifierPtr + length]);
        ref.bits &= 0xFFFFFFF0;
        ref.bits |= 3;
        if (this.reportReferenceInfo) {
            this.addUnknownRef(ref);
        }
        return ref;
    }

    protected ImportReference newImportReference(char[][] tokens, long[] positions, boolean onDemand) {
        return new ImportReference(tokens, positions, onDemand);
    }

    protected QualifiedNameReference newQualifiedNameReference(char[][] tokens, long[] positions, int sourceStart, int sourceEnd) {
        return new QualifiedNameReference(tokens, positions, sourceStart, sourceEnd);
    }

    protected SingleNameReference newSingleNameReference(char[] source, long positions) {
        return new SingleNameReference(source, positions);
    }

    public void notifySourceElementRequestor(CompilationUnitDeclaration parsedUnit) {
        boolean isInRange;
        if (parsedUnit == null) {
            if (this.astStack[0] instanceof AbstractMethodDeclaration) {
                this.notifySourceElementRequestor((AbstractMethodDeclaration)this.astStack[0]);
                return;
            }
            return;
        }
        this.inferTypes(parsedUnit, this.options);
        boolean bl = isInRange = this.scanner.initialPosition <= parsedUnit.sourceStart && this.scanner.eofPosition >= parsedUnit.sourceEnd;
        if (this.sourceType == null && isInRange) {
            this.requestor.enterCompilationUnit();
        }
        if (parsedUnit.statements != null) {
            int i = 0;
            while (i < parsedUnit.statements.length) {
                parsedUnit.statements[i].traverse(this.contextDeclarationNotifier, parsedUnit.scope);
                ++i;
            }
        }
        int inx = 0;
        while (inx < parsedUnit.numberInferredTypes) {
            InferredType type = parsedUnit.inferredTypes[inx];
            this.notifySourceElementRequestor(type);
            ++inx;
        }
        if (this.sourceType == null && isInRange) {
            this.requestor.exitCompilationUnit(parsedUnit.sourceEnd);
        }
    }

    public void notifySourceElementRequestor(InferredType type) {
        if (!type.isDefinition || type.isEmptyGlobal()) {
            return;
        }
        if (type.isAnonymous && !type.isNamed() && !type.isObjectLiteral) {
            return;
        }
        if (this.notifiedTypes.containsKey(type.getName())) {
            return;
        }
        this.notifiedTypes.put(type.getName(), null);
        ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
        typeInfo.declarationStart = type.sourceStart;
        typeInfo.modifiers = 0;
        typeInfo.name = type.getName();
        typeInfo.nameSourceStart = type.getNameStart();
        typeInfo.nameSourceEnd = type.isObjectLiteral ? type.sourceEnd : typeInfo.nameSourceStart + typeInfo.name.length - 1;
        typeInfo.superclass = type.getSuperClassName();
        typeInfo.secondary = false;
        typeInfo.anonymousMember = type.isAnonymous;
        this.requestor.enterType(typeInfo);
        int attributeInx = 0;
        while (attributeInx < type.numberAttributes) {
            InferredAttribute field = type.attributes[attributeInx];
            ISourceElementRequestor.FieldInfo fieldInfo = new ISourceElementRequestor.FieldInfo();
            fieldInfo.declarationStart = field.sourceStart();
            fieldInfo.name = field.name;
            fieldInfo.modifiers = field.modifiers;
            if (field.isStatic) {
                fieldInfo.modifiers |= 8;
            }
            fieldInfo.nameSourceStart = field.nameStart;
            fieldInfo.nameSourceEnd = field.nameStart + field.name.length - 1;
            fieldInfo.type = field.type != null ? field.type.getName() : null;
            this.requestor.enterField(fieldInfo);
            if (field.type != null && field.type.isAnonymous && !field.type.isNamed()) {
                this.notifySourceElementRequestor(field.type);
            }
            int initializationStart = field.initializationStart;
            this.requestor.exitField(initializationStart, field.sourceEnd(), field.sourceEnd());
            ++attributeInx;
        }
        if (type.methods != null) {
            Iterator iterator = type.methods.iterator();
            while (iterator.hasNext()) {
                InferredMethod method = (InferredMethod)iterator.next();
                ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
                methodInfo.isConstructor = method.isConstructor;
                MethodDeclaration methodDeclaration = (MethodDeclaration)method.getFunctionDeclaration();
                char[][] argumentTypes = null;
                char[][] argumentNames = null;
                Argument[] arguments = methodDeclaration.arguments;
                if (arguments != null) {
                    int argumentLength = arguments.length;
                    argumentTypes = new char[argumentLength][];
                    argumentNames = new char[argumentLength][];
                    int i = 0;
                    while (i < argumentLength) {
                        if (arguments[i].type != null) {
                            argumentTypes[i] = CharOperation.concatWith(arguments[i].type.getTypeName(), '.');
                        } else if (arguments[i].inferredType != null) {
                            argumentTypes[i] = arguments[i].inferredType.getName();
                        }
                        argumentNames[i] = arguments[i].name;
                        ++i;
                    }
                }
                methodInfo.declarationStart = methodDeclaration.declarationSourceStart;
                methodInfo.modifiers = methodDeclaration.modifiers;
                if (method.isStatic) {
                    methodInfo.modifiers |= 8;
                }
                methodInfo.returnType = methodDeclaration.inferredType == null ? null : methodDeclaration.inferredType.getName();
                methodInfo.name = method.name;
                methodInfo.nameSourceStart = method.nameStart;
                methodInfo.nameSourceEnd = method.nameStart + method.name.length - 1;
                methodInfo.parameterTypes = argumentTypes;
                methodInfo.parameterNames = argumentNames;
                methodInfo.categories = (char[][])this.nodesToCategories.get(methodDeclaration);
                if (methodInfo.isConstructor) {
                    this.requestor.enterConstructor(methodInfo);
                } else {
                    this.requestor.enterMethod(methodInfo);
                }
                this.visitIfNeeded((MethodDeclaration)method.getFunctionDeclaration());
                this.requestor.exitMethod(methodDeclaration.declarationSourceEnd, -1, -1);
            }
        }
        this.requestor.exitType(type.sourceEnd);
    }

    public void notifySourceElementRequestor(AbstractMethodDeclaration methodDeclaration) {
        this.notifySourceElementRequestor(methodDeclaration, methodDeclaration.selector);
    }

    public void notifySourceElementRequestor(AbstractMethodDeclaration methodDeclaration, char[] selector) {
        int currentModifiers;
        boolean isInRange;
        ++this.nestedMethodIndex;
        boolean bl = isInRange = this.scanner.initialPosition <= methodDeclaration.declarationSourceStart && this.scanner.eofPosition >= methodDeclaration.declarationSourceEnd;
        if (methodDeclaration.isClinit()) {
            this.visitIfNeeded(methodDeclaration);
            --this.nestedMethodIndex;
            return;
        }
        if (methodDeclaration.isDefaultConstructor()) {
            if (this.reportReferenceInfo) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null) {
                    switch (constructorCall.accessMode) {
                        case 3: {
                            this.requestor.acceptConstructorReference(this.typeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                            break;
                        }
                        case 1: {
                            this.requestor.acceptConstructorReference(this.superTypeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                        }
                    }
                }
            }
            --this.nestedMethodIndex;
            return;
        }
        char[][] argumentTypes = null;
        char[][] argumentNames = null;
        boolean isVarArgs = false;
        Argument[] arguments = methodDeclaration.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            argumentTypes = new char[argumentLength][];
            argumentNames = new char[argumentLength][];
            int i = 0;
            while (i < argumentLength) {
                if (arguments[i].type != null) {
                    argumentTypes[i] = CharOperation.concatWith(arguments[i].type.getTypeName(), '.');
                } else if (arguments[i].inferredType != null) {
                    argumentTypes[i] = arguments[i].inferredType.getName();
                }
                argumentNames[i] = arguments[i].name;
                ++i;
            }
            isVarArgs = arguments[argumentLength - 1].isVarArgs();
        }
        int selectorSourceEnd = -1;
        if (methodDeclaration.isConstructor()) {
            selectorSourceEnd = this.sourceEnds.get(methodDeclaration);
            if (isInRange) {
                currentModifiers = methodDeclaration.modifiers;
                if (isVarArgs) {
                    currentModifiers |= 0x80;
                }
                boolean deprecated = (currentModifiers & 0x100000) != 0;
                ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
                methodInfo.isConstructor = true;
                methodInfo.declarationStart = methodDeclaration.declarationSourceStart;
                methodInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
                methodInfo.name = selector;
                methodInfo.nameSourceStart = methodDeclaration.sourceStart;
                methodInfo.nameSourceEnd = selectorSourceEnd;
                methodInfo.parameterTypes = argumentTypes;
                methodInfo.parameterNames = argumentNames;
                methodInfo.categories = (char[][])this.nodesToCategories.get(methodDeclaration);
                this.requestor.enterConstructor(methodInfo);
            }
            if (this.reportReferenceInfo && methodDeclaration instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null) {
                    switch (constructorCall.accessMode) {
                        case 3: {
                            this.requestor.acceptConstructorReference(this.typeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                            break;
                        }
                        case 1: {
                            this.requestor.acceptConstructorReference(this.superTypeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                        }
                    }
                }
            }
            this.visitIfNeeded(methodDeclaration);
            if (isInRange) {
                this.requestor.exitConstructor(methodDeclaration.declarationSourceEnd);
            }
            --this.nestedMethodIndex;
            return;
        }
        selectorSourceEnd = this.sourceEnds.get(methodDeclaration);
        if (isInRange) {
            currentModifiers = methodDeclaration.modifiers;
            if (isVarArgs) {
                currentModifiers |= 0x80;
            }
            boolean deprecated = (currentModifiers & 0x100000) != 0;
            InferredType returnType = methodDeclaration instanceof MethodDeclaration ? ((MethodDeclaration)methodDeclaration).inferredType : null;
            ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
            methodInfo.declarationStart = methodDeclaration.declarationSourceStart;
            methodInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
            methodInfo.returnType = returnType == null ? null : returnType.getName();
            methodInfo.name = selector;
            methodInfo.nameSourceStart = methodDeclaration.sourceStart;
            methodInfo.nameSourceEnd = selectorSourceEnd;
            methodInfo.parameterTypes = argumentTypes;
            methodInfo.parameterNames = argumentNames;
            methodInfo.categories = (char[][])this.nodesToCategories.get(methodDeclaration);
            this.requestor.enterMethod(methodInfo);
        }
        this.visitIfNeeded(methodDeclaration);
        if (isInRange) {
            this.requestor.exitMethod(methodDeclaration.declarationSourceEnd, -1, -1);
        }
        --this.nestedMethodIndex;
    }

    public void notifySourceElementRequestor(AbstractVariableDeclaration fieldDeclaration, TypeDeclaration declaringType) {
        boolean isInRange = this.scanner.initialPosition <= fieldDeclaration.declarationSourceStart && this.scanner.eofPosition >= fieldDeclaration.declarationSourceEnd;
        switch (fieldDeclaration.getKind()) {
            case 1: 
            case 4: {
                int fieldEndPosition = this.sourceEnds.get(fieldDeclaration);
                if (fieldEndPosition == -1) {
                    fieldEndPosition = fieldDeclaration.declarationSourceEnd;
                }
                MethodDeclaration methodDeclaration = null;
                if (isInRange) {
                    boolean deprecated;
                    int currentModifiers = fieldDeclaration.modifiers;
                    boolean bl = deprecated = (currentModifiers & 0x100000) != 0;
                    if (fieldDeclaration.initialization instanceof FunctionExpression) {
                        methodDeclaration = ((FunctionExpression)fieldDeclaration.initialization).methodDeclaration;
                    } else if (fieldDeclaration.initialization instanceof Assignment && ((Assignment)fieldDeclaration.initialization).getExpression() instanceof FunctionExpression) {
                        methodDeclaration = ((FunctionExpression)((Assignment)fieldDeclaration.initialization).getExpression()).methodDeclaration;
                    }
                    if (methodDeclaration != null) {
                        this.notifySourceElementRequestor(methodDeclaration, fieldDeclaration.getName());
                    } else {
                        ISourceElementRequestor.FieldInfo fieldInfo = new ISourceElementRequestor.FieldInfo();
                        fieldInfo.declarationStart = fieldDeclaration.declarationSourceStart;
                        fieldInfo.name = fieldDeclaration.name;
                        fieldInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
                        fieldInfo.type = fieldDeclaration.inferredType != null ? fieldDeclaration.inferredType.getName() : null;
                        fieldInfo.nameSourceStart = fieldDeclaration.sourceStart;
                        fieldInfo.nameSourceEnd = fieldDeclaration.sourceEnd;
                        fieldInfo.categories = (char[][])this.nodesToCategories.get(fieldDeclaration);
                        this.requestor.enterField(fieldInfo);
                        if (fieldDeclaration.inferredType != null && fieldDeclaration.inferredType.isAnonymous) {
                            this.notifySourceElementRequestor(fieldDeclaration.inferredType);
                        }
                    }
                }
                this.visitIfNeeded(fieldDeclaration, declaringType);
                if (!isInRange || methodDeclaration != null) break;
                this.requestor.exitField(fieldDeclaration.initialization == null || fieldDeclaration.initialization instanceof ArrayInitializer || fieldDeclaration.initialization instanceof AllocationExpression || fieldDeclaration.initialization instanceof ArrayAllocationExpression || fieldDeclaration.initialization instanceof Assignment || fieldDeclaration.initialization instanceof ClassLiteralAccess || fieldDeclaration.initialization instanceof MessageSend || fieldDeclaration.initialization instanceof ArrayReference || fieldDeclaration.initialization instanceof ThisReference ? -1 : fieldDeclaration.initialization.sourceStart, fieldEndPosition, fieldDeclaration.declarationSourceEnd);
                break;
            }
            case 2: {
                if (isInRange) {
                    this.requestor.enterInitializer(fieldDeclaration.declarationSourceStart, fieldDeclaration.modifiers);
                }
                this.visitIfNeeded((Initializer)fieldDeclaration);
                if (!isInRange) break;
                this.requestor.exitInitializer(fieldDeclaration.declarationSourceEnd);
            }
        }
    }

    public void notifySourceElementRequestor(ImportReference importReference, boolean isPackage) {
        this.requestor.acceptImport(importReference.declarationSourceStart, importReference.declarationSourceEnd, importReference.tokens, (importReference.bits & 0x20000) != 0);
    }

    public void notifySourceElementRequestor(TypeDeclaration typeDeclaration, boolean notifyTypePresence, TypeDeclaration declaringType) {
        if (CharOperation.equals(TypeConstants.PACKAGE_INFO_NAME, typeDeclaration.name)) {
            return;
        }
        boolean isInRange = this.scanner.initialPosition <= typeDeclaration.declarationSourceStart && this.scanner.eofPosition >= typeDeclaration.declarationSourceEnd;
        FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        TypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int fieldCounter = fields == null ? 0 : fields.length;
        int methodCounter = methods == null ? 0 : methods.length;
        int memberTypeCounter = memberTypes == null ? 0 : memberTypes.length;
        int fieldIndex = 0;
        int methodIndex = 0;
        int memberTypeIndex = 0;
        if (notifyTypePresence) {
            int kind = TypeDeclaration.kind(typeDeclaration.modifiers);
            char[] implicitSuperclassName = TypeConstants.CharArray_JAVA_LANG_OBJECT;
            if (isInRange) {
                int currentModifiers = typeDeclaration.modifiers;
                boolean deprecated = (currentModifiers & 0x100000) != 0;
                TypeReference superclass = typeDeclaration.superclass;
                char[] superclassName = superclass != null ? CharOperation.concatWith(superclass.getTypeName(), '.') : null;
                ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
                typeInfo.declarationStart = typeDeclaration.declarationSourceStart;
                typeInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
                typeInfo.name = typeDeclaration.name;
                typeInfo.nameSourceStart = typeDeclaration.sourceStart;
                typeInfo.nameSourceEnd = this.sourceEnd(typeDeclaration);
                typeInfo.superclass = superclassName;
                typeInfo.categories = (char[][])this.nodesToCategories.get(typeDeclaration);
                typeInfo.secondary = typeDeclaration.isSecondary();
                typeInfo.anonymousMember = typeDeclaration.allocation != null && typeDeclaration.allocation.enclosingInstance != null;
                this.requestor.enterType(typeInfo);
                switch (kind) {
                    case 1: {
                        if (superclassName == null) break;
                        implicitSuperclassName = superclassName;
                    }
                }
            }
            if (this.nestedTypeIndex == this.typeNames.length) {
                char[][] cArrayArray = new char[this.nestedTypeIndex * 2][];
                this.typeNames = cArrayArray;
                System.arraycopy(this.typeNames, 0, cArrayArray, 0, this.nestedTypeIndex);
                char[][] cArrayArray2 = new char[this.nestedTypeIndex * 2][];
                this.superTypeNames = cArrayArray2;
                System.arraycopy(this.superTypeNames, 0, cArrayArray2, 0, this.nestedTypeIndex);
            }
            this.typeNames[this.nestedTypeIndex] = typeDeclaration.name;
            this.superTypeNames[this.nestedTypeIndex++] = implicitSuperclassName;
        }
        while (fieldIndex < fieldCounter || memberTypeIndex < memberTypeCounter || methodIndex < methodCounter) {
            FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldIndex < fieldCounter) {
                nextFieldDeclaration = fields[fieldIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodIndex < methodCounter) {
                nextMethodDeclaration = methods[methodIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (memberTypeIndex < memberTypeCounter) {
                nextMemberDeclaration = memberTypes[memberTypeIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    ++fieldIndex;
                    this.notifySourceElementRequestor(nextFieldDeclaration, typeDeclaration);
                    break;
                }
                case 1: {
                    ++methodIndex;
                    this.notifySourceElementRequestor(nextMethodDeclaration);
                    break;
                }
                case 2: {
                    ++memberTypeIndex;
                    this.notifySourceElementRequestor(nextMemberDeclaration, true, null);
                }
            }
        }
        if (notifyTypePresence) {
            if (isInRange) {
                this.requestor.exitType(typeDeclaration.declarationSourceEnd);
            }
            --this.nestedTypeIndex;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseCompilationUnit(ICompilationUnit unit, int start, int end, boolean fullParse) {
        this.reportReferenceInfo = fullParse;
        boolean old = this.diet;
        try {
            try {
                this.diet = true;
                CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
                CompilationUnitDeclaration parsedUnit = this.parse(unit, compilationUnitResult, start, end);
                if (this.scanner.recordLineSeparator) {
                    this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
                }
                if (this.localDeclarationVisitor != null || fullParse) {
                    this.diet = false;
                    this.getMethodBodies(parsedUnit);
                }
                this.scanner.resetTo(start, end);
                this.notifySourceElementRequestor(parsedUnit);
            }
            catch (AbortCompilation abortCompilation) {}
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.diet = old;
            this.reset();
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.diet = old;
            this.reset();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse) {
        boolean old = this.diet;
        try {
            CompilationUnitDeclaration compilationUnitDeclaration;
            try {
                this.diet = false;
                this.reportReferenceInfo = fullParse;
                CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
                CompilationUnitDeclaration parsedUnit = this.parse(unit, compilationUnitResult);
                if (this.scanner.recordLineSeparator) {
                    this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
                }
                int initialStart = this.scanner.initialPosition;
                int initialEnd = this.scanner.eofPosition;
                if (this.localDeclarationVisitor != null || fullParse) {
                    this.diet = false;
                    this.getMethodBodies(parsedUnit);
                }
                this.scanner.resetTo(initialStart, initialEnd);
                this.notifySourceElementRequestor(parsedUnit);
                compilationUnitDeclaration = parsedUnit;
                Object var8_9 = null;
                this.diet = old;
            }
            catch (AbortCompilation abortCompilation) {}
            this.reset();
            return compilationUnitDeclaration;
            Object var8_11 = null;
            this.diet = old;
            this.reset();
            return null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.diet = old;
            this.reset();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseTypeMemberDeclarations(ISourceType type, ICompilationUnit sourceUnit, int start, int end, boolean needReferenceInfo) {
        boolean old = this.diet;
        CompilationResult compilationUnitResult = new CompilationResult(sourceUnit, 0, 0, this.options.maxProblemsPerUnit);
        try {
            try {
                CompilationUnitDeclaration unit;
                block16: {
                    block15: {
                        this.diet = !needReferenceInfo;
                        this.reportReferenceInfo = needReferenceInfo;
                        unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{type}, 0, this.problemReporter(), compilationUnitResult);
                        if (unit == null || unit.types == null) break block15;
                        if (unit.types.length == 1) break block16;
                    }
                    Object var11_9 = null;
                    if (this.scanner.recordLineSeparator) {
                        this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
                    }
                    this.diet = old;
                    this.reset();
                    return;
                }
                this.sourceType = type;
                try {
                    this.initialize();
                    this.goForClassBodyDeclarations();
                    this.scanner.setSource(sourceUnit.getContents());
                    this.scanner.resetTo(start, end);
                    this.compilationUnit = unit;
                    this.referenceContext = this.compilationUnit;
                    this.pushOnAstStack(unit.types[0]);
                    this.parse();
                    this.notifySourceElementRequestor(unit);
                    Object var9_14 = null;
                    unit = this.compilationUnit;
                    this.compilationUnit = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    unit = this.compilationUnit;
                    this.compilationUnit = null;
                    throw throwable;
                }
            }
            catch (AbortCompilation abortCompilation) {}
            Object var11_11 = null;
            if (this.scanner.recordLineSeparator) {
                this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
            }
            this.diet = old;
            this.reset();
            return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (this.scanner.recordLineSeparator) {
                this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
            }
            this.diet = old;
            this.reset();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseTypeMemberDeclarations(char[] contents, int start, int end) {
        boolean old = this.diet;
        try {
            try {
                this.diet = true;
                this.initialize();
                this.goForClassBodyDeclarations();
                this.scanner.setSource(contents);
                this.scanner.recordLineSeparator = false;
                this.scanner.taskTags = null;
                this.scanner.taskPriorities = null;
                this.scanner.resetTo(start, end);
                this.referenceContext = null;
                this.parse();
                this.notifySourceElementRequestor((CompilationUnitDeclaration)null);
            }
            catch (AbortCompilation abortCompilation) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.diet = old;
            this.reset();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.diet = old;
            this.reset();
            return;
        }
    }

    private void rememberCategories() {
        if (this.useSourceJavadocParser) {
            SourceJavadocParser sourceJavadocParser = (SourceJavadocParser)this.javadocParser;
            char[][] categories = sourceJavadocParser.categories;
            if (categories.length > 0) {
                this.nodesToCategories.put(this.astStack[this.astPtr], categories);
                sourceJavadocParser.categories = CharOperation.NO_CHAR_CHAR;
            }
        }
    }

    private void reset() {
        this.sourceEnds = new HashtableOfObjectToInt();
        this.nodesToCategories = new HashMap();
        this.typeNames = new char[4][];
        this.superTypeNames = new char[4][];
        this.nestedTypeIndex = 0;
    }

    private int sourceEnd(TypeDeclaration typeDeclaration) {
        if ((typeDeclaration.bits & 0x200) != 0) {
            QualifiedAllocationExpression allocation = typeDeclaration.allocation;
            if (allocation.type == null) {
                return typeDeclaration.sourceEnd;
            }
            return allocation.type.sourceEnd;
        }
        return typeDeclaration.sourceEnd;
    }

    private void visitIfNeeded(AbstractMethodDeclaration method) {
        if (this.localDeclarationVisitor != null) {
            if (method instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)method;
                if (constructorDeclaration.constructorCall != null) {
                    constructorDeclaration.constructorCall.traverse(this.localDeclarationVisitor, method.scope);
                }
            }
            if (method.statements != null) {
                int statementsLength = method.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    method.statements[i].traverse(this.contextDeclarationNotifier, method.scope);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void visitIfNeeded(AbstractVariableDeclaration field, TypeDeclaration declaringType) {
        if (this.localDeclarationVisitor == null) return;
        if ((field.bits & 2) == 0) return;
        if (field.initialization == null) return;
        try {
            this.localDeclarationVisitor.pushDeclaringType(declaringType);
            field.initialization.traverse((ASTVisitor)this.localDeclarationVisitor, (BlockScope)null);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.localDeclarationVisitor.popDeclaringType();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.localDeclarationVisitor.popDeclaringType();
            return;
        }
    }

    private void visitIfNeeded(Initializer initializer) {
        if (this.localDeclarationVisitor != null && (initializer.bits & 2) != 0 && initializer.block != null) {
            initializer.block.traverse(this.localDeclarationVisitor, null);
        }
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        ArrayList declaringTypes;

        public void pushDeclaringType(TypeDeclaration declaringType) {
            if (this.declaringTypes == null) {
                this.declaringTypes = new ArrayList();
            }
            this.declaringTypes.add(declaringType);
        }

        public void popDeclaringType() {
            this.declaringTypes.remove(this.declaringTypes.size() - 1);
        }

        public TypeDeclaration peekDeclaringType() {
            if (this.declaringTypes == null) {
                return null;
            }
            int size = this.declaringTypes.size();
            if (size == 0) {
                return null;
            }
            return (TypeDeclaration)this.declaringTypes.get(size - 1);
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope scope) {
            SourceElementParser.this.notifySourceElementRequestor(typeDeclaration, SourceElementParser.this.sourceType == null, this.peekDeclaringType());
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration, ClassScope scope) {
            SourceElementParser.this.notifySourceElementRequestor(typeDeclaration, SourceElementParser.this.sourceType == null, this.peekDeclaringType());
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
            SourceElementParser.this.notifySourceElementRequestor(methodDeclaration);
            return false;
        }
    }
}

