/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryObjectLockSample;
import com.arcway.repository.interFace.data.lock.RepositoryObjectLockType;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;

public class RepositoryObjectLockSample
extends AbstractRepositoryObjectLockSample {
    private final RepositoryObjectLockType lockType;
    private final IRepositoryPropertySetSample objectID;
    private final IRepositoryObjectTypeID objectTypeID;
    private final IRepositoryPropertySetSample snapshotID;

    public RepositoryObjectLockSample(RepositoryObjectLockType lockType, IRepositoryObjectTypeID objectTypeID, IRepositoryPropertySetSample objectID, IRepositoryPropertySetSample snapshotID) {
        this.lockType = lockType;
        this.objectTypeID = objectTypeID;
        this.objectID = objectID;
        this.snapshotID = snapshotID;
    }

    private RepositoryObjectLockSample(IRepositoryObject objectToLock, RepositoryObjectLockType type) throws EXNotReproducibleSnapshot {
        assert (objectToLock != null);
        assert (type != null);
        this.lockType = type;
        IRepositoryObjectType objectType = objectToLock.getObjectType();
        this.objectID = objectToLock.getAttributeSet(objectType.getIDAttributeSetType()).sample();
        this.objectTypeID = objectType.getRepositoryObjectTypeID();
        this.snapshotID = objectToLock.getSnapshotIDOfLastModification(type);
        assert (this.objectID != null && this.objectTypeID != null && this.lockType != null);
    }

    public RepositoryObjectLockType getLockType() {
        return this.lockType;
    }

    public IRepositoryPropertySetSample getObjectID() {
        return this.objectID;
    }

    public IRepositoryObjectTypeID getObjectTypeID() {
        return this.objectTypeID;
    }

    public IRepositoryPropertySetSample getBasedSnapshotID() {
        return this.snapshotID;
    }

    public static AbstractRepositoryObjectLockSample createSharedLock(IRepositoryObject objectToLock) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)objectToLock);
        return new RepositoryObjectLockSample(objectToLock, RepositoryObjectLockType.SHARED);
    }

    public static AbstractRepositoryObjectLockSample createMoveSharedLock(IRepositoryObject objectToLock) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)objectToLock);
        return new RepositoryObjectLockSample(objectToLock, RepositoryObjectLockType.MOVE_SHARED);
    }

    public static AbstractRepositoryObjectLockSample createMoveExclusiveLock(IRepositoryObject objectToLock) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)objectToLock);
        return new RepositoryObjectLockSample(objectToLock, RepositoryObjectLockType.MOVE_EXCLUSIVE);
    }

    public static AbstractRepositoryObjectLockSample createExclusiveLock(IRepositoryObject objectToLock) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)objectToLock);
        return new RepositoryObjectLockSample(objectToLock, RepositoryObjectLockType.EXCLUSIVE);
    }
}

