/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.implementation.filearchive;

import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResourceWithMetaInformation;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFile;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.UserReference;
import java.io.InputStream;

public class FileResourceForFileInFileArchive
implements IStreamResourceWithMetaInformation {
    private static final ILogger logger = Logger.getLogger(FileResourceForFileInFileArchive.class);
    private final IRepositoryFileID fileID;
    private final IRepositoryTypeManagerRO typeManager;

    public FileResourceForFileInFileArchive(IRepositoryFileID fileID, IRepositoryTypeManagerRO typeManager) {
        this.fileID = fileID;
        this.typeManager = typeManager;
    }

    public FileResourceForFileInFileArchive(IRepositoryData fileID, IRepositoryTypeManagerRO typeManager) {
        this(RDTFile.getInstance().dataToFileID(fileID), typeManager);
    }

    public IRepositoryFileID getFileID() {
        return this.fileID;
    }

    public String getName() {
        IRepositoryFile repositoryFile = this.getRepositoryFile();
        if (repositoryFile != null) {
            return repositoryFile.getName();
        }
        return null;
    }

    public String getCreationDate(PresentationContext presentationContext) {
        IRepositoryFile repositoryFile = this.getRepositoryFile();
        if (repositoryFile != null) {
            return presentationContext.convertDateAndTimeWithoutSecondsToString(repositoryFile.getCreationDate(), this.typeManager.getRepositoryInterface().getContentLocale());
        }
        return null;
    }

    public String getCreator() {
        IRepositoryObjectSample creationSnapshotInformation;
        IRepositoryFile repositoryFile = this.getRepositoryFile();
        if (repositoryFile != null && (creationSnapshotInformation = repositoryFile.getCreationSnapshotInformation()) != null) {
            UserReference userReference = this.typeManager.getRepositoryInterface().getUserReferenceFromSnapshot(creationSnapshotInformation);
            return userReference.getRealName();
        }
        return null;
    }

    public InputStream toInputStream() throws JvmExternalResourceInteractionException {
        IRepositoryFile repositoryFile = this.getRepositoryFile();
        if (repositoryFile != null) {
            try {
                return repositoryFile.toInputStream();
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new JvmExternalResourceInteractionException((Throwable)e);
            }
        }
        return null;
    }

    private IRepositoryFile getRepositoryFile() {
        try {
            return this.typeManager.getRepositoryInterface().getFileArchive().getRepositoryFile(this.fileID);
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("Repository file " + this.fileID.toString() + " could not be retrieved from the file archive.", (Throwable)e);
            return null;
        }
    }

    public int hashCode() {
        return this.fileID.toCanonicalString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileResourceForFileInFileArchive)) {
            return false;
        }
        return this.fileID.toCanonicalString().equals(((FileResourceForFileInFileArchive)obj).fileID.toCanonicalString());
    }
}

