/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjobeditors.automatic;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.importexport.imporT.IImportJobEditor;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ContextObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObjectType;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.Collection;

public class AIJEObjectRecogniserByID
implements IImportJobEditor {
    private final boolean forImportedObjects;
    private final boolean forContextObjects;
    private final ISet_<IRepositoryObjectTypeID> objectTypesToBeConsidered;
    private final IRepositoryPropertyTypeID idPropertyType;

    public AIJEObjectRecogniserByID(boolean forImportedObjects, boolean forContextObjects) {
        this.forImportedObjects = forImportedObjects;
        this.forContextObjects = forContextObjects;
        this.objectTypesToBeConsidered = null;
        this.idPropertyType = null;
    }

    public AIJEObjectRecogniserByID(Collection<IRepositoryObjectTypeID> objectTypesToBeConsidered, boolean forImportedObjects, boolean forContextObjects) {
        this.forImportedObjects = forImportedObjects;
        this.forContextObjects = forContextObjects;
        this.objectTypesToBeConsidered = new HashSet_(objectTypesToBeConsidered, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        this.idPropertyType = null;
    }

    public AIJEObjectRecogniserByID(IRepositoryObjectTypeID objectTypeToBeConsidered, IRepositoryPropertyTypeID idPropertyType, boolean forImportedObjects, boolean forContextObjects) {
        this.forImportedObjects = forImportedObjects;
        this.forContextObjects = forContextObjects;
        this.objectTypesToBeConsidered = new HashSet_((Object)objectTypeToBeConsidered, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        this.idPropertyType = idPropertyType;
    }

    @Override
    public IImportJobEditor.ResultCode editImportJob(IImportJob importJob, IRepositorySnapshotRO snapshot, boolean executionMessagesOccurred) throws EXNotReproducibleSnapshot {
        if (this.forImportedObjects) {
            this.handleObjectTypes(importJob.getImportedObjectTypes(), snapshot);
        }
        if (this.forContextObjects) {
            this.handleObjectTypes(importJob.getContextObjectTypes(), snapshot);
        }
        return IImportJobEditor.ResultCode.COMPLETED_NOMORECALLS;
    }

    private void handleObjectTypes(Collection<? extends IObjectType> objectTypes, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        for (IObjectType iObjectType : objectTypes) {
            if (this.objectTypesToBeConsidered != null && RepositoryObjectTypes.findMostSpecificSuperObjectType(iObjectType.getObjectType(), this.objectTypesToBeConsidered) == null) continue;
            this.handleObjectType(iObjectType, snapshot);
        }
    }

    private void handleObjectType(IObjectType objectType, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IRepositoryObjectType objectTypeDefinition = objectType.getObjectType();
        IRepositoryPropertyTypeID effectiveIdPropertyTypeID = this.idPropertyType;
        if (effectiveIdPropertyTypeID != null) {
            if (objectTypeDefinition.findAttributeSetType(effectiveIdPropertyTypeID) == null) {
                effectiveIdPropertyTypeID = null;
            }
        } else {
            effectiveIdPropertyTypeID = RepositoryObjectTypes.findIDPropertyTypeID(objectTypeDefinition);
        }
        if (effectiveIdPropertyTypeID != null) {
            IMap_<IRepositoryData, IRepositoryObjectReference> map_id_object = null;
            if (this.idPropertyType != null) {
                map_id_object = AIJEObjectRecogniserByID.createIDToObjectMapping(objectTypeDefinition, effectiveIdPropertyTypeID, snapshot);
            }
            IRepositoryAttributeSetType attributeSetType = objectTypeDefinition.findAttributeSetType(effectiveIdPropertyTypeID);
            IRepositoryPropertyType effectiveIdPropertyType = attributeSetType.findPropertyType(effectiveIdPropertyTypeID);
            for (IObject iObject : objectType.getObjects()) {
                IRepositoryObjectReference matchingObject;
                IRepositoryData idPropertyValue = AIJEObjectRecogniserByID.getIDPropertyValue(iObject, effectiveIdPropertyType);
                if (idPropertyValue == null || (matchingObject = AIJEObjectRecogniserByID.getMatchingObjectForIDValue(idPropertyValue, effectiveIdPropertyType, objectTypeDefinition.getRepositoryObjectTypeID(), map_id_object, snapshot)) == null) continue;
                iObject.setMatchingObject(matchingObject);
            }
        }
    }

    private static IRepositoryData getIDPropertyValue(IObject object, IRepositoryPropertyType effectiveIdPropertyType) {
        if (object instanceof ImportedObject) {
            return ((ImportedObject)object).getProperty(effectiveIdPropertyType.getRepositoryPropertyTypeID()).getImportedValue();
        }
        if (object instanceof ContextObject) {
            IRepositoryPropertySetSample propertySetSample = ((ContextObject)object).getObjectSample().getPropertySetSample();
            return propertySetSample.getPropertySample(effectiveIdPropertyType.getRepositoryPropertyTypeID()).getValue();
        }
        return null;
    }

    private static IRepositoryObjectReference getMatchingObjectForIDValue(IRepositoryData idPropertyValue, IRepositoryPropertyType idPropertyType_, IRepositoryObjectTypeID requiredObjectType, IMap_<IRepositoryData, IRepositoryObjectReference> map_id_object, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        if (map_id_object == null) {
            IRepositoryObject matchingObject = snapshot.findObjectByIDProperty(idPropertyType_, idPropertyValue);
            if (matchingObject != null && IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)requiredObjectType, (Object)matchingObject.getObjectType().getRepositoryObjectTypeID())) {
                return new RepositoryObjectReference(matchingObject);
            }
            return null;
        }
        return (IRepositoryObjectReference)map_id_object.getByKey((Object)idPropertyValue);
    }

    private static IMap_<IRepositoryData, IRepositoryObjectReference> createIDToObjectMapping(IRepositoryObjectType objectType, IRepositoryPropertyTypeID idPropertyTypeID, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IRepositoryAttributeSetType attributeSetType = objectType.findAttributeSetType(idPropertyTypeID);
        IRepositoryPropertyType propertyType = attributeSetType.findPropertyType(idPropertyTypeID);
        final IRepositoryDataType propertyDataType = propertyType.getDataType();
        HashMap_ map_id_object = new HashMap_((IHasher_)new IHasher_<IRepositoryData>(){

            public boolean isEqual(IRepositoryData object1, IRepositoryData object2) {
                return propertyDataType.getEqualComparator().isEqual(object1, object2);
            }

            public int getHashCode(IRepositoryData object) {
                return propertyDataType.getHasher().getHashCode(object);
            }
        });
        IRepositoryIterator_IRepositoryObject objectIterator = snapshot.findAllObjectOfType(objectType);
        while (objectIterator.hasNext()) {
            IRepositoryObject object = objectIterator.nextIRepositoryObject();
            IRepositoryAttributeSet attributeSet = object.getAttributeSet(attributeSetType);
            IRepositoryProperty property = attributeSet.getProperty(propertyType);
            map_id_object.put((Object)property.getValue(), (Object)new RepositoryObjectReference(object));
        }
        return map_id_object;
    }
}

