/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.export;

import com.arcway.lib.file.tmp.ITempDirectoryProvider;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.IRepositoryIterator_ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFile;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.filters.IRepositoryObjectFilter;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.importexport.RepositorySnippetForExport;
import com.arcway.repository.interFace.importexport.export.ExportJob;
import com.arcway.repository.interFace.importexport.export.IExportAgent;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IAbstractRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExportAgent
implements IExportAgent {
    private final IRepositoryInterfaceRO repositoryInterface;
    private final ITempDirectoryProvider tempDirectoryProvider;

    public ExportAgent(IRepositoryInterfaceRO repositoryInterface, ITempDirectoryProvider tempDirectoryProvider) {
        this.repositoryInterface = repositoryInterface;
        this.tempDirectoryProvider = tempDirectoryProvider;
    }

    @Override
    public IRepositorySnippetRO compileRepositorySnippet(final List<IRepositoryObjectReference> rootObjects, Collection<IRepositoryObjectTypeID> objectTypesToBeExported, Collection<IRepositoryRelationTypeID> crossRelationTypesToImplicitObjects, Collection<IRepositoryRelationTypeID> crossRelationTypesToContextObjects, Collection<Tuple<IRepositoryObjectTypeID, IRepositoryPropertyTypeID>> occurrenceTypesOfImplicitObjects, Collection<Tuple<IRepositoryObjectTypeID, IRepositoryPropertyTypeID>> occurrenceTypesOfContextObjects, IRepositoryObjectFilter filter) throws ImportExportException {
        final IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        final ExportJob job = new ExportJob();
        job.objectTypesToBeExported.addAll(objectTypesToBeExported);
        ExportAgent.calculateObjectTypeToRelationTypeMappingForCrossRelations(crossRelationTypesToImplicitObjects, job.map_objectType_crossRelationTypesToImplicitObjects, typeManager);
        ExportAgent.calculateObjectTypeToRelationTypeMappingForCrossRelations(crossRelationTypesToContextObjects, job.map_objectType_crossRelationTypesToContextObjects, typeManager);
        ExportAgent.calculateObjectTypeToRelationTypeMappingForOccurrenceRelations(occurrenceTypesOfImplicitObjects, job.map_objectType_occurrenceRelationTypesToImplicitObjects, typeManager);
        ExportAgent.calculateObjectTypeToRelationTypeMappingForOccurrenceRelations(occurrenceTypesOfContextObjects, job.map_objectType_occurrenceRelationTypesToContextObjects, typeManager);
        job.filter = filter;
        job.temporaryFileProviderForFileProperties = this.tempDirectoryProvider.createTemporaryDirectory();
        if (job.temporaryFileProviderForFileProperties == null) {
            throw new ImportExportException();
        }
        final RepositorySnippetForExport snippet = new RepositorySnippetForExport(typeManager, job.temporaryFileProviderForFileProperties);
        try {
            final ImportExportException[] importExportException = new ImportExportException[1];
            RepositoryInterfaces.doWithCurrentSnapshot(this.repositoryInterface, new IWithCurrentSnapshotProcessor(){

                @Override
                public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                    for (IRepositoryObjectReference rootObject : rootObjects) {
                        IRepositoryObjectTypeID objectTypeID = rootObject.getObjectTypeID();
                        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
                        IRepositoryObject object = snapshot.findRepositoryObject(objectType, rootObject.getObjectID());
                        try {
                            ExportAgent.storeObjectTreeInSnippet(object, true, true, job, snippet, ExportAgent.this.repositoryInterface, snapshot);
                        }
                        catch (ImportExportException iEE) {
                            importExportException[0] = iEE;
                        }
                    }
                }
            });
            if (importExportException[0] != null) {
                throw importExportException[0];
            }
        }
        catch (IllegalStateException isE) {
            throw new ImportExportException(isE);
        }
        return snippet;
    }

    private static final void storeObjectTreeInSnippet(IRepositoryObject object, boolean isExplicit, boolean isRoot, ExportJob job, RepositorySnippetForExport snippet, IRepositoryInterfaceRO repositoryInterface, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, ImportExportException {
        boolean isAlreadyContained;
        RepositoryObjectSampleWithParentObjectReference objectWithParentReference = ExportAgent.getObjectSampleWithParentReference(object, isRoot);
        boolean isAlreadyContainedAsExplicit = snippet.containsExplicitObject(objectWithParentReference.getObjectSample());
        boolean bl = isAlreadyContained = isAlreadyContainedAsExplicit || snippet.containsImplicitObject(objectWithParentReference.getObjectSample());
        if (isAlreadyContainedAsExplicit) {
            if (isExplicit && !isRoot) {
                snippet.addExplicitObject(objectWithParentReference);
            }
            return;
        }
        if (isAlreadyContained && !isExplicit) {
            if (!isRoot) {
                snippet.addImplicitObject(objectWithParentReference);
            }
            return;
        }
        IRepositoryObjectType objectType = object.getObjectType();
        if (RepositoryObjectTypes.findMostSpecificSuperObjectType(objectType, job.objectTypesToBeExported) != null) {
            IRepositoryAttributeSet attributeSet;
            boolean isAcceptedByFilter;
            boolean bl2 = isAcceptedByFilter = job.filter == null || job.filter.accepts(object);
            if (!isAlreadyContained && !job.map_objectType_fileProperties.containsKey((Object)objectType.getRepositoryObjectTypeID())) {
                ExportAgent.findFileCustomPropertiesAndChildrenContributions(objectType, job);
            }
            if (isAcceptedByFilter) {
                if (isExplicit) {
                    snippet.addExplicitObject(objectWithParentReference);
                } else {
                    snippet.addImplicitObject(objectWithParentReference);
                }
                if (!isAlreadyContained) {
                    ExportAgent.storeCategoryInSnippet(object, snippet);
                    for (ExportJob.AttributeSetTypeAndPropertyType filePropertyWrapper : (List)job.map_objectType_fileProperties.getByKey((Object)objectType.getRepositoryObjectTypeID())) {
                        attributeSet = object.getAttributeSet(filePropertyWrapper.attributeSetType);
                        IRepositoryProperty property = attributeSet.getProperty(filePropertyWrapper.propertyType);
                        IRepositoryData propertyValue = property.getValue();
                        RDTFile fileDataType = RDTFile.getInstance();
                        IRepositoryFileID fileID = fileDataType.dataToFileID(propertyValue);
                        IRepositoryFile file = fileDataType.dataToRepositoryFile(propertyValue, repositoryInterface.getFileArchive());
                        if (file == null) continue;
                        snippet.addFile(fileID, file);
                    }
                    ExportAgent.storeRelationsAndRelatedObjectsInSnippet(object, job.map_objectType_crossRelationTypesToImplicitObjects, job.map_objectType_occurrenceRelationTypesToImplicitObjects, job, true, snippet, repositoryInterface, snapshot);
                    ExportAgent.storeRelationsAndRelatedObjectsInSnippet(object, job.map_objectType_crossRelationTypesToContextObjects, job.map_objectType_occurrenceRelationTypesToContextObjects, job, false, snippet, repositoryInterface, snapshot);
                }
            }
            for (ExportJob.AttributeSetTypeAndChildrenRelation childrenRelationWrapper : (List)job.map_objectType_childrenContributions.getByKey((Object)objectType.getRepositoryObjectTypeID())) {
                attributeSet = object.getAttributeSet(childrenRelationWrapper.attributeSetType);
                IRepositoryIterator_IRepositoryObject childObjectIterator = attributeSet.childObjectIterator(childrenRelationWrapper.childObjectType);
                while (childObjectIterator.hasNext()) {
                    IRepositoryObject childObject = childObjectIterator.nextIRepositoryObject();
                    ExportAgent.storeObjectTreeInSnippet(childObject, isExplicit, !isAcceptedByFilter, job, snippet, repositoryInterface, snapshot);
                }
            }
        }
    }

    private static RepositoryObjectSampleWithParentObjectReference getObjectSampleWithParentReference(IRepositoryObject object, boolean isRoot) throws EXNotReproducibleSnapshot {
        RepositoryObjectSampleWithParentObjectReference objectWithParentReference = null;
        objectWithParentReference = isRoot ? new RepositoryObjectSampleWithParentObjectReference(object.sample(), null) : RepositoryObjectSampleWithParentObjectReference.sampleObjectWithParentReference(object);
        return objectWithParentReference;
    }

    private static void storeRelationsAndRelatedObjectsInSnippet(IRepositoryObject object, IMap_<IRepositoryObjectTypeID, ? extends ISet_<ExportJob.CrossRelationTypeAndContributionTypes>> mappedCrossRelationTypes, IMap_<IRepositoryObjectTypeID, ? extends ISet_<ExportJob.OccurrenceRelationTypeAndContributionTypes>> mappedOccurrenceRelationTypes, ExportJob job, boolean asImplicitObjects, RepositorySnippetForExport snippet, IRepositoryInterfaceRO repositoryInterface, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, ImportExportException {
        IRepositoryObjectType ancestorType = object.getObjectType();
        while (ancestorType != null) {
            ISet_ occurrenceRelationTypeSet;
            ISet_ crossRelationTypeSet = (ISet_)mappedCrossRelationTypes.getByKey((Object)ancestorType.getRepositoryObjectTypeID());
            if (crossRelationTypeSet != null) {
                for (ExportJob.CrossRelationTypeAndContributionTypes relationTypeAndContributions : crossRelationTypeSet) {
                    IRepositoryAttributeSet attributeSet = object.getAttributeSet(relationTypeAndContributions.startContributionType.getRelatedAttributeSetType());
                    IRepositoryIterator_ICrossLinkRepositoryRelationContribution relationContributionIterator = attributeSet.relationContributionIterator(relationTypeAndContributions.startContributionType);
                    while (relationContributionIterator.hasNext()) {
                        ICrossLinkRepositoryRelationContribution relationContribution = relationContributionIterator.nextIRepositoryRelationContribution();
                        ICrossLinkRepositoryRelation relation = relationContribution.getRelation();
                        boolean allObjectsAcceptedByFilter = true;
                        ArrayList<IRepositoryObject> relatedObjects = new ArrayList<IRepositoryObject>();
                        for (ICrossLinkRepositoryRelationContributionType targetContributionType : relationTypeAndContributions.targetContributionTypes) {
                            IRepositoryObject targetObject = relation.getRelationContribution(targetContributionType).getAttributeSet().getObject();
                            if (job.filter != null && !job.filter.accepts(targetObject)) {
                                allObjectsAcceptedByFilter = false;
                                continue;
                            }
                            relatedObjects.add(targetObject);
                        }
                        if (!allObjectsAcceptedByFilter) continue;
                        snippet.addCrossLinkRelation(relation.sample());
                        for (IRepositoryObject relatedObject : relatedObjects) {
                            ExportAgent.storeRelatedObjectInSnippet(relatedObject, job, asImplicitObjects, snippet, repositoryInterface, snapshot);
                        }
                    }
                }
            }
            if ((occurrenceRelationTypeSet = (ISet_)mappedOccurrenceRelationTypes.getByKey((Object)ancestorType.getRepositoryObjectTypeID())) != null) {
                for (ExportJob.OccurrenceRelationTypeAndContributionTypes relationTypeAndContributions : occurrenceRelationTypeSet) {
                    ICollection_<? extends IOccurrenceRepositoryRelation> occurrenceRelations = object.getAttributeSet(relationTypeAndContributions.occurrenceAttributeSetType).getProperty(relationTypeAndContributions.occurrencePropertyType).getOccurrenceRelations();
                    for (IOccurrenceRepositoryRelation occurrenceRelation : occurrenceRelations) {
                        IRepositoryObject targetObject = occurrenceRelation.getOccuringObject();
                        if (job.filter != null && !job.filter.accepts(targetObject)) continue;
                        snippet.addOccurrenceRelation(occurrenceRelation.sample());
                        ExportAgent.storeRelatedObjectInSnippet(targetObject, job, asImplicitObjects, snippet, repositoryInterface, snapshot);
                    }
                }
            }
            ancestorType = ancestorType.getAbstractSuperObjectType();
        }
    }

    private static void storeRelatedObjectInSnippet(IRepositoryObject object, ExportJob job, boolean asImplicitObjects, RepositorySnippetForExport snippet, IRepositoryInterfaceRO repositoryInterface, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, ImportExportException {
        if (asImplicitObjects) {
            ExportAgent.storeObjectTreeInSnippet(object, false, true, job, snippet, repositoryInterface, snapshot);
        } else {
            snippet.addContextObject(object.sample());
            ExportAgent.storeCategoryInSnippet(object, snippet);
        }
    }

    private static final void calculateObjectTypeToRelationTypeMappingForCrossRelations(Collection<IRepositoryRelationTypeID> crossRelationTypes, IMapRW_<IRepositoryObjectTypeID, ISetRW_<ExportJob.CrossRelationTypeAndContributionTypes>> crossLinkMap, IRepositoryTypeManagerRO typeManager) {
        for (IRepositoryRelationTypeID relationTypeID : crossRelationTypes) {
            ICrossLinkRepositoryRelationType crossRelationType = typeManager.findCrossLinkRelationType(relationTypeID);
            if (crossRelationType == null) continue;
            for (ICrossLinkRepositoryRelationType concreteRelationType : crossRelationType.getAllInstanciableRelationTypesOfThisType()) {
                for (ICrossLinkRepositoryRelationContributionType relationContributionType : concreteRelationType.getAllRelationContributionTypes()) {
                    IRepositoryObjectTypeID objectTypeID = relationContributionType.getRelatedObjectType().getRepositoryObjectTypeID();
                    ISetRW_ entry = (ISetRW_)crossLinkMap.getByKey((Object)objectTypeID);
                    if (entry == null) {
                        entry = new HashSet_(IHasher_.EQUALS_HASHER);
                        crossLinkMap.put((Object)objectTypeID, (Object)entry);
                    }
                    ExportJob.CrossRelationTypeAndContributionTypes relationAndContributions = new ExportJob.CrossRelationTypeAndContributionTypes();
                    relationAndContributions.relationType = concreteRelationType;
                    relationAndContributions.startContributionType = relationContributionType;
                    relationAndContributions.targetContributionTypes = new HashSet_(concreteRelationType.getAllRelationContributionTypes(), IAbstractRepositoryRelationContributionType.IS_EQUAL_IRELATION_CONTRIBUTION_HASHER);
                    relationAndContributions.targetContributionTypes.remove((Object)relationContributionType);
                    entry.add((Object)relationAndContributions);
                }
            }
        }
    }

    private static final void calculateObjectTypeToRelationTypeMappingForOccurrenceRelations(Collection<Tuple<IRepositoryObjectTypeID, IRepositoryPropertyTypeID>> occurrenceRelationTypes, IMapRW_<IRepositoryObjectTypeID, ISetRW_<ExportJob.OccurrenceRelationTypeAndContributionTypes>> occurrenceMap, IRepositoryTypeManagerRO typeManager) {
        for (Tuple<IRepositoryObjectTypeID, IRepositoryPropertyTypeID> relationType : occurrenceRelationTypes) {
            IRepositoryObjectTypeID objectTypeID = (IRepositoryObjectTypeID)relationType.getT1();
            IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
            ISetRW_ entry = (ISetRW_)occurrenceMap.getByKey((Object)objectTypeID);
            if (entry == null) {
                entry = new HashSet_(IHasher_.EQUALS_HASHER);
                occurrenceMap.put((Object)objectTypeID, (Object)entry);
            }
            ExportJob.OccurrenceRelationTypeAndContributionTypes relationAndContributions = new ExportJob.OccurrenceRelationTypeAndContributionTypes();
            relationAndContributions.occurrenceAttributeSetType = objectType.getAttributeSetType((IRepositoryPropertyTypeID)relationType.getT2());
            relationAndContributions.occurrencePropertyType = relationAndContributions.occurrenceAttributeSetType.getPropertyType((IRepositoryPropertyTypeID)relationType.getT2());
            entry.add((Object)relationAndContributions);
        }
    }

    private static final void findFileCustomPropertiesAndChildrenContributions(IRepositoryObjectType objectType, ExportJob job) {
        ArrayList<Object> fileProperties = new ArrayList<Object>();
        ArrayList<Object> childrenRelations = new ArrayList<Object>();
        for (IRepositoryAttributeSetType attributeSetType : objectType.getAttributeSetTypes()) {
            Object wrapper;
            for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                if (!IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)propertyType.getDataType().getRepositoryDataTypeID(), (Object)RDTFile.DATA_TYPE_ID)) continue;
                wrapper = new ExportJob.AttributeSetTypeAndPropertyType();
                ((ExportJob.AttributeSetTypeAndPropertyType)wrapper).attributeSetType = attributeSetType;
                ((ExportJob.AttributeSetTypeAndPropertyType)wrapper).propertyType = propertyType;
                fileProperties.add(wrapper);
            }
            for (IRepositoryObjectType childObjectType : attributeSetType.getChildObjectTypes()) {
                wrapper = new ExportJob.AttributeSetTypeAndChildrenRelation();
                ((ExportJob.AttributeSetTypeAndChildrenRelation)wrapper).attributeSetType = attributeSetType;
                ((ExportJob.AttributeSetTypeAndChildrenRelation)wrapper).childObjectType = childObjectType;
                childrenRelations.add(wrapper);
            }
        }
        job.map_objectType_fileProperties.put((Object)objectType.getRepositoryObjectTypeID(), fileProperties);
        job.map_objectType_childrenContributions.put((Object)objectType.getRepositoryObjectTypeID(), childrenRelations);
    }

    private static void storeCategoryInSnippet(IRepositoryObject object, RepositorySnippetForExport repositorySnippet) {
        IRepositoryObjectTypeCategory objectTypeCategory = object.getObjectTypeCategory();
        if (objectTypeCategory != null && !repositorySnippet.containsObjectTypeCategory(objectTypeCategory.getObjectTypeCategoryID())) {
            repositorySnippet.addObjectTypeCategory(objectTypeCategory.sample());
        }
    }
}

