/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.declaration.data.key;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.stringtools.StringCanonicalizer;

public class KeySegment {
    public static final IHasher_<KeySegment> IS_EQUAL_KEY_SEGMENT_HASHER = new IHasher_<KeySegment>(){

        public boolean isEqual(KeySegment key1, KeySegment key2) {
            return key1.isEqualKeySegment(key2);
        }

        public int getHashCode(KeySegment key) {
            return key.hashCodeForIsEqualKeySegment();
        }
    };
    private final String keySegmentString;

    public KeySegment(String keySegmentString) {
        assert (Assert.checkArgumentBeeingNotNull((Object)keySegmentString));
        assert (Assert.checkStringToBeNotEmpty((String)keySegmentString));
        assert (Assert.checkStringToContainNoInvalidCharacters((String)keySegmentString.substring(0, 1), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-"));
        assert (Assert.checkStringToContainNoInvalidCharacters((String)keySegmentString.substring(1), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789"));
        this.keySegmentString = StringCanonicalizer.getSystemWideCanonicalString((String)keySegmentString);
    }

    public final boolean isEqualKeySegment(KeySegment keySegmentToCompare) {
        assert (Assert.checkArgumentBeeingNotNull((Object)keySegmentToCompare));
        return this.keySegmentString == keySegmentToCompare.keySegmentString || this.keySegmentString.equals(keySegmentToCompare.keySegmentString);
    }

    public final int hashCodeForIsEqualKeySegment() {
        return this.keySegmentString.hashCode();
    }

    public final String toKeyString() {
        return this.keySegmentString;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.keySegmentString + ")";
    }
}

