/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectTypeCategoryDoesNotExist;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectTypeCategoryReference;
import java.util.ArrayList;
import java.util.Arrays;

public class REAModifyObjectTypeCategory
extends AbstractElementaryAction {
    private static final ILogger logger = Logger.getLogger(REAModifyObjectTypeCategory.class);
    private IRepositoryObjectReference objectToBeModified;
    private IRepositoryObjectTypeCategoryID newCategoryID;
    private IRepositoryObjectTypeCategoryID oldCatgeoryID;

    public REAModifyObjectTypeCategory(IRepositoryObjectReference objectToBeModified, IRepositoryObjectTypeCategoryID newCategory) {
        this.objectToBeModified = objectToBeModified;
        this.newCategoryID = newCategory;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        IRepositoryObjectTypeCategory newCategory;
        IRepositoryObjectTypeID objectTypeID = this.objectToBeModified.getObjectTypeID();
        IRepositoryObjectType objectType = snapshot.getTypeManager().getObjectType(objectTypeID);
        if (!(this.newCategoryID == null || (newCategory = snapshot.getObjectTypeCategory(this.newCategoryID)) != null && newCategory.getObjectType().isSuperTypeOf(objectType))) {
            throw new EXObjectTypeCategoryDoesNotExist((IRepositoryObjectTypeCategoryReference)new RepositoryObjectTypeCategoryReference(this.objectToBeModified), this.newCategoryID);
        }
        IRepositoryObject object = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.objectToBeModified, (IRepositorySnapshotRO)snapshot);
        if (this.oldCatgeoryID == null) {
            IRepositoryObjectTypeCategory oldCategory = object.getObjectTypeCategory();
            this.oldCatgeoryID = oldCategory != null ? oldCategory.getObjectTypeCategoryID() : null;
        }
        snapshot.modifyObjectTypeCategory(object, this.newCategoryID);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        try {
            locks.addAll(Arrays.asList(LockHelper.lockWholeObject(object)));
            this.setLocks(locks.toArray(new AbstractRepositoryLockSample[locks.size()]));
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error((Throwable)e);
            this.rollback(snapshot);
            throw e;
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (this.objectToBeModified != null);
        assert (this.oldCatgeoryID != null);
        IRepositoryObject object = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.objectToBeModified, (IRepositorySnapshotRO)snapshot);
        snapshot.modifyObjectTypeCategory(object, this.oldCatgeoryID);
        this.oldCatgeoryID = null;
    }

    public String getName() {
        return "Modify Object Type Category Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REAModifyObjectTypeCategory clone = (REAModifyObjectTypeCategory)((Object)super.clone());
        clone.objectToBeModified = this.objectToBeModified;
        clone.newCategoryID = this.newCategoryID;
        return clone;
    }
}

