/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.module;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.module.RepositoryModuleType;
import com.arcway.repository.implementation.registration.type.relation.OccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;

public class RTAMTRegisterOccurrenceRelationType
implements IRegistrationAction {
    private final RepositoryModuleType relatedModuleType;
    private final OccurrenceRepositoryRelationType relationType;

    public RTAMTRegisterOccurrenceRelationType(RepositoryModuleType relatedModuleType, OccurrenceRepositoryRelationType relationType) {
        Assert.checkArgumentBeeingNotNull((Object)relatedModuleType);
        Assert.checkArgumentBeeingNotNull((Object)relationType);
        this.relatedModuleType = relatedModuleType;
        this.relationType = relationType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryRelationTypeID, OccurrenceRepositoryRelationType> allRelationTypes = this.relatedModuleType.allOccurenceRelationTypesOfThisModuleType;
        IRepositoryRelationTypeID relationTypeID = this.relationType.getRepositoryRelationTypeID();
        Assert.checkState((!allRelationTypes.containsKey((Object)relationTypeID) ? 1 : 0) != 0);
        allRelationTypes.put((Object)relationTypeID, (Object)this.relationType);
    }

    @Override
    public void undo() {
        IRepositoryRelationTypeID relationTypeID = this.relationType.getRepositoryRelationTypeID();
        IMapRW_<IRepositoryRelationTypeID, OccurrenceRepositoryRelationType> allRelationTypes = this.relatedModuleType.allOccurenceRelationTypesOfThisModuleType;
        Assert.checkState((boolean)allRelationTypes.containsKey((Object)relationTypeID));
        allRelationTypes.removeAsEntry((Object)relationTypeID);
    }
}

