/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IListIteratorRW_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.item.RepositoryItemType;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.type.item.IRepositoryItemTypeID;

public class RTATMRegisterItemType
implements IRegistrationAction {
    private final RepositoryTypeManager typeManager;
    private final RepositoryItemType itemType;

    public RTATMRegisterItemType(RepositoryTypeManager typeManager, RepositoryItemType itemType) {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)itemType);
        this.typeManager = typeManager;
        this.itemType = itemType;
    }

    @Override
    public void dodo() {
        IRepositoryItemTypeID itemTypeID = this.itemType.getRepositoryItemTypeID();
        IListRW_<RepositoryItemType> listOfAllItemTypes = this.typeManager.listOfAllItemTypes;
        for (RepositoryItemType currentItemType : listOfAllItemTypes) {
            if (!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)currentItemType.getRepositoryItemTypeID(), (Object)itemTypeID)) continue;
            Assert.checkState((boolean)false);
        }
        listOfAllItemTypes.add((Object)this.itemType);
    }

    @Override
    public void undo() {
        IRepositoryItemTypeID itemTypeID = this.itemType.getRepositoryItemTypeID();
        IListRW_<RepositoryItemType> listOfAllItemTypes = this.typeManager.listOfAllItemTypes;
        boolean removed = false;
        IListIteratorRW_ i = listOfAllItemTypes.iterator();
        while (!removed && i.hasNext()) {
            RepositoryItemType currentItemType = (RepositoryItemType)i.next();
            if (!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)currentItemType.getRepositoryItemTypeID(), (Object)itemTypeID)) continue;
            i.remove();
            removed = true;
        }
        if (!removed) {
            Assert.checkState((boolean)false);
        }
    }
}

