/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;

public abstract class RTAHookType
implements IRegistrationAction {
    private final RepositoryTypeManager typeManager;
    private final IListRW_<IRegistrationAction> actions = new ArrayList_();

    public RTAHookType(RepositoryTypeManager typeManager) {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        this.typeManager = typeManager;
    }

    protected final RepositoryTypeManager getTypeManager() {
        return this.typeManager;
    }

    protected final void addRegistrationAction(IRegistrationAction registrationAction) {
        Assert.checkArgumentBeeingNotNull((Object)registrationAction);
        this.actions.add((Object)registrationAction);
    }

    @Override
    public final void dodo() {
        int i = 0;
        while (i < this.actions.size()) {
            IRegistrationAction currentAction = (IRegistrationAction)this.actions.get(i);
            currentAction.dodo();
            ++i;
        }
    }

    @Override
    public final void undo() {
        int i = this.actions.size() - 1;
        while (i >= 0) {
            IRegistrationAction currentAction = (IRegistrationAction)this.actions.get(i);
            currentAction.undo();
            --i;
        }
    }
}

