/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVTransformedViewPart;
import com.arcway.planagent.planview.view.PVView;

public class PVLegendView
extends PVPlanViewPart {
    private final PVView legends = new PVView();
    private final double maxHeight;

    public PVLegendView() {
        this.maxHeight = -1.0;
    }

    public PVLegendView(double maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public void drawFigure(Device device) {
        this.legends.drawFigure(device);
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return this.legends.getOuterBoundsWithoutChildren();
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        return this.legends.isInside(p, tolerance);
    }

    public PVView getLegends() {
        return this.legends;
    }

    public void addLowerLeftLegend(PVPlanViewPart legend, double dx, double dy) {
        Rectangle rect = legend.getOuterBoundsWithoutChildren();
        Point lowerLeft = rect == null ? Point.ORIGIN : new Point(rect.upperLeft.x, rect.lowerRight.y);
        PVTransformedViewPart trafoViewPart = new PVTransformedViewPart(legend);
        if (this.maxHeight == -1.0 || rect != null && rect.h() <= this.maxHeight) {
            GeoVector v = new GeoVector(-lowerLeft.x + dx, -lowerLeft.y - dy);
            Rectangle leftRect = this.legends.getOuterBoundsWithoutChildren();
            if (leftRect != null) {
                v = new GeoVector(v.x + leftRect.lowerRight.x, v.y);
            }
            TransformationAffiliate translation = TransformationAffiliate.newTransformationTranslation((GeoVector)v);
            trafoViewPart.setPlan2canvasTrafo(translation);
        } else if (rect != null && rect.h() > this.maxHeight) {
            double scalingFactor = this.maxHeight / rect.h();
            GeoVector scalingVector = new GeoVector(scalingFactor, scalingFactor);
            TransformationAffiliate scaling = TransformationAffiliate.newTransformationScaling((GeoVector)scalingVector);
            GeoVector v = new GeoVector(-lowerLeft.x * scalingFactor + dx, -lowerLeft.y * scalingFactor - dy);
            Rectangle leftRect = this.legends.getOuterBoundsWithoutChildren();
            if (leftRect != null) {
                v = new GeoVector(v.x + leftRect.lowerRight.x, v.y);
            }
            TransformationAffiliate translation = TransformationAffiliate.newTransformationTranslation((GeoVector)v);
            TransformationAffiliate concatenation = TransformationAffiliate.newTransformationNOP();
            concatenation.addFirst(scaling);
            concatenation.addLast(translation);
            trafoViewPart.setPlan2canvasTrafo(concatenation);
        }
        this.legends.addChild(trafoViewPart);
    }

    public void addLowerRightLegend(PVPlanViewPart legend, double dx, double dy) {
        Rectangle rect = legend.getOuterBoundsWithoutChildren();
        Point lowerRight = rect == null ? Point.ORIGIN : rect.lowerRight;
        GeoVector v = new GeoVector(-lowerRight.x - dx, -lowerRight.y - dy);
        Rectangle rightRect = this.legends.getOuterBoundsWithoutChildren();
        if (rightRect != null) {
            v = new GeoVector(v.x + rightRect.upperLeft.x, v.y);
        }
        TransformationAffiliate translation = TransformationAffiliate.newTransformationTranslation((GeoVector)v);
        PVTransformedViewPart trafoViewPart = new PVTransformedViewPart(legend);
        trafoViewPart.setPlan2canvasTrafo(translation);
        this.legends.addChild(trafoViewPart);
    }
}

