/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.ACMoveFigures;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.List;

public class TAMoveFigures
extends Transaction {
    private final List figures;
    private final GeoVector distance;

    private static IPMFigureRW getFirstFigure(List l) {
        assert (l != null) : "figure list is null";
        assert (l.size() > 0) : "figure list is empty";
        return (IPMFigureRW)l.get(0);
    }

    public TAMoveFigures(List figures, ActionParameters actionParameters, GeoVector distance) {
        super(TAMoveFigures.getFirstFigure(figures), actionParameters);
        assert (distance != null) : "distance object is null";
        this.figures = figures;
        this.distance = distance;
    }

    @Override
    public ActionIterator getActionIterator() {
        ACMoveFigures moveFigureAction = new ACMoveFigures(this.getActionContext(), this.figures, this.distance, true);
        PredeterminedActionIterator moveActionIterator = new PredeterminedActionIterator(1);
        moveActionIterator.addAction(moveFigureAction);
        return moveActionIterator;
    }

    @Override
    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        return this.figures;
    }

    public String toString() {
        return "TAMoveFigures (Figure list " + this.figures + ")";
    }
}

