/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ConcatenatingActionIterator;
import com.arcway.planagent.planmodel.reactions.CreateAnchoringsActionIterator;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.RoutingWhileDestinationsHaveChangedActionIterator;
import com.arcway.planagent.planmodel.routing.RouterContext;
import java.util.Collection;

public class RAFixAnchoringsAfterFiguresMoved
implements IRAMoveFigure {
    private static final ILogger logger = Logger.getLogger(RAFixAnchoringsAfterFiguresMoved.class);

    @Override
    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figureMovements + ") - start");
        }
        RouterContext routingParameters = new RouterContext(figureMovements);
        Collection<IPMFigureRW> movedFigures = figureMovements.getMovedFigures();
        RoutingWhileDestinationsHaveChangedActionIterator routingWhileDestinationsHaveChanged = new RoutingWhileDestinationsHaveChangedActionIterator(movedFigures, movedFigures, actionContext, routingParameters);
        CreateAnchoringsActionIterator createAnchoringsActionIterator = new CreateAnchoringsActionIterator(movedFigures, movedFigures, actionContext);
        ConcatenatingActionIterator reactionIterator = new ConcatenatingActionIterator(2);
        reactionIterator.addActionIterator(routingWhileDestinationsHaveChanged);
        reactionIterator.addActionIterator(createAnchoringsActionIterator);
        if (logger.isTraceEnabled()) {
            logger.trace("createReactions(List, ActionContext) - end - return value = " + reactionIterator);
        }
        return reactionIterator;
    }
}

