/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.planagent.planmodel.access.readonly.IPMViewableRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMViewableRW;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import java.util.Collection;

public abstract class PMViewable
extends PMPlanModelObject
implements IPMViewableRO,
IPMViewableRW {
    private boolean outerBoundsCacheIsValid = false;
    private Rectangle outerBoundsCache = null;
    private boolean pointUnionCacheIsValid = false;
    private Rectangle pointUnionCache = null;
    private boolean trafoCacheIsValid = false;
    private TransformationAffiliate trafoCache = null;

    protected PMViewable(PlanModelMgr planModelMgr) {
        super(planModelMgr);
    }

    public abstract Collection getChildViewables();

    @Override
    public Collection<IPMViewableRO> getChildIPMViewableROs() {
        return this.getChildViewables();
    }

    @Override
    public Collection<IPMViewableRW> getChildIPMViewableRWs() {
        return this.getChildViewables();
    }

    protected abstract PMViewable getParentViewable();

    public Rectangle getInnerBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildren();
    }

    public abstract Rectangle getOuterBoundsWithoutChildren();

    public abstract Rectangle getPointUnionWithoutChildren();

    @Override
    public final TransformationAffiliate getOptionalTransformation() {
        if (!this.trafoCacheIsValid) {
            this.trafoCache = this.calculateOptionalTransformation();
            this.trafoCacheIsValid = true;
        }
        return this.trafoCache;
    }

    protected TransformationAffiliate calculateOptionalTransformation() {
        return null;
    }

    public Rectangle getOuterBounds() {
        if (!this.outerBoundsCacheIsValid) {
            this.outerBoundsCache = this.getOuterBoundsWithoutChildren();
            for (PMViewable viewable : this.getChildViewables()) {
                this.outerBoundsCache = this.outerBoundsCache == null ? viewable.getOuterBounds() : this.outerBoundsCache.union(viewable.getOuterBounds());
            }
            this.outerBoundsCacheIsValid = true;
        }
        return this.outerBoundsCache;
    }

    public Rectangle getPointUnion() {
        if (!this.pointUnionCacheIsValid) {
            this.pointUnionCache = this.getPointUnionWithoutChildren();
            for (PMViewable viewable : this.getChildViewables()) {
                this.pointUnionCache = this.pointUnionCache == null ? viewable.getPointUnion() : this.pointUnionCache.union(viewable.getPointUnion());
            }
            this.pointUnionCacheIsValid = true;
        }
        return this.pointUnionCache;
    }

    protected void flushGeometryCaches() {
        this.flushBoundsCache();
        PMViewable parentViewable = this.getParentViewable();
        if (parentViewable != null) {
            parentViewable.flushGeometryCaches();
        }
    }

    protected void flushBoundsCache() {
        this.outerBoundsCacheIsValid = false;
        this.pointUnionCacheIsValid = false;
        this.trafoCacheIsValid = false;
    }
}

