/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.actions.ACSetPositionAnchor;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;

public class ACSetPositionAnchorRelativePositionAndOffSet
extends ACSetPositionAnchor {
    private final double relativePosition;
    private final GeoVector offSet;
    private GeoVector oldOffSet;

    public ACSetPositionAnchorRelativePositionAndOffSet(ActionContext actionContext, IPMAnchorRW anchor, double relativePosition, GeoVector offSet) {
        super(actionContext, anchor);
        assert (relativePosition <= 1.0 && relativePosition >= 0.0) : "relativePosition should be between 0 and 1";
        this.relativePosition = relativePosition;
        assert (offSet != null) : "ref to GeoVector is null";
        this.offSet = offSet;
    }

    @Override
    protected void initializeState() {
        this.oldOffSet = this.getAnchor().getOffset();
    }

    @Override
    protected void setStateToPost() {
        this.getAnchor().setRelativePosition(this.relativePosition);
        this.getAnchor().setOffset(this.offSet);
    }

    @Override
    protected void setStateToPre() {
        this.getAnchor().setRelativePosition(this.relativePosition);
        this.getAnchor().setOffset(this.oldOffSet);
    }

    @Override
    public boolean isDupe(Action a) {
        ACSetPositionAnchorRelativePositionAndOffSet dupeA;
        boolean isDupe = false;
        if (a instanceof ACSetPositionAnchorRelativePositionAndOffSet && (dupeA = (ACSetPositionAnchorRelativePositionAndOffSet)a).getAnchor() == this.getAnchor() && dupeA.getRelativePosition() == this.getRelativePosition() && dupeA.getOffSet() == this.getOffSet()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    public GeoVector getOffSet() {
        return this.offSet;
    }

    public double getRelativePosition() {
        return this.relativePosition;
    }

    public String toString() {
        return "ACSetPositionAnchorRelativePositionAndOffSet (relative position " + this.relativePosition + ", offset" + this.offSet + ")";
    }
}

