/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import java.util.ArrayList;
import java.util.Collection;

public class ACMove2Points1Line
extends ACMovePoint {
    private IPMLineRW line;
    private boolean isFirstLine;
    private IPMPointRW endPoint;
    private Point sourcePositionEndPoint;
    private Point targetPositionEndPoint;

    public ACMove2Points1Line(ActionContext context, IPMPointRW point, GeoVector distance, boolean removeSourceAnchorings) {
        super(context, point, distance, removeSourceAnchorings);
        if (Geo.equals((double)distance.x, (double)0.0)) {
            if (this.getPoint().getLine1stRW() != null && this.getPoint().getLine1stRW().getForce() == 2) {
                this.line = this.getPoint().getLine1stRW();
                this.isFirstLine = true;
            } else {
                this.line = this.getPoint().getLine2ndRW();
                this.isFirstLine = false;
            }
        } else if (Geo.equals((double)distance.y, (double)0.0)) {
            if (this.getPoint().getLine1stRW() != null && this.getPoint().getLine1stRW().getForce() == 3) {
                this.line = this.getPoint().getLine1stRW();
                this.isFirstLine = true;
            } else {
                this.line = this.getPoint().getLine2ndRW();
                this.isFirstLine = false;
            }
        } else if (this.getPoint().getLine1stRW() != null && this.getPoint().getLine1stRW().getForce() != 1) {
            this.line = this.getPoint().getLine1stRW();
            this.isFirstLine = true;
        } else {
            this.line = this.getPoint().getLine2ndRW();
            this.isFirstLine = false;
        }
        this.endPoint = this.isFirstLine ? this.line.getPoint1stRW() : this.line.getPoint2ndRW();
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        this.sourcePositionEndPoint = this.endPoint.getPosition();
        if (this.line.getForce() == 2) {
            GeoVector h_vector = new GeoVector(0.0, this.getDistance().y);
            this.targetPositionEndPoint = this.sourcePositionEndPoint.movePoint(h_vector);
        } else {
            assert (this.line.getForce() == 3) : "line should have vertical force";
            GeoVector v_vector = new GeoVector(this.getDistance().x, 0.0);
            this.targetPositionEndPoint = this.sourcePositionEndPoint.movePoint(v_vector);
        }
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.endPoint.setPosition(this.targetPositionEndPoint);
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        this.endPoint.setPosition(this.sourcePositionEndPoint);
    }

    @Override
    public boolean isDupe(Action a) {
        ACMove2Points1Line dupeA;
        boolean isDupe = false;
        if (a instanceof ACMove2Points1Line && (dupeA = (ACMove2Points1Line)a).getPoint() == this.getPoint() && dupeA.getDistance() == this.getDistance()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    protected Collection getPrimaryAnchoringSourceContributors() {
        return super.getPrimaryAnchoringSourceContributors();
    }

    @Override
    protected Collection getSecondaryAnchoringSourceContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(super.getSecondaryAnchoringSourceContributors());
        anchoringContributors.add(this.endPoint);
        if (this.isFirstLine) {
            if (this.endPoint.getLine1stRW() != null) {
                anchoringContributors.add(this.endPoint.getLine1stRW());
            }
        } else if (this.endPoint.getLine2ndRW() != null) {
            anchoringContributors.add(this.endPoint.getLine2ndRW());
        }
        return anchoringContributors;
    }

    @Override
    protected Collection getAnchoringDestinationContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(super.getAnchoringDestinationContributors());
        anchoringContributors.add(this.endPoint);
        if (this.isFirstLine) {
            if (this.endPoint.getLine1stRW() != null) {
                anchoringContributors.add(this.endPoint.getLine1stRW());
            }
        } else if (this.endPoint.getLine2ndRW() != null) {
            anchoringContributors.add(this.endPoint.getLine2ndRW());
        }
        return anchoringContributors;
    }

    @Override
    public String toString() {
        return "ACMove2Points1Line ()";
    }
}

