/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionTool;
import com.arcway.planagent.planmodel.actions.CheckerTool;
import com.arcway.planagent.planmodel.anchoring.AnchoringAgent;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ACAbstractMovePlanElementStructure
extends Action {
    private final List planElements;
    private final boolean removeSourceAnchorings;

    public ACAbstractMovePlanElementStructure(ActionContext actionContext, List planElements, boolean removeSourceAnchorings) {
        super(actionContext);
        assert (planElements.size() > 0) : "size of planElements <= 0";
        assert (CheckerTool.checkContainsIPMPlanElementRWsOnly(planElements));
        this.planElements = planElements;
        this.removeSourceAnchorings = removeSourceAnchorings;
    }

    protected abstract GeoVector getDistance(IPMPlanElementRW var1);

    @Override
    protected void setStateToPost() {
        for (IPMPlanElementRW planElement : this.planElements) {
            GeoVector distance = this.getDistance(planElement);
            ActionTool.movePlanElement(planElement, distance);
        }
    }

    @Override
    protected void setStateToPre() {
        for (IPMPlanElementRW planElement : this.planElements) {
            GeoVector distance = this.getDistance(planElement);
            ActionTool.movePlanElement(planElement, distance.turn180());
        }
    }

    @Override
    public boolean isDupe(Action a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNop() {
        boolean isNop = true;
        int i = 0;
        while (isNop && i < this.planElements.size()) {
            IPMPlanElementRW planElement = (IPMPlanElementRW)this.planElements.get(i);
            if (this.getDistance(planElement).abs() > 1.0E-10) {
                isNop = false;
            }
            ++i;
        }
        return isNop;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        ActionIterator preActionIterator;
        if (!this.isNop() && this.removeSourceAnchorings) {
            ActionIterator removeAnchoringActionIterator;
            AnchoringAgent anchoringAgent = this.getPlanModelMgr().getAnchoringAgent();
            preActionIterator = removeAnchoringActionIterator = anchoringAgent.removeAnchorings(this.planElements, this.planElements, this.getActionContext());
        } else {
            preActionIterator = ActionIterator.EMPTY_ACTION_ITERATOR;
        }
        return preActionIterator;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(this.planElements.size());
        for (IPMPlanElementRW planElement : this.planElements) {
            changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(planElement, 2));
        }
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        FigureMovements figureMovements = new FigureMovements();
        ArrayList<IPMGraphicalSupplementRW> movedSupplements = new ArrayList<IPMGraphicalSupplementRW>();
        int e = 0;
        while (e < this.planElements.size()) {
            IPMPlanElementRW planElement = (IPMPlanElementRW)this.planElements.get(e);
            GeoVector distance = this.getDistance(planElement);
            int i = 0;
            while (i < planElement.getFigureCount()) {
                IPMFigureRW figure = planElement.getFigureRW(i);
                figureMovements.addMovement(figure, distance);
                int j = 0;
                while (j < figure.getGraphicalSupplementCount()) {
                    movedSupplements.add(figure.getGraphicalSupplementRW(j));
                    ++j;
                }
                ++i;
            }
            ++e;
        }
        HashMap movedSupplementsWithGeometry = New.hashMap((int)movedSupplements.size());
        for (IPMGraphicalSupplementRW supplement : movedSupplements) {
            movedSupplementsWithGeometry.put(supplement, null);
        }
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionMoveFiguresAgent().getEntryForCompressedList(figureMovements, this.getActionContext()));
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(movedSupplementsWithGeometry, this.getActionContext()));
        return reactions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        IPMPlanElementRW onePlanElement = (IPMPlanElementRW)this.planElements.get(0);
        IPMPlanRW semanticalUnit = onePlanElement.getPlanRW();
        return semanticalUnit;
    }

    public List getPlanElements() {
        return this.planElements;
    }

    public String toString() {
        return "ACAbstractMovePlanElementStructure (plan elements " + this.planElements + ")";
    }
}

