/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.implementation;

import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementLegendRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMPlanElementLegendRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMPlanElementComment;
import com.arcway.planagent.planmodel.cm.routing.ResizeSupplementFittingStraightLineRouter;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.transactions.ForceValidFiguresTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.List;

public class PMPlanElementLegend
extends PMPlanElementComment
implements IPMPlanElementLegendRO,
IPMPlanElementLegendRW {
    public static final String XML_TYPE = "fmc.cm.legend";
    public static final String XML_SUPPLEMENT_TEXT_ROLE = "text";
    private static String DEFAULT_NAME = "Legend";

    public PMPlanElementLegend(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public PMPlanElementLegend(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    protected PMPlanElementLegend(PMPlan plan) {
        super(plan.getPlanModelMgr(), plan);
        this.setType(XML_TYPE);
        this.setup();
    }

    public TopologyType getToplogyType() {
        return TopologyType.FLAT;
    }

    private void setup() {
        super.setName(DEFAULT_NAME);
    }

    public PMFigurePlane getOutlineFigurePlane() {
        return (PMFigurePlane)this.getOutlineFigure();
    }

    public boolean isBendable(PMFigure figure) {
        assert (this.getFigureIndex(figure) >= 0);
        if (figure.getRole().equals("outline")) {
            return true;
        }
        return super.isBendable(figure);
    }

    @Override
    public IPMFigurePlaneRO getOutlineFigurePlaneRO() {
        return this.getOutlineFigurePlane();
    }

    @Override
    public IPMFigurePlaneRW getOutlineFigurePlaneRW() {
        return this.getOutlineFigurePlane();
    }

    public PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = (PMFigure)this.getOutlineFigure();
        assert (outlineFigure != null) : "outlineFigure is NULL.";
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_TEXT_ROLE);
        assert (supplementRefs != null) : "supplementRefs is NULL.";
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1) : "supplementRefs contains more than 1 element";
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, graphicalSupplementText, comment);
    }

    @Override
    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    @Override
    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public ITransactionValidator getTransactionValidator() {
        return new ForceValidFiguresTransactionValidator((IPMPlanElementRO)this);
    }

    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null) : "ref to graphSuppl is null";
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW())) : "the graSuppl does not belong to this planelement";
        if (this.getComment() == graphSuppl) {
            return new ResizeSupplementFittingStraightLineRouter(graphSuppl);
        }
        return super.getResizeSupplementRouter(graphSuppl);
    }

    @Override
    public String getCommentTextRole() {
        return XML_SUPPLEMENT_TEXT_ROLE;
    }

    @Override
    public IPMFigureRW getFigureToCommentRW() {
        return this.getOutlineFigureRW();
    }

    @Override
    public boolean removeFillColorWhenFirstChildIsAdded() {
        return false;
    }
}

