/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.oc.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Line;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.bpre.oc.check.OCValidityMatrix;
import com.arcway.planagent.planmodel.bpre.oc.relations.BPREOCRelationMatrix;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouter;
import com.arcway.planagent.planmodel.cm.routing.ElongationToFigureOutlineRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;

public class PMPlanBPREOC
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "bpre.oc";
    private static String XML_TYPE = "bpre.oc";

    public PMPlanBPREOC(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public PMPlanBPREOC(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return new String[]{"bpre.oc.position", "bpre.oc.edge", "fmc.cm.lineshapecomment", "fmc.cm.planecomment", "fmc.cm.dotscomment", "fmc.cm.legend"};
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = true;
        IPMFigureRO fig1 = source.getAnchoringFigure();
        IPMFigureRO fig2 = destination.getAnchoringFigure();
        return isDesirable |= OCValidityMatrix.isTouchValid(fig1, fig2);
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= OCValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= OCValidityMatrix.isPointToPointAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationPoint)destination);
            }
            if (destination instanceof IAnchoringDestinationLine) {
                isAllowed |= OCValidityMatrix.isPointToLineAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationLine)destination);
            }
        } else if (source instanceof IAnchoringSourceLine && destination instanceof IAnchoringDestinationLine) {
            isAllowed = true;
        }
        return isAllowed;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router = anchoring instanceof IAnchoringPoint2Figure ? new CurveLineRouter() : (anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : (anchoring instanceof IAnchoringPoint2Line ? new ElongationToFigureOutlineRouter() : new RemoveAnchoringRouter()));
        return router;
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        return true;
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        int direction = BPREOCRelationMatrix.getDirection((ILineMarkerAppearanceRO)lineStartMarkerAppearanceRO, (ILineMarkerAppearanceRO)lineEndMarkerAppearanceRO);
        if (direction != -1) {
            if (direction == 2) {
                if (BPREOCRelationMatrix.isAccess(startPlanElementType, endElementType)) {
                    return new PlanElementRelation(0, direction);
                }
            } else if (BPREOCRelationMatrix.isContainment(startPlanElementType, endElementType)) {
                return new PlanElementRelation(2, direction);
            }
        }
        return null;
    }

    public FlowType getFlowType() {
        return FlowType.VERTICAL;
    }
}

