/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.standalone;

import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IImageDataProvider;
import com.arcway.lib.graphics.image.ImageDataProviders;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import de.plans.lib.eclipse.ResourceLoader;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;

public class StandalonePlanInfo
implements IPlanInfo {
    private IPathEditorInput input;
    static final IImageDataProvider LOGO = ImageDataProviders.createImageDataProvider((IImageData)new SWTImageData(ResourceLoader.getImageDescriptor((String)"arcwaybig.jpg", (Plugin)FMCAPlanEditorPlugin.getDefault()).getImageData(), false, null));

    public StandalonePlanInfo(IPathEditorInput input) {
        this.input = input;
    }

    public String getPlanName() {
        File file = this.input.getPath().toFile();
        String extension = this.input.getPath().getFileExtension();
        extension = extension == null ? "" : "." + extension;
        String fileNameWithExtension = file.getName();
        String fileNameWithoutExtension = fileNameWithExtension.substring(0, fileNameWithExtension.length() - extension.length());
        return fileNameWithoutExtension;
    }

    public String getVersion() {
        return "";
    }

    public Boolean isCurrentVersion() {
        return null;
    }

    public String getFullQualifiedPlanNamePath() {
        String parent = this.input.getPath().toFile().getParent();
        if (parent == null) {
            return "";
        }
        return parent;
    }

    public String getFullQualifiedPlanNameName() {
        return this.input.getPath().toOSString();
    }

    public String getCreator() {
        return "";
    }

    public Date getCreationDate() {
        return null;
    }

    public String getModifier() {
        return "";
    }

    public Date getModificationDate() {
        return new Date(this.input.getPath().toFile().lastModified());
    }

    public String getProjectName() {
        if (this.input instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.input).getFile().getProject().getName();
        }
        return this.getFullQualifiedPlanNamePath();
    }

    public String getCopyrightNotice() {
        return String.valueOf(Messages.getString("StandalonePlanInfo.CreatedWith")) + " ARCWAY COCKPIT Plan Editor (http://www.arcway.com)";
    }

    public IImageDataProvider getLogo() {
        return LOGO;
    }

    void setInput(IPathEditorInput input) {
        this.input = input;
    }

    public IPlanInfo.RestrictionClass getRestrictionClass() {
        return RESTRICTIONS_ALWAYS_SHOW_METAINFORMATION;
    }

    public Locale getTargetLocale() {
        return Locale.getDefault();
    }

    public Map<String, String> getDefaultElementRoles() {
        return null;
    }
}

