/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks;

import com.arcway.planagent.planeditor.pagebooks.AbstractPageBookPage;
import com.arcway.planagent.planeditor.pagebooks.IPageBookContentProvider;
import com.arcway.planagent.planeditor.pagebooks.IPageBookViewDescriptor;
import de.plans.lib.util.Logger;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public abstract class AbstractPageBookMgr {
    private static final Logger logger = Logger.getLogger(AbstractPageBookMgr.class);
    private final IWorkbenchPart workbenchPart;
    private AbstractPageBookPage page;
    private final IPageBookViewDescriptor pageBookViewDescriptor;

    public AbstractPageBookMgr(IWorkbenchPart facade, IPageBookViewDescriptor pageBookViewDescriptor) {
        assert (facade != null);
        assert (pageBookViewDescriptor != null);
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] Creating Mgr ...");
        }
        this.workbenchPart = facade;
        this.pageBookViewDescriptor = pageBookViewDescriptor;
        this.setContentProvider(null);
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] ... Mgr created.");
        }
    }

    public Object getAdapter(Class type) {
        AbstractPageBookPage o = null;
        if (type == this.pageBookViewDescriptor.getPageClass()) {
            if (logger.isDebugEnabled(70)) {
                if (this.page == null) {
                    logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] page requested via adapter --> no page available");
                } else {
                    logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] page requested via adapter --> page returned");
                }
            }
            o = this.page;
        }
        return o;
    }

    public Object getAdapterForPage(Class type) {
        return this.workbenchPart.getAdapter(type);
    }

    protected final void setContentProvider(IPageBookContentProvider contentProvider) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] Installing view");
        }
        if (this.page == null) {
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] Creating view page ...");
            }
            this.page = this.pageBookViewDescriptor.createPage(this);
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] ... view page created.");
            }
        }
        this.page.setContentProvider(contentProvider);
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] ... installation finished.");
        }
    }

    protected final void openView() {
        IViewPart paletteView = this.workbenchPart.getSite().getPage().findView(this.pageBookViewDescriptor.getViewID());
        if (paletteView == null) {
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] View is not opened --> open!");
            }
            IWorkbenchPart activePart = this.workbenchPart.getSite().getPage().getActivePart();
            try {
                try {
                    this.workbenchPart.getSite().getPage().showView(this.pageBookViewDescriptor.getViewID());
                }
                catch (PartInitException e) {
                    logger.error((Object)"Could not open palette.", (Throwable)e);
                    this.workbenchPart.getSite().getPage().activate(activePart);
                }
            }
            finally {
                this.workbenchPart.getSite().getPage().activate(activePart);
            }
        } else {
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] View is already opened --> bring on top!");
            }
            paletteView.getViewSite().getPage().bringToTop((IWorkbenchPart)paletteView);
        }
    }

    protected final void closeViewIfNotNeededAnymore() {
        IViewPart paletteView = this.workbenchPart.getSite().getPage().findView(this.pageBookViewDescriptor.getViewID());
        if (paletteView == null) {
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] View is not opened --> don't close!");
            }
        } else if (logger.isDebugEnabled(70)) {
            logger.debug(70, (Object)".. [ABSTRACT_PAGEBOOK_MGR] View is already opened --> close view if needed!");
        }
    }
}

