/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.planagent.planeditor.edit.Utilities;
import de.plans.lib.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public final class SelectionManager {
    private static final Logger logger = Logger.getLogger(SelectionManager.class);
    private static final int LOWEST_SELECTION_LEVEL = Integer.MAX_VALUE;

    public void addItem(EditPart item, EditPartViewer viewer) {
        assert (item != null) : "EditPart is null";
        assert (viewer != null) : "viewer is null";
        if (item.isSelectable()) {
            Vector<EditPart> selection = new Vector<EditPart>(1);
            selection.add(item);
            this.addItems(selection, viewer);
        } else {
            logger.warn((Object)("Attempt to add non-selectable item to selection - addItem( item = " + item + " , viewer = " + viewer + " )"));
        }
    }

    public void addItems(List items, EditPartViewer viewer) {
        assert (items != null) : "List of EditParts is null";
        assert (viewer != null) : "viewer is null";
        List currentSelection = this.getSelectedItems(viewer);
        this.setOrAddNewSelection(currentSelection, items, viewer);
    }

    public void removeItem(EditPart item, EditPartViewer viewer) {
        assert (item != null) : "EditPart is null";
        viewer.deselect(item);
    }

    public void removeItems(List items, EditPartViewer viewer) {
        assert (items != null) : "List of EditParts is null";
        List currentSelection = this.getSelectedItems(viewer);
        ArrayList newSelection = new ArrayList(currentSelection.size());
        newSelection.addAll(currentSelection);
        int itemIndex = 0;
        while (itemIndex < items.size()) {
            newSelection.remove(items.get(itemIndex));
            ++itemIndex;
        }
        viewer.setSelection((ISelection)new StructuredSelection(newSelection));
        newSelection.clear();
    }

    public void clearSelection(EditPartViewer viewer) {
        assert (viewer != null) : "viewer is null";
        viewer.deselectAll();
    }

    public void replaceSelection(EditPart item, EditPartViewer viewer) {
        assert (item != null) : "EditPart is null";
        assert (viewer != null) : "viewer is null";
        if (item.isSelectable()) {
            ArrayList<EditPart> selection = new ArrayList<EditPart>(1);
            selection.add(item);
            this.replaceSelection(selection, viewer);
        } else {
            logger.warn((Object)("Attempt to replace current selection with non-selectable item - replaceSelection( item = " + item + " , viewer = " + viewer + " )"));
        }
    }

    public void replaceSelection(List items, EditPartViewer viewer) {
        assert (items != null) : "List of EditParts is null";
        assert (viewer != null) : "viewer is null";
        this.setOrAddNewSelection(Collections.EMPTY_LIST, items, viewer);
    }

    public int getSelectionLevel(EditPartViewer viewer) {
        assert (viewer != null) : "viewer is null";
        List selection = viewer.getSelectedEditParts();
        if (selection.size() > 0) {
            int returnint = Utilities.getLevelOfEditPart((EditPart)selection.get(0));
            return returnint;
        }
        return Integer.MAX_VALUE;
    }

    public List getSelectedItems(EditPartViewer viewer) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getSelectedItems(EditPartViewer viewer = " + viewer + ") - start"));
        }
        List returnList = viewer.getSelectedEditParts();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getSelectedItems(EditPartViewer) - end - return value = " + returnList));
        }
        return returnList;
    }

    private void setOrAddNewSelection(List currentSelection, List items, EditPartViewer viewer) {
        int currentLevel;
        ArrayList<EditPart> temporarySelection = new ArrayList<EditPart>(items.size() + currentSelection.size());
        temporarySelection.addAll(currentSelection);
        int itemIndex = 0;
        while (itemIndex < items.size()) {
            EditPart item = (EditPart)items.get(itemIndex);
            if (item.isSelectable()) {
                temporarySelection.add(item);
            } else {
                logger.warn((Object)("Attempt to add non-selectable item to selection - addItems( items = " + items + " , viewer = " + viewer + " )"));
            }
            ++itemIndex;
        }
        int highestLevel = Integer.MAX_VALUE;
        for (EditPart editPart : currentSelection) {
            currentLevel = Utilities.getLevelOfEditPart(editPart);
            highestLevel = Math.max(highestLevel, currentLevel);
        }
        for (EditPart editPart : temporarySelection) {
            currentLevel = Utilities.getLevelOfEditPart(editPart);
            highestLevel = Math.min(highestLevel, currentLevel);
        }
        ArrayList<EditPart> newSelection = new ArrayList<EditPart>(temporarySelection.size());
        int itemIndex2 = 0;
        while (itemIndex2 < temporarySelection.size()) {
            EditPart item = (EditPart)temporarySelection.get(itemIndex2);
            if ((item = Utilities.getEditPartAtLevel(item, highestLevel)).isSelectable() && !newSelection.contains(item)) {
                newSelection.add(item);
            }
            ++itemIndex2;
        }
        viewer.setSelection((ISelection)new StructuredSelection(newSelection));
        temporarySelection.clear();
    }
}

