/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.planeditor.edit.ComparableAnchoring;
import com.arcway.planagent.planeditor.edit.ComparablePointAnchoring;
import com.arcway.planagent.planeditor.figures.PFDifferentLayerViewFigure;
import com.arcway.planagent.planeditor.figures.PFPlan;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToAnchorRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringRO;
import com.arcway.planagent.planmodel.access.readonly.IPMContainmentRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMGraphicalSupplementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanModelObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMSemanticalUnitRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanDummy;
import com.arcway.planagent.planmodel.nonpermanent.PMArrow;
import com.arcway.planagent.planmodel.nonpermanent.PMMarker;
import com.arcway.planagent.planmodel.transactions.Transaction;
import com.arcway.planagent.planview.view.HighlightHint;
import com.arcway.planagent.planview.view.IViewPartMgr;
import com.arcway.planagent.planview.view.PVManagedViewPart;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;

public class FeedbackCreationTool {
    private static final PMPlan DUMMYPLAN = PMPlanDummy.createDummyPlan();
    private static final Color CONTAINMENT_CREATED_CORONACOLOR = Color.GREEN;
    private static final double CORONA_WIDTH = 0.4;
    private static final Color GHOST_COLOR = new Color(170, 170, 172);
    private static final LineMarker ANCHORING_REMOVE_MARKER_STYLE = LineMarker.CROSS;
    private static final Color ANCHORING_REMOVE_MARKER_COLOR = new Color(200, 64, 128);
    private static final FillColor ANCHORING_REMOVE_MARKER_FILLCOLOR = FillColor.TRANSPARENT;
    private static final double ANCHORING_REMOVE_MARKER_SIZE = 0.35277777777777775;
    private static final double ANCHORING_REMOVE_MARKER_ANGLE = 0.0;
    private static final LineMarker ANCHORING_CREATE_MARKER_STYLE = LineMarker.DOT;
    private static final LineMarker ANCHORING_CREATE_TO_ANCHOR_MARKER_STYLE = LineMarker.DIAMOND;
    private static final Color ANCHORING_CREATE_MARKER_COLOR = new Color(64, 240, 32);
    private static final Color ANCHORING_CREATE_TO_ANCHOR_MARKER_COLOR = new Color(128, 64, 255);
    private static final Color ANCHORING_CREATE_EVIL_MARKER_COLOR = new Color(255, 0, 96);
    private static final FillColor ANCHORING_CREATE_MARKER_FILLCOLOR = FillColor.TRANSPARENT;
    private static final FillColor ANCHORING_CREATE_TO_ANCHOR_MARKER_FILLCOLOR = FillColor.TRANSPARENT;
    private static final FillColor ANCHORING_CREATE_EVIL_MARKER_FILLCOLOR = FillColor.TRANSPARENT;
    private static final double ANCHORING_CREATE_MARKER_SIZE = 0.35277777777777775;
    private static final double ANCHORING_CREATE_TO_ANCHOR_MARKER_SIZE = 0.17638888888888887;
    private static final double ANCHORING_CREATE_MARKER_ANGLE = 0.0;
    private static final ILineAppearanceRO GUIDE_LINE_PRIMARY_APPEARANCE = new LineAppearance(new Color(100, 165, 255), LineStyle.DASH, 0.35277777777777775);
    private static final ILineAppearanceRO GUIDE_LINE_SECONDARY_APPEARANCE = new LineAppearance(new Color(120, 200, 255), LineStyle.DASHDOT, 0.35277777777777775);
    private static final ILineMarkerAppearance GUIDE_LINE_START_MARKER_APPEARANCE = new LineMarkerAppearance();
    private static final ILineMarkerAppearanceRO GUIDE_LINE_END_MARKER_APPEARANCE;
    private static ViewCreator viewCreator;

    static {
        GUIDE_LINE_START_MARKER_APPEARANCE.setLineMarkerStyle(LineMarker.NONE);
        GUIDE_LINE_END_MARKER_APPEARANCE = GUIDE_LINE_START_MARKER_APPEARANCE;
        viewCreator = new ViewCreator();
    }

    public static PFDifferentLayerViewFigure createFigure(IViewPartMgr viewPartMgr, PFPlan planFigure, Transaction transaction) {
        Rectangle clippingRectangleInPlanCoordinates = viewPartMgr.getVisiblePlanClipInPlanCoordinates();
        PVPlanViewPart feedbackViewPart = FeedbackCreationTool.createFeedbackView(transaction, clippingRectangleInPlanCoordinates);
        PVManagedViewPart managedFeedbackViewPart = new PVManagedViewPart(viewPartMgr, feedbackViewPart);
        PFDifferentLayerViewFigure feedbackFigure = new PFDifferentLayerViewFigure((IFigure)planFigure, managedFeedbackViewPart);
        return feedbackFigure;
    }

    private static PVPlanViewPart createFeedbackView(Transaction transaction, Rectangle clippingRectangleInPlanCoordinates) {
        ComparableAnchoring comparableAnchoring;
        Object change;
        PVView feedback = new PVView();
        HashSet<IPMPlanElementRO> changedPlanElements = new HashSet<IPMPlanElementRO>();
        HashSet<IPMFigureRO> changedFigures = new HashSet<IPMFigureRO>();
        HashSet<IPMGraphicalSupplementRO> changedSupplements = new HashSet<IPMGraphicalSupplementRO>();
        HashSet<ComparablePointAnchoring> removedAnchorings = new HashSet<ComparablePointAnchoring>();
        HashSet<ComparablePointAnchoring> createdAnchorings = new HashSet<ComparablePointAnchoring>();
        ArrayList<IPMContainmentRO> createdContainments = new ArrayList<IPMContainmentRO>();
        for (Object element : transaction.getChanges()) {
            IPMPlanElementRO planElement;
            change = (IModelChangeRO)element;
            IPMPlanModelObjectRO modelObject = change.getPlanModelObjectRO();
            IPMSemanticalUnitRO semanticalUnit = modelObject.getISemanticalUnitRO();
            if (modelObject instanceof IPMPlanElementRO) {
                planElement = (IPMPlanElementRO)modelObject;
                int i = 0;
                while (i < planElement.getFigureCount()) {
                    IPMFigureRO figure = planElement.getFigureRO(i);
                    if (figure instanceof IPMFigurePlaneRO) {
                        changedFigures.add(figure);
                    }
                    ++i;
                }
            } else {
                IPMPlanObjectRO changedPlanObject;
                if (modelObject instanceof IPMPlanObjectRO) {
                    changedPlanObject = (IPMPlanObjectRO)modelObject;
                } else if (modelObject instanceof IPMPointListRO) {
                    IPMPointListRO pointList = (IPMPointListRO)modelObject;
                    changedPlanObject = pointList.getPlanObjectRO();
                } else {
                    changedPlanObject = null;
                }
                if (changedPlanObject != null) {
                    if (changedPlanObject instanceof IPMFigurePlaneRO) {
                        IPMFigureRO figure = (IPMFigureRO)changedPlanObject;
                        changedFigures.add(figure);
                    } else if (changedPlanObject instanceof IPMGraphicalSupplementRO) {
                        IPMGraphicalSupplementRO graphicalSupplement = (IPMGraphicalSupplementRO)changedPlanObject;
                        changedSupplements.add(graphicalSupplement);
                    }
                }
            }
            if (semanticalUnit instanceof IPMPlanElementRO) {
                planElement = (IPMPlanElementRO)semanticalUnit;
                switch (change.getType()) {
                    case 1: 
                    case 2: {
                        changedPlanElements.add(planElement);
                    }
                }
                continue;
            }
            if (!(semanticalUnit instanceof IPMPlanRO)) continue;
            if (modelObject instanceof IPMAnchoringPointRO) {
                switch (change.getType()) {
                    case 1: {
                        createdAnchorings.add(new ComparablePointAnchoring((IPMAnchoringPointRO)modelObject));
                        break;
                    }
                    case 3: {
                        removedAnchorings.add(new ComparablePointAnchoring((IPMAnchoringPointRO)modelObject));
                    }
                }
            }
            if (!(modelObject instanceof IPMContainmentRO)) continue;
            IPMContainmentRO containment = (IPMContainmentRO)modelObject;
            switch (change.getType()) {
                case 1: {
                    createdContainments.add(containment);
                }
            }
        }
        HashSet<ComparableAnchoring> dupes = new HashSet<ComparableAnchoring>();
        for (ComparableAnchoring comparableAnchoring2 : createdAnchorings) {
            ComparableAnchoring anchoring = comparableAnchoring2;
            if (!removedAnchorings.contains(anchoring)) continue;
            dupes.add(anchoring);
        }
        change = dupes.iterator();
        while (change.hasNext()) {
            ComparableAnchoring comparableAnchoring3;
            ComparableAnchoring dupe = comparableAnchoring3 = (ComparableAnchoring)change.next();
            createdAnchorings.remove(dupe);
            removedAnchorings.remove(dupe);
        }
        boolean bl = transaction.getState();
        transaction.setState(true);
        HashSet<Object> changedPlanObjects = changedFigures.isEmpty() ? changedSupplements : changedFigures;
        GuideLineCollector guideLineCollector = new GuideLineCollector();
        Iterator iterator = changedPlanObjects.iterator();
        while (iterator.hasNext()) {
            IPMPlanObjectRO planObjectRO;
            IPMPlanObjectRO planObject = planObjectRO = (IPMPlanObjectRO)iterator.next();
            FeedbackCreationTool.collectGuideLines(planObject, guideLineCollector);
        }
        guideLineCollector.addFeedback(feedback, clippingRectangleInPlanCoordinates);
        iterator = createdContainments.iterator();
        while (iterator.hasNext()) {
            IPMContainmentRO ipmContainmentRO;
            IPMContainmentRO containment = ipmContainmentRO = (IPMContainmentRO)iterator.next();
            FeedbackCreationTool.addFigureFeedbackCreateContainment(feedback, containment.getContainedPlanElementRO());
        }
        iterator = changedPlanElements.iterator();
        while (iterator.hasNext()) {
            IPMPlanElementRO ipmPlanElementRO;
            IPMPlanElementRO planElement = ipmPlanElementRO = (IPMPlanElementRO)iterator.next();
            FeedbackCreationTool.addPlanElementFeedback(feedback, planElement);
        }
        transaction.setState(false);
        iterator = removedAnchorings.iterator();
        while (iterator.hasNext()) {
            ComparableAnchoring anchoring = comparableAnchoring = (ComparableAnchoring)iterator.next();
            FeedbackCreationTool.addFigureFeedbackRemoveAnchoring(feedback, anchoring.getAnchoring());
        }
        transaction.setState(true);
        iterator = removedAnchorings.iterator();
        while (iterator.hasNext()) {
            ComparableAnchoring anchoring = comparableAnchoring = (ComparableAnchoring)iterator.next();
            boolean recreated = false;
            Iterator iterator2 = createdAnchorings.iterator();
            while (iterator2.hasNext()) {
                ComparableAnchoring comparableAnchoring2;
                ComparableAnchoring createdAnchoring = comparableAnchoring2 = (ComparableAnchoring)iterator2.next();
                if (anchoring.getSource() != createdAnchoring.getSource()) continue;
                recreated = true;
                break;
            }
            if (recreated) continue;
            FeedbackCreationTool.addFigureFeedbackRemoveAnchoring(feedback, anchoring.getAnchoring());
        }
        iterator = createdAnchorings.iterator();
        while (iterator.hasNext()) {
            ComparableAnchoring anchoring = comparableAnchoring = (ComparableAnchoring)iterator.next();
            FeedbackCreationTool.addFigureFeedbackCreateAnchoring(feedback, anchoring.getAnchoring());
        }
        transaction.setState(bl);
        return feedback;
    }

    private static void addPlanElementFeedback(PVView feedback, IPMPlanElementRO planElement) {
        HighlightHint hint = new HighlightHint(Color.TRANSPARENT, -1.0, GHOST_COLOR, 0.8, true);
        viewCreator.createPVView((Object)planElement, hint, feedback, true, HighlightLevel.BUSINESS, false, false);
    }

    private static void addFigureFeedbackRemoveAnchoring(PVView feedback, IPMAnchoringRO anchoring) {
        if (anchoring instanceof IPMAnchoringPointRO) {
            IPMAnchoringPointRO anchoringPoint = (IPMAnchoringPointRO)anchoring;
            PMMarker marker = new PMMarker(DUMMYPLAN, anchoringPoint.getPointRO().getPosition(), ANCHORING_REMOVE_MARKER_STYLE, ANCHORING_REMOVE_MARKER_COLOR, ANCHORING_REMOVE_MARKER_FILLCOLOR, 0.35277777777777775, 0.0);
            viewCreator.createPVView((Object)marker, new HighlightHint(), feedback, true, HighlightLevel.BUSINESS, false, false);
        }
    }

    private static void collectGuideLines(IPMPlanObjectRO planObject, GuideLineCollector guideLineCollector) {
        IPMPointListRO pointList = planObject.getPointListRO();
        int i = 0;
        while (i < pointList.getLineCount()) {
            IPMLineRO line = pointList.getLineRO(i);
            guideLineCollector.collect(line);
            ++i;
        }
    }

    private static void addFigureFeedbackCreateAnchoring(PVView feedback, IPMAnchoringRO anchoring) {
        if (anchoring instanceof IPMAnchoringPointRO) {
            IPMAnchoringPointRO anchoringPoint = (IPMAnchoringPointRO)anchoring;
            LineMarker style = anchoring instanceof IPMAnchoringPointToAnchorRO ? ANCHORING_CREATE_TO_ANCHOR_MARKER_STYLE : ANCHORING_CREATE_MARKER_STYLE;
            double size = anchoring instanceof IPMAnchoringPointToAnchorRO ? 0.17638888888888887 : 0.35277777777777775;
            Color color = anchoring instanceof IPMAnchoringPointToAnchorRO ? ANCHORING_CREATE_TO_ANCHOR_MARKER_COLOR : ANCHORING_CREATE_MARKER_COLOR;
            color = anchoring.isDesirable() ? color : ANCHORING_CREATE_EVIL_MARKER_COLOR;
            FillColor fillColor = anchoring instanceof IPMAnchoringPointToAnchorRO ? ANCHORING_CREATE_TO_ANCHOR_MARKER_FILLCOLOR : ANCHORING_CREATE_MARKER_FILLCOLOR;
            fillColor = anchoring.isDesirable() ? fillColor : ANCHORING_CREATE_EVIL_MARKER_FILLCOLOR;
            PMMarker marker = new PMMarker(DUMMYPLAN, anchoringPoint.getPointRO().getPosition(), style, color, fillColor, size, 0.0);
            viewCreator.createPVView((Object)marker, new HighlightHint(), feedback, true, HighlightLevel.BUSINESS, false, false);
        }
    }

    private static void addFigureFeedbackVerticalLine(PVView feedback, double xPosition, ILineAppearanceRO lineAppearance, Rectangle clippingRectangle) {
        if (xPosition >= clippingRectangle.x() && xPosition <= clippingRectangle.lowerRight.x) {
            Line position = new Line(xPosition, clippingRectangle.y(), xPosition, clippingRectangle.lowerRight.y);
            PMArrow marker = new PMArrow(DUMMYPLAN, position, lineAppearance, (ILineMarkerAppearanceRO)GUIDE_LINE_START_MARKER_APPEARANCE, GUIDE_LINE_END_MARKER_APPEARANCE);
            viewCreator.createPVView((Object)marker, new HighlightHint(), feedback, true, HighlightLevel.BUSINESS, false, false);
        }
    }

    private static void addFigureFeedbackHorizontalLine(PVView feedback, double yPosition, ILineAppearanceRO lineAppearance, Rectangle clippingRectangle) {
        if (yPosition >= clippingRectangle.y() && yPosition <= clippingRectangle.lowerRight.y) {
            Line position = new Line(clippingRectangle.x(), yPosition, clippingRectangle.lowerRight.x, yPosition);
            PMArrow marker = new PMArrow(DUMMYPLAN, position, lineAppearance, (ILineMarkerAppearanceRO)GUIDE_LINE_START_MARKER_APPEARANCE, GUIDE_LINE_END_MARKER_APPEARANCE);
            viewCreator.createPVView((Object)marker, new HighlightHint(), feedback, true, HighlightLevel.BUSINESS, false, false);
        }
    }

    private static void addFigureFeedbackCreateContainment(PVView feedback, IPMPlanElementRO pmPlanElement) {
        HighlightHint hint = new HighlightHint(CONTAINMENT_CREATED_CORONACOLOR, 0.4);
        viewCreator.createPVView((Object)pmPlanElement, hint, feedback, true, HighlightLevel.BUSINESS, false, false);
    }

    private static class GuideLineCollector {
        double topMost = Double.POSITIVE_INFINITY;
        double leftMost = Double.POSITIVE_INFINITY;
        double rightMost = Double.NEGATIVE_INFINITY;
        double lowerMost = Double.NEGATIVE_INFINITY;

        private GuideLineCollector() {
        }

        public void collect(IPMLineRO line) {
            int force = line.getForce();
            if (force == 2) {
                double y = line.getPoint1stRO().getPosition().y;
                this.topMost = Math.min(this.topMost, y);
                this.lowerMost = Math.max(this.lowerMost, y);
            } else if (force == 3) {
                double x = line.getPoint1stRO().getPosition().x;
                this.leftMost = Math.min(this.leftMost, x);
                this.rightMost = Math.max(this.rightMost, x);
            }
        }

        public void addFeedback(PVView feedback, Rectangle clippingRectangle) {
            FeedbackCreationTool.addFigureFeedbackHorizontalLine(feedback, this.topMost, GUIDE_LINE_PRIMARY_APPEARANCE, clippingRectangle);
            FeedbackCreationTool.addFigureFeedbackHorizontalLine(feedback, (this.topMost + this.lowerMost) / 2.0, GUIDE_LINE_SECONDARY_APPEARANCE, clippingRectangle);
            FeedbackCreationTool.addFigureFeedbackHorizontalLine(feedback, this.lowerMost, GUIDE_LINE_PRIMARY_APPEARANCE, clippingRectangle);
            FeedbackCreationTool.addFigureFeedbackVerticalLine(feedback, this.leftMost, GUIDE_LINE_PRIMARY_APPEARANCE, clippingRectangle);
            FeedbackCreationTool.addFigureFeedbackVerticalLine(feedback, (this.leftMost + this.rightMost) / 2.0, GUIDE_LINE_SECONDARY_APPEARANCE, clippingRectangle);
            FeedbackCreationTool.addFigureFeedbackVerticalLine(feedback, this.rightMost, GUIDE_LINE_PRIMARY_APPEARANCE, clippingRectangle);
        }
    }
}

