/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.eclipse.graphics.devicedrivers.DeviceDriverSWTGC;
import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverGetBounds;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class LineEndMarkerDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static LineEndMarkerDecoration singelton;
    private static ImageDescriptor image;

    static {
        image = ResourceLoader.getImageDescriptor((String)"linestyle.gif", (Plugin)FMCAPlanEditorPlugin.getDefault());
    }

    private LineEndMarkerDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineEndMarkerDecoration getInstance() {
        Class<LineEndMarkerDecoration> clazz = LineEndMarkerDecoration.class;
        synchronized (LineEndMarkerDecoration.class) {
            if (singelton == null) {
                singelton = new LineEndMarkerDecoration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    @Override
    public Class[] getAppearanceClasses() {
        return new Class[]{ILineEndMarkerAppearanceRO.class};
    }

    @Override
    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ILineEndMarkerAppearanceRO)appearance).getLineMarkerStyle();
    }

    @Override
    public String getToolTipText(Object state) {
        return this.getMenuEntryText(state);
    }

    @Override
    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return this.getMenuEntryImage(state);
    }

    @Override
    public ImageDescriptor getMenuEntryImage(Object state) {
        ImageData subImageData = image.getImageData();
        Image subImage = new Image(null, subImageData);
        int w = subImageData.width;
        int h = subImageData.height;
        subImage.dispose();
        Image labelImage = new Image((Device)Display.getCurrent(), w, h);
        GC g = new GC((Drawable)labelImage);
        Color bc = new Color(null, 0, 8, 8);
        g.setForeground(bc);
        g.setBackground(bc);
        g.fillRectangle(0, 0, w, h);
        bc.dispose();
        int transparentPixel = labelImage.getImageData().getPixel(0, 0);
        this.drawMuster(g, 2, 2, w - 4, h - 4, (LineMarker)state);
        g.dispose();
        final ImageData imageData = labelImage.getImageData();
        imageData.transparentPixel = transparentPixel;
        labelImage.dispose();
        ImageDescriptor desc = new ImageDescriptor(){

            public ImageData getImageData() {
                return imageData;
            }
        };
        return desc;
    }

    @Override
    public String getMenuEntryText(Object state) {
        LineMarker lineMarker = (LineMarker)state;
        String name = lineMarker == LineMarker.ARROW ? Messages.getString("LineEndMarkerDecoration.arrow") : (lineMarker == LineMarker.BOBBLE ? Messages.getString("LineEndMarkerDecoration.bobble") : (lineMarker == LineMarker.CROSS ? Messages.getString("LineEndMarkerDecoration.cross") : (lineMarker == LineMarker.DIAMOND ? Messages.getString("LineEndMarkerDecoration.diamond") : (lineMarker == LineMarker.DASH ? Messages.getString("LineEndMarkerDecoration.dash") : (lineMarker == LineMarker.DOT ? Messages.getString("LineEndMarkerDecoration.dot") : (lineMarker == LineMarker.NONE ? Messages.getString("LineEndMarkerDecoration.none") : (lineMarker == LineMarker.PEAKED_ARC ? Messages.getString("LineEndMarkerDecoration.peakedArc") : (lineMarker == LineMarker.PEAKED_ARC_FILLED ? Messages.getString("LineEndMarkerDecoration.peakedArcFilled") : (lineMarker == LineMarker.RHOMBUS ? Messages.getString("LineEndMarkerDecoration.rhombus") : (lineMarker == LineMarker.CIRCLE ? Messages.getString("LineEndMarkerDecoration.circle") : (lineMarker == LineMarker.ROUNDED_ARC ? Messages.getString("LineEndMarkerDecoration.roundedArc") : (lineMarker == LineMarker.ROUNDED_ARC_FILLED ? Messages.getString("LineEndMarkerDecoration.roundedArcFilled") : (lineMarker == LineMarker.TRIANGLE ? Messages.getString("LineEndMarkerDecoration.triangle") : lineMarker.getName())))))))))))));
        return name;
    }

    @Override
    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        LineMarkerAppearanceTpl template = new LineMarkerAppearanceTpl();
        template.setLineMarkerStyle((LineMarker)state);
        return new IAppearanceTpl[]{template};
    }

    private void drawMuster(GC gc, int x, int y, int w, int h, LineMarker state) {
        Rectangle clipping = gc.getClipping();
        gc.setClipping(x, y, w, h);
        DeviceDriverSWTGC deviceDriverSWTGC = new DeviceDriverSWTGC((Device)Display.getDefault(), gc, true);
        TransformationAffiliate trafo = Transformation.createTransformation((com.arcway.lib.geometry.Rectangle)new com.arcway.lib.geometry.Rectangle(0.0, 0.0, 100.0, 100.0), (com.arcway.lib.geometry.Rectangle)new com.arcway.lib.geometry.Rectangle((double)x, (double)y, new Dimension((double)w, (double)h)));
        com.arcway.lib.graphics.device.Device device = new com.arcway.lib.graphics.device.Device((IDeviceDriver)deviceDriverSWTGC, (Transformation)trafo);
        Corners corners = new Corners();
        corners.add((Point)new Corner(70.0, 50.0));
        corners.add((Point)new Corner(-50.0, 50.0));
        double width = 10.0;
        DeviceDriverGetBounds deviceDriverGetBounds = new DeviceDriverGetBounds();
        com.arcway.lib.graphics.device.Device testDevice = new com.arcway.lib.graphics.device.Device((IDeviceDriver)deviceDriverGetBounds, (Transformation)Transformation.NOP);
        state.draw(testDevice, new Point(0.0, 0.0), com.arcway.lib.graphics.Color.BLACK, width, FillColor.BLACK, 180.0, 0.0);
        deviceDriverGetBounds.dispose();
        com.arcway.lib.geometry.Rectangle bounds = deviceDriverGetBounds.getBounds();
        if (bounds != null) {
            width = Math.min(width * 50.0 / bounds.w(), width * 50.0 / bounds.h());
        }
        device.polyline(corners, width, com.arcway.lib.graphics.Color.BLACK, LineStyle.SOLID, state, LineMarker.NONE);
        deviceDriverSWTGC.dispose();
        gc.setClipping(clipping);
    }
}

