/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.IInternalAbstractPlanAgent;
import com.arcway.planagent.IInternalUpdatedPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planeditor.IInvalidPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerCommand;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorExtension;
import com.arcway.planagent.controllinginterface.planeditor.ISelectionRequest;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentTimestamp;
import com.arcway.planagent.planeditor.ExtensionMgr;
import com.arcway.planagent.planeditor.IModeChangedListener;
import com.arcway.planagent.planeditor.IPlanEditorConfig;
import com.arcway.planagent.planeditor.IProjector;
import com.arcway.planagent.planeditor.PATCHED_DeferredUpdateManager;
import com.arcway.planagent.planeditor.PATCHED_FreeformViewport;
import com.arcway.planagent.planeditor.PATCHED_ScrollingGraphicalViewer;
import com.arcway.planagent.planeditor.PlanEditorEditDomain;
import com.arcway.planagent.planeditor.PlanEditorFacade;
import com.arcway.planagent.planeditor.PlanEditorScalableFreeformRootEditPart;
import com.arcway.planagent.planeditor.actions.ActionMgr;
import com.arcway.planagent.planeditor.check.ICheckMgr;
import com.arcway.planagent.planeditor.commands.CMNOP;
import com.arcway.planagent.planeditor.commands.CommandExecuter;
import com.arcway.planagent.planeditor.dialogs.DialogSettingsStorage;
import com.arcway.planagent.planeditor.dialogs.InternalDialogSettings;
import com.arcway.planagent.planeditor.dialogs.PrintDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsEMFDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsPNGDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsSVGDialogSettings;
import com.arcway.planagent.planeditor.dialogs.SaveAsWMFDialogSettings;
import com.arcway.planagent.planeditor.dnd.AbstractDNDListener;
import com.arcway.planagent.planeditor.dnd.FMCAEditorDNDListener;
import com.arcway.planagent.planeditor.dnd.NativeFileDNDListener;
import com.arcway.planagent.planeditor.dnd.NativeTextDNDListener;
import com.arcway.planagent.planeditor.dnd.PaletteToEditorDNDListener;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.IClipboard;
import com.arcway.planagent.planeditor.edit.IEditorSpecialEventHandler;
import com.arcway.planagent.planeditor.edit.IZoomChangedListener;
import com.arcway.planagent.planeditor.edit.IZoomMgr;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planeditor.edit.PlanEditPartFactory;
import com.arcway.planagent.planeditor.framecom.ProjectorDelayer;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planeditor.pagebooks.overview.OverviewMgr;
import com.arcway.planagent.planeditor.pagebooks.palette.PaletteMgr;
import com.arcway.planagent.planeditor.tools.SelectionTool;
import com.arcway.planagent.planeditor.tools.ZoomTool;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import com.arcway.planagent.planviewer.PlanViewerExtension;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;

public class PlanEditor
extends PlanViewerExtension
implements IPlanEditorExtension,
IInternalUpdatedPlanAgentExtension,
CommandStackListener,
ISelectionListener,
IEditorSpecialEventHandler {
    private static final String EDITOR_ID = "com.arcway.planagent.planeditor";
    private static final String PLANEDITOR_CONTEXTMENU_ID = "com.arcway.planagent.planeditor.contextmenu";
    private static final String PLANEDITOR_CONTEXT_ID = "com.arcway.cockpit.context.planeditor";
    private static final ILogger logger = Logger.getLogger(PlanEditor.class);
    private final PlanEditorFacade editorFacade;
    private final IInternalAbstractPlanAgent planController;
    private final IPlanEditorControllerExtension controllerExtension;
    private int workingMode = 0;
    private PlanEditorEditDomain editDomain;
    private static DialogSettingsStorage dialogSettings;
    private final EditMgr editMgr;
    private ActionMgr actionMgr;
    private PaletteMgr paletteMgr;
    private OverviewMgr overviewMgr;
    private PATCHED_ScrollingGraphicalViewer graphicalViewer;
    private final Collection<IModeChangedListener> modeChangeListeners = new ArrayList<IModeChangedListener>();
    private SelectionSynchronizer selectionSynchronizer;

    public PlanEditor(IInternalAbstractPlanAgent abstractPlanAgent, IPlanEditorControllerExtension controllerExtension, int initialMode, IProgressDisplay progress, PlanEditorFacade editorFacade) throws EXSetupPlanException {
        super(abstractPlanAgent, progress);
        assert (controllerExtension != null);
        assert (editorFacade != null);
        this.editorFacade = editorFacade;
        this.controllerExtension = controllerExtension;
        this.planController = abstractPlanAgent;
        this.workingMode = initialMode;
        this.editMgr = new EditMgr(editorFacade.getShell());
    }

    void setup() {
        IPlanEditorConfig config = ExtensionMgr.getDefault().getPlanEditorConfigForPlanType(this.getPlan().getType());
        assert (config != null) : "No plan editor configuration found.";
        this.setEditDomain(new PlanEditorEditDomain(this.editorFacade.getSite().getShell().getDisplay(), this.controllerExtension, this.planController, config));
        this.editMgr.setup(this.getEditDomain());
        SelectionTool tool = new SelectionTool();
        this.getEditDomain().setDefaultTool(tool);
        this.getEditDomain().setActiveTool(this.getEditDomain().getDefaultTool());
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.editorFacade.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.createDialogSettings();
        this.actionMgr = new ActionMgr((IEditorPart)this.editorFacade);
        this.actionMgr.installActions(this.getWorkingMode());
        this.paletteMgr = new PaletteMgr((IWorkbenchPart)this.editorFacade);
        this.paletteMgr.installPalette(this.getPlan().getType(), this.getWorkingMode());
        this.overviewMgr = new OverviewMgr((IWorkbenchPart)this.editorFacade);
    }

    private synchronized void createDialogSettings() {
        if (dialogSettings == null) {
            dialogSettings = new DialogSettingsStorage();
        }
    }

    protected void viewerModelsChanged(Set modelChanges) {
        PEPlan plan = this.getPEPlan();
        if (plan != null) {
            this.getPEPlan().modelChanged(modelChanges);
        }
    }

    public int getWorkingMode() {
        return this.workingMode;
    }

    public int setWorkingMode(int mode, boolean discardChanges) throws EXWriteAccessDeniedException {
        try {
            if (mode != this.workingMode) {
                switch (mode) {
                    case 3: {
                        this.planController.setAccessingMode(1);
                        break;
                    }
                    case 1: {
                        this.planController.setAccessingMode(2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown working mode " + mode);
                    }
                }
            }
            this.workingMode = mode;
            if (discardChanges) {
                this.discardChanges(IProgressDisplay.DUMMY);
            }
            if (this.isDirty()) {
                logger.error("Plan is modified. -> Can not finish edit mode!");
            } else {
                this.initWorkingMode(mode);
                this.editorFacade.refreshPartName();
            }
            for (IModeChangedListener modeChangedListener : this.modeChangeListeners) {
                modeChangedListener.modeChanged(this.getWorkingMode());
            }
        }
        catch (EXWriteAccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not set working mode.", (Throwable)e);
        }
        return this.getWorkingMode();
    }

    public void addModeChangeListener(IModeChangedListener modeChangedListener) {
        assert (modeChangedListener != null);
        this.modeChangeListeners.add(modeChangedListener);
    }

    public void removeModeChangeListener(IModeChangedListener modeChangedListener) {
        assert (modeChangedListener != null);
        this.modeChangeListeners.remove(modeChangedListener);
    }

    public void executeCommand(IPlanEditorControllerCommand command, String label) {
        assert (command != null);
        CMNOP editorCommand = new CMNOP(this.getEditDomain(), label);
        editorCommand.setMgrCommand(command);
        CommandExecuter.execute(this.getCommandStack(), editorCommand);
    }

    public void selectPlanElements(List<? extends ISelectionRequest> selectionRequests) {
        IProjector projector = this.getProjector();
        if (projector != null) {
            projector.selectElements(selectionRequests);
        }
    }

    public void setInvalidPlanElements(List<? extends IInvalidPlanElement> invalidPlanElements) {
        IProjector projector = this.getProjector();
        if (projector != null) {
            projector.setInvalidPlanElements(invalidPlanElements);
        }
    }

    public IEditorPart getEditorPart() {
        return this.editorFacade;
    }

    public boolean isDirty() {
        boolean isDirty = false;
        CommandStack commandStack = null;
        if (this.getEditDomain() != null) {
            commandStack = this.getEditDomain().getCommandStack();
        }
        if (commandStack != null) {
            isDirty = commandStack.isDirty();
        }
        return isDirty;
    }

    void createPartControl(Composite parent) {
        this.setGraphicalViewer(new PATCHED_ScrollingGraphicalViewer());
        this.getEditDomain().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().createControl(parent);
        this.configureGraphicalViewer();
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.editorFacade.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlanEditor.this.initializeGraphicalViewer();
            }
        });
        MenuManager contextMenuManager = new MenuManager(null, PLANEDITOR_CONTEXTMENU_ID);
        PATCHED_ScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        final Menu menu = contextMenuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Tool activeTool = PlanEditor.this.getEditDomain().getActiveTool();
                if (activeTool instanceof ZoomTool) {
                    menu.setVisible(false);
                }
            }
        });
        this.editorFacade.getSite().registerContextMenu(PLANEDITOR_CONTEXTMENU_ID, contextMenuManager, (ISelectionProvider)viewer);
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext(PLANEDITOR_CONTEXT_ID);
        AbstractDNDListener dropListener = new FMCAEditorDNDListener(this.controllerExtension, (EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)dropListener);
        dropListener = new NativeTextDNDListener(this.controllerExtension, (EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)dropListener);
        dropListener = new NativeFileDNDListener(this.controllerExtension, (EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)dropListener);
        dropListener = new PaletteToEditorDNDListener((EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)dropListener);
        this.configureGrid(this.getWorkingMode());
    }

    protected void setEditDomain(PlanEditorEditDomain editDomain) {
        assert (editDomain != null);
        this.editDomain = editDomain;
    }

    protected PlanEditorEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public void commandStackChanged(EventObject event) {
        this.editorFacade.fireModifiedChange();
        this.actionMgr.updateStackActions();
    }

    protected void setGraphicalViewer(PATCHED_ScrollingGraphicalViewer graphicalViewer) {
        assert (graphicalViewer != null);
        this.graphicalViewer = graphicalViewer;
    }

    protected PATCHED_ScrollingGraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.selectionSynchronizer == null) {
            this.selectionSynchronizer = new SelectionSynchronizer();
        }
        return this.selectionSynchronizer;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IWorkbenchPage activePage = this.editorFacade.getSite().getWorkbenchWindow().getActivePage();
        if (activePage != null && this.editorFacade.equals(activePage.getActiveEditor())) {
            this.actionMgr.updateSelectionActions();
        }
    }

    void markSaveLocation() {
        this.getCommandStack().markSaveLocation();
    }

    public Object getAdapter(Class type) {
        Object adapter = null;
        if (type == CommandStackInspectorPage.class) {
            adapter = new CommandStackInspectorPage(this.getCommandStack());
        } else if (type == IInputContext.class) {
            adapter = this.editorFacade;
        } else if (type == IZoomMgr.class || type == IClipboard.class || type == ICheckMgr.class) {
            adapter = this.editMgr;
        } else if (type == PlanEditorEditDomain.class) {
            adapter = this.editDomain;
        } else if (type == PMPlan.class) {
            adapter = this.getPlan();
        } else if (type == PlanEditor.class) {
            adapter = this;
        } else if (type == InternalDialogSettings.class) {
            adapter = dialogSettings.getInternalDialogSettings();
        } else if (type == SaveAsPNGDialogSettings.class) {
            adapter = dialogSettings.getSaveAsImageDialogSettings();
        } else if (type == SaveAsSVGDialogSettings.class) {
            adapter = dialogSettings.getSaveAsSVGDialogSettings();
        } else if (type == SaveAsWMFDialogSettings.class) {
            adapter = dialogSettings.getSaveAsWMFDialogSettings();
        } else if (type == SaveAsEMFDialogSettings.class) {
            adapter = dialogSettings.getSaveAsEMFDialogSettings();
        } else if (type == PrintDialogSettings.class) {
            adapter = dialogSettings.getPrintPreviewDialogSettings();
        } else if (type == GraphicalViewer.class) {
            adapter = this.getGraphicalViewer();
        } else if (type == CommandStack.class) {
            adapter = this.getCommandStack();
        } else if (type == ActionRegistry.class) {
            adapter = this.actionMgr.getActionRegistry();
        }
        if (adapter == null) {
            adapter = this.paletteMgr.getAdapter(type);
        }
        if (adapter == null) {
            adapter = this.overviewMgr.getAdapter(type);
        }
        return adapter;
    }

    private void discardChanges(IProgressDisplay progress) throws EXSetupPlanException {
        this.planController.loadPlan(progress);
        this.getCommandStack().flush();
        this.editorFacade.refreshPartName();
        this.editorFacade.fireModifiedChange();
        PEPlan plan = this.getPEPlan();
        if (plan != null) {
            this.getPEPlan().refresh();
        }
    }

    private void initWorkingMode(int mode) throws EXPlanCreationException {
        ArrayList projectionRequests = new ArrayList(this.getAllProjectionRequests());
        ArrayList highlightRequests = new ArrayList(this.getAllHighlightRequests(HighlightLevel.BUSINESS));
        this.planController.resetPlan();
        ((PlanEditPartFactory)this.getGraphicalViewer().getEditPartFactory()).setMode(mode);
        this.getGraphicalViewer().setContents(this.getPlan());
        this.project(projectionRequests);
        this.highlightPlanElements(HighlightLevel.BUSINESS, highlightRequests);
        this.updateDecorators();
        this.getCommandStack().flush();
        this.actionMgr.changeMode(mode);
        this.paletteMgr.changeMode(mode);
        this.configureGrid(mode);
    }

    private void configureGrid(int mode) {
        Boolean enableGrid = false;
        if (mode == 1) {
            enableGrid = true;
            this.editMgr.addZoomChangedListener(new IZoomChangedListener(){

                @Override
                public void zoomChanged(double newZoom) {
                    Dimension d = new Dimension(5.0, 5.0);
                    d = d.transform((Transformation)PlanEditor.this.editMgr.getTransformationPlan2Canvas());
                    PlanEditor.this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", new PrecisionDimension(d.width, d.height));
                }
            });
            Dimension d = new Dimension(5.0, 5.0);
            d = d.transform((Transformation)this.editMgr.getTransformationPlan2Canvas());
            this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", new PrecisionDimension(d.width, d.height));
        }
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", enableGrid);
    }

    @Deprecated
    public PEPlan getPEPlan() {
        EditPart contents;
        PEPlan pEPlan = null;
        if (this.getGraphicalViewer() != null && (contents = this.getGraphicalViewer().getContents()) != null && contents instanceof PEPlan) {
            pEPlan = (PEPlan)contents;
        }
        return pEPlan;
    }

    private IProjector getProjector() {
        ProjectorDelayer projectorProxy = null;
        if (this.getGraphicalViewer().getControl() != null) {
            projectorProxy = new ProjectorDelayer((IWorkbenchPart)this.editorFacade, this, this.getGraphicalViewer().getControl().getDisplay());
        }
        return projectorProxy;
    }

    private void configureGraphicalViewer() {
        Control control = this.getGraphicalViewer().getControl();
        PlanEditorScalableFreeformRootEditPart root = new PlanEditorScalableFreeformRootEditPart();
        if (control instanceof FigureCanvas) {
            this.editMgr.setCanvas((FigureCanvas)control);
        }
        this.getGraphicalViewer().setEditMgr(this.editMgr);
        this.getGraphicalViewer().setRootEditPart((RootEditPart)root);
        this.getGraphicalViewer().setEditPartFactory(new PlanEditPartFactory(this.getWorkingMode(), this.editMgr, this.editorFacade, this.editDomain, this));
    }

    private void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents(this.getPlan());
        this.updateDecorators();
        PlanEditorScalableFreeformRootEditPart rootEditPart = (PlanEditorScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart();
        PATCHED_FreeformViewport rootFigure = (PATCHED_FreeformViewport)rootEditPart.getFigure();
        UpdateManager updateManager = rootFigure.getUpdateManager();
        updateManager.performUpdate();
        if (this.getWorkingMode() == 3) {
            this.editMgr.setCalculatedZoom(0);
        } else {
            this.editMgr.setCalculatedZoom(4);
        }
        if (updateManager instanceof PATCHED_DeferredUpdateManager) {
            PATCHED_DeferredUpdateManager fmcaDeferredUpdateManger = (PATCHED_DeferredUpdateManager)updateManager;
            fmcaDeferredUpdateManger.enableVisualisationUpdates();
        }
        this.overviewMgr.setGraphicalView((GraphicalViewer)this.getGraphicalViewer());
    }

    public IEditorContent getContent() {
        return new IEditorContent(){

            public IPlanInfo getPlanInfo() {
                return PlanEditor.this.planController.getPlanInfo();
            }

            public IPMPlanRO getPlanModel() {
                return PlanEditor.this.planController.getPlan();
            }
        };
    }

    public void dispose() {
        this.planController.closePlan();
        this.paletteMgr.removePalette();
        this.actionMgr.removeActions();
        this.editorFacade.getSite().setSelectionProvider(null);
        this.editorFacade.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        if (this.getEditDomain() != null) {
            this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
            this.getEditDomain().setActiveTool(null);
        }
        this.editMgr.dispose();
    }

    public void planInfoChanged() {
        this.editorFacade.refreshPartName();
    }

    public void planContentChanged() {
        try {
            this.setWorkingMode(this.getWorkingMode(), true);
        }
        catch (EXWriteAccessDeniedException e) {
            logger.error("Could not load new plan content.", (Throwable)e);
        }
    }

    public void setPlanElementTooltip(String planElementUID, String newTooltip) {
        for (Object o : this.getPEPlan().getChildren()) {
            PEPlanElement currentPlanElement;
            if (!(o instanceof PEPlanElement) || !(currentPlanElement = (PEPlanElement)o).getPMPlanElement().getUid().equals(planElementUID)) continue;
            currentPlanElement.setToolTip(newTooltip);
        }
    }

    public void updateDecorators() {
        IProjector projector = this.getProjector();
        if (projector != null) {
            projector.updateDecorators();
        }
    }

    public PlanAgentTimestamp getTimestamp() {
        PATCHED_ScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        PlanAgentTimestamp timestamp = viewer != null ? viewer.getTimestamp() : null;
        return timestamp;
    }
}

