/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.handles;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.geometry.snap.Grid;
import com.arcway.planagent.planeditor.cm.edit.PEGraphicalSupplementText;
import com.arcway.planagent.planeditor.commands.CMApplyTemplates;
import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.handles.AbstractHandle;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;

public class HandlePointTurnText
extends AbstractHandle
implements IHandlePoint {
    public static final boolean SHOW_TURN_TEXT_HANDLES = true;
    private static final double OFFSET = 30.0;
    private static final double SNAP = 9.0;
    private final PEGraphicalSupplementText peTextSupplement;

    public HandlePointTurnText(PEGraphicalSupplementText peTextSupplement, EditMgr viewManager, FeedbackManager feedbackManager, int type) {
        super((EditPart)peTextSupplement, viewManager, feedbackManager, type);
        assert (peTextSupplement != null);
        this.peTextSupplement = peTextSupplement;
    }

    public com.arcway.lib.geometry.Point getPosition() {
        TurnedRectangle textRectangle = this.getTextRectangle();
        return textRectangle.getCenter();
    }

    private TurnedRectangle getTextRectangle() {
        Points points = this.peTextSupplement.getPMPointList().getPoints();
        ITextAppearance textAppearance = this.peTextSupplement.getPMGraphicalSupplementText().getTextAppearance();
        Direction direction = textAppearance.getDirection();
        Insets insets = new Insets(0.0);
        TurnedRectangle textRectangle = PMGraphicalSupplementText.calculateTextRectangle((Points)points, (Direction)direction, (Insets)insets);
        return textRectangle;
    }

    public Command getCommand(Request request) {
        CMApplyTemplates returnCommand = null;
        if (request instanceof RQDragNDropHandle) {
            com.arcway.lib.geometry.Point to;
            RQDragNDropHandle requestDnD = (RQDragNDropHandle)request;
            Point toScreen = requestDnD.getTo();
            com.arcway.lib.geometry.Point from = this.getTextRectangle().getCenter();
            GeoVector translation = new GeoVector(from, to = this.transformToPlanCoordinates(toScreen));
            if (!translation.isZero()) {
                Direction newDirection = translation.getDirection().turn(90.0);
                newDirection = Direction.valueOf((double)Grid.snapPosition((double)newDirection.getAngle(), (double)0.0, (double)9.0));
                TextAppearanceTpl template = new TextAppearanceTpl();
                template.setDirection(newDirection);
                PMGraphicalSupplementText pmTextSupplement = this.peTextSupplement.getPMGraphicalSupplementText();
                ITextAppearanceRO textAppearance = pmTextSupplement.getTextAppearanceRO();
                TemplateApplicationTuple templateApplicationTuple = new TemplateApplicationTuple((IPMPlanObjectRO)pmTextSupplement, (IAppearanceRO)textAppearance);
                Set<TemplateApplicationTuple> templateApplicationTuples = Collections.singleton(templateApplicationTuple);
                HashMap<TextAppearanceTpl, Set<TemplateApplicationTuple>> templatesToTemplateApplicationTuples = new HashMap<TextAppearanceTpl, Set<TemplateApplicationTuple>>();
                templatesToTemplateApplicationTuples.put(template, templateApplicationTuples);
                returnCommand = new CMApplyTemplates(templatesToTemplateApplicationTuples, this.peTextSupplement.getCommandContext());
            }
        }
        return returnCommand;
    }

    public GeoVector getDirection() {
        return null;
    }

    public int getCommandType(String requestType) {
        int commandType = 1;
        if ("drag handle".equals(requestType)) {
            commandType = 4;
        }
        return commandType;
    }

    public GeoVector getOffsetInPixels() {
        Points points = this.peTextSupplement.getPMPointList().getPoints();
        ITextAppearance textAppearance = this.peTextSupplement.getPMGraphicalSupplementText().getTextAppearance();
        Direction direction = textAppearance.getDirection();
        Insets insets = textAppearance.getInsets();
        TurnedRectangle textRectangle = PMGraphicalSupplementText.calculateTextRectangle((Points)points, (Direction)direction, (Insets)insets);
        return textRectangle.getH().scaleToLength(30.0);
    }
}

